/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.generic.TikZWriter;
import com.cburch.logisim.gui.main.ExportImage;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.util.GifEncoder;
import com.cburch.logisim.util.JFileChoosers;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class PrintHandler
implements Printable {
    static File lastExportedFile;

    public static File getLastExported() {
        return lastExportedFile;
    }

    public static void setLastExported(File f) {
        lastExportedFile = f;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == LogisimMenuBar.PRINT) {
            this.print();
        } else if (src == LogisimMenuBar.EXPORT_IMAGE) {
            this.exportImage();
        }
    }

    public void print() {
        PageFormat format = new PageFormat();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this, format);
        if (!job.printDialog()) {
            return;
        }
        try {
            job.print();
        }
        catch (PrinterException e) {
            OptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), Strings.S.get("printError", e.toString()), Strings.S.get("printErrorTitle"), 0);
        }
    }

    @Override
    public int print(Graphics pg, PageFormat pf, int pageNum) {
        double imWidth = pf.getImageableWidth();
        double imHeight = pf.getImageableHeight();
        Graphics2D g = (Graphics2D)pg;
        g.translate(pf.getImageableX(), pf.getImageableY());
        return this.print(g, pf, pageNum, imWidth, imHeight);
    }

    public abstract int print(Graphics2D var1, PageFormat var2, int var3, double var4, double var6);

    public void exportImage() {
        int n;
        ExportImage.ImageFileFilter[] filters = new ExportImage.ImageFileFilter[]{ExportImage.getFilter(1), ExportImage.getFilter(0), ExportImage.getFilter(2), ExportImage.getFilter(3), ExportImage.getFilter(4)};
        JFileChooser chooser = JFileChoosers.createSelected(PrintHandler.getLastExported());
        chooser.setAcceptAllFileFilterUsed(false);
        for (ExportImage.ImageFileFilter imageFileFilter : filters) {
            chooser.addChoosableFileFilter(imageFileFilter);
        }
        chooser.setFileFilter(filters[0]);
        chooser.setDialogTitle(Strings.S.get("exportImageFileSelect"));
        int returnVal = chooser.showDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), Strings.S.get("exportImageButton"));
        if (returnVal != 0) {
            return;
        }
        File dest = chooser.getSelectedFile();
        FileFilter ff = null;
        for (ExportImage.ImageFileFilter filter : filters) {
            if (!filter.accept(dest)) continue;
            ff = filter;
        }
        if (ff == null) {
            ff = chooser.getFileFilter();
        }
        if (!ff.accept(dest)) {
            dest = ff == filters[0] ? new File(dest + ".png") : (ff == filters[1] ? new File(dest + ".gif") : (ff == filters[2] ? new File(dest + ".jpg") : (ff == filters[3] ? new File(dest + ".tex") : new File(dest + ".svg"))));
        }
        PrintHandler.setLastExported(dest);
        if (dest.exists() && (n = OptionPane.showConfirmDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), Strings.S.get("confirmOverwriteMessage"), Strings.S.get("confirmOverwriteTitle"), 0)) != 0) {
            return;
        }
        int n2 = ff == filters[0] ? 1 : (ff == filters[1] ? 0 : (ff == filters[2] ? 2 : (ff == filters[2] ? 3 : 4)));
        this.exportImage(dest, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportImage(File dest, int fmt) {
        Dimension d = this.getExportImageSize();
        if (d == null) {
            this.showErr("couldNotCreateImage");
            return;
        }
        BufferedImage img = new BufferedImage(d.width, d.height, 1);
        Graphics base = fmt == 3 || fmt == 4 ? new TikZWriter() : img.getGraphics();
        Graphics gr = base.create();
        try {
            if (!(gr instanceof Graphics2D)) {
                this.showErr("couldNotCreateImage");
                return;
            }
            Graphics2D g2d = (Graphics2D)gr;
            g2d.setColor(Color.white);
            g2d.fillRect(0, 0, d.width, d.height);
            g2d.setColor(Color.black);
            try {
                this.paintExportImage(img, g2d);
            }
            catch (Exception e) {
                this.showErr("couldNotCreateImage");
                gr.dispose();
                return;
            }
            try {
                switch (fmt) {
                    case 0: {
                        GifEncoder.toFile((Image)img, dest, null);
                        break;
                    }
                    case 1: {
                        ImageIO.write((RenderedImage)img, "PNG", dest);
                        break;
                    }
                    case 2: {
                        ImageIO.write((RenderedImage)img, "JPEG", dest);
                        break;
                    }
                    case 3: {
                        ((TikZWriter)g2d).writeFile(dest);
                        break;
                    }
                    case 4: {
                        ((TikZWriter)g2d).writeSvg(d.width, d.height, dest);
                    }
                }
            }
            catch (Exception e) {
                this.showErr("couldNotCreateFile");
                gr.dispose();
                return;
            }
        }
        finally {
            gr.dispose();
        }
    }

    public abstract Dimension getExportImageSize();

    public abstract void paintExportImage(BufferedImage var1, Graphics2D var2);

    private boolean showErr(String key) {
        Window parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        OptionPane.showMessageDialog(parent, Strings.S.get("couldNotCreateImage"));
        return true;
    }
}

