/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.LogisimFileActions;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.Library;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class ProjectLibraryActions {
    private ProjectLibraryActions() {
    }

    public static void doLoadBuiltinLibrary(Project proj) {
        Library[] libs;
        LogisimFile file = proj.getLogisimFile();
        List<Library> baseBuilt = file.getLoader().getBuiltin().getLibraries();
        ArrayList<Library> builtins = new ArrayList<Library>(baseBuilt);
        builtins.removeAll(file.getLibraries());
        if (builtins.isEmpty()) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("loadBuiltinNoneError"), Strings.S.get("loadBuiltinErrorTitle"), 1);
            return;
        }
        LibraryJList list = new LibraryJList(builtins);
        JScrollPane listPane = new JScrollPane(list);
        int action = OptionPane.showConfirmDialog(proj.getFrame(), listPane, Strings.S.get("loadBuiltinDialogTitle"), 2, 3);
        if (action == 0 && (libs = list.getSelectedLibraries()) != null) {
            proj.doAction(LogisimFileActions.loadLibraries(libs, proj.getLogisimFile()));
        }
    }

    public static void doLoadJarLibrary(Project proj) {
        Loader loader = proj.getLogisimFile().getLoader();
        JFileChooser chooser = loader.createChooser();
        chooser.setDialogTitle(Strings.S.get("loadJarDialogTitle"));
        chooser.setFileFilter(Loader.JAR_FILTER);
        int check = chooser.showOpenDialog(proj.getFrame());
        if (check == 0) {
            File f = chooser.getSelectedFile();
            String className = null;
            try (JarFile jarFile2 = new JarFile(f);){
                Manifest manifest = jarFile2.getManifest();
                className = manifest.getMainAttributes().getValue("Library-Class");
            }
            catch (IOException jarFile2) {
                // empty catch block
            }
            if (className == null && (className = OptionPane.showInputDialog(proj.getFrame(), Strings.S.get("jarClassNamePrompt"), Strings.S.get("jarClassNameTitle"), 3)) == null) {
                return;
            }
            Library lib = loader.loadJarLibrary(f, className);
            if (lib != null) {
                proj.doAction(LogisimFileActions.loadLibrary(lib, proj.getLogisimFile()));
            }
        }
    }

    public static void doLoadLogisimLibrary(Project proj) {
        File f;
        Library lib;
        Loader loader = proj.getLogisimFile().getLoader();
        JFileChooser chooser = loader.createChooser();
        chooser.setDialogTitle(Strings.S.get("loadLogisimDialogTitle"));
        chooser.setFileFilter(Loader.LOGISIM_FILTER);
        int check = chooser.showOpenDialog(proj.getFrame());
        if (check == 0 && (lib = loader.loadLogisimLibrary(f = chooser.getSelectedFile())) != null) {
            proj.doAction(LogisimFileActions.loadLibrary(lib, proj.getLogisimFile()));
        }
    }

    public static void doUnloadLibraries(Project proj) {
        Library[] libs;
        LogisimFile file = proj.getLogisimFile();
        ArrayList<Library> canUnload = new ArrayList<Library>();
        for (Library lib : file.getLibraries()) {
            String message = file.getUnloadLibraryMessage(lib);
            if (message != null) continue;
            canUnload.add(lib);
        }
        if (canUnload.isEmpty()) {
            OptionPane.showMessageDialog(proj.getFrame(), Strings.S.get("unloadNoneError"), Strings.S.get("unloadErrorTitle"), 1);
            return;
        }
        LibraryJList list = new LibraryJList(canUnload);
        JScrollPane listPane = new JScrollPane(list);
        int action = OptionPane.showConfirmDialog(proj.getFrame(), listPane, Strings.S.get("unloadLibrariesDialogTitle"), 2, 3);
        if (action == 0 && (libs = list.getSelectedLibraries()) != null) {
            proj.doAction(LogisimFileActions.unloadLibraries(libs));
        }
    }

    public static void doUnloadLibrary(Project proj, Library lib) {
        String message = proj.getLogisimFile().getUnloadLibraryMessage(lib);
        if (message != null) {
            OptionPane.showMessageDialog(proj.getFrame(), message, Strings.S.get("unloadErrorTitle"), 0);
        } else {
            proj.doAction(LogisimFileActions.unloadLibrary(lib));
        }
    }

    private static class LibraryJList
    extends JList {
        private static final long serialVersionUID = 1L;

        LibraryJList(List<Library> libraries) {
            ArrayList<BuiltinOption> options = new ArrayList<BuiltinOption>();
            for (Library lib : libraries) {
                options.add(new BuiltinOption(lib));
            }
            this.setListData(options.toArray());
        }

        Library[] getSelectedLibraries() {
            Object[] selected = this.getSelectedValuesList().toArray();
            if (selected != null && selected.length > 0) {
                Library[] libs = new Library[selected.length];
                for (int i = 0; i < selected.length; ++i) {
                    libs[i] = ((BuiltinOption)selected[i]).lib;
                }
                return libs;
            }
            return null;
        }
    }

    private static class BuiltinOption {
        final Library lib;

        BuiltinOption(Library lib) {
            this.lib = lib;
        }

        public String toString() {
            return this.lib.getDisplayName();
        }
    }
}

