/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.opts;

import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.opts.ComboOption;
import com.cburch.logisim.gui.opts.OptionsActions;
import com.cburch.logisim.gui.opts.OptionsFrame;
import com.cburch.logisim.gui.opts.OptionsPanel;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.TableLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SimulateOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private final JLabel simLimitLabel = new JLabel();
    private final JComboBox simLimit = new JComboBox<Integer>(new Integer[]{200, 500, 1000, 2000, 5000, 10000, 20000, 50000});
    private final JCheckBox simRandomness = new JCheckBox();
    private final JCheckBox memUnknown = new JCheckBox();
    private final JLabel gateUndefinedLabel = new JLabel();
    private final JComboBox gateUndefined = new JComboBox<Object>(new Object[]{new ComboOption(Options.GATE_UNDEFINED_IGNORE), new ComboOption(Options.GATE_UNDEFINED_ERROR)});

    public SimulateOptions(OptionsFrame window) {
        super(window);
        JPanel simLimitPanel = new JPanel();
        simLimitPanel.add(this.simLimitLabel);
        simLimitPanel.add(this.simLimit);
        this.simLimit.addActionListener(this.myListener);
        JPanel gateUndefinedPanel = new JPanel();
        gateUndefinedPanel.add(this.gateUndefinedLabel);
        gateUndefinedPanel.add(this.gateUndefined);
        this.gateUndefined.addActionListener(this.myListener);
        this.simRandomness.addActionListener(this.myListener);
        this.memUnknown.addActionListener(this.myListener);
        this.memUnknown.setSelected(AppPreferences.Memory_Startup_Unknown.get());
        this.setLayout(new TableLayout(1));
        this.add(this.memUnknown);
        this.add(simLimitPanel);
        this.add(gateUndefinedPanel);
        this.add(this.simRandomness);
        window.getOptions().getAttributeSet().addAttributeListener(this.myListener);
        AttributeSet attrs = this.getOptions().getAttributeSet();
        this.myListener.loadSimLimit(attrs.getValue(Options.ATTR_SIM_LIMIT));
        this.myListener.loadGateUndefined(attrs.getValue(Options.ATTR_GATE_UNDEFINED));
        this.myListener.loadSimRandomness(attrs.getValue(Options.ATTR_SIM_RAND));
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("simulateHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("simulateTitle");
    }

    @Override
    public void localeChanged() {
        this.simLimitLabel.setText(Strings.S.get("simulateLimit"));
        this.gateUndefinedLabel.setText(Strings.S.get("gateUndefined"));
        this.simRandomness.setText(Strings.S.get("simulateRandomness"));
        this.memUnknown.setText(Strings.S.get("MemoriesStartupUnknown"));
    }

    private class MyListener
    implements ActionListener,
    AttributeListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == SimulateOptions.this.simLimit) {
                Integer opt = (Integer)SimulateOptions.this.simLimit.getSelectedItem();
                if (opt != null) {
                    AttributeSet attrs = SimulateOptions.this.getOptions().getAttributeSet();
                    SimulateOptions.this.getProject().doAction(OptionsActions.setAttribute(attrs, Options.ATTR_SIM_LIMIT, opt));
                }
            } else if (source == SimulateOptions.this.simRandomness) {
                AttributeSet attrs = SimulateOptions.this.getOptions().getAttributeSet();
                Integer val = SimulateOptions.this.simRandomness.isSelected() ? Options.SIM_RAND_DFLT : Integer.valueOf(0);
                SimulateOptions.this.getProject().doAction(OptionsActions.setAttribute(attrs, Options.ATTR_SIM_RAND, val));
            } else if (source == SimulateOptions.this.gateUndefined) {
                ComboOption opt = (ComboOption)SimulateOptions.this.gateUndefined.getSelectedItem();
                if (opt != null) {
                    AttributeSet attrs = SimulateOptions.this.getOptions().getAttributeSet();
                    SimulateOptions.this.getProject().doAction(OptionsActions.setAttribute(attrs, Options.ATTR_GATE_UNDEFINED, opt.getValue()));
                }
            } else if (source == SimulateOptions.this.memUnknown) {
                AppPreferences.Memory_Startup_Unknown.set(SimulateOptions.this.memUnknown.isSelected());
                Simulator sim = SimulateOptions.this.getProject().getSimulator();
                if (sim != null) {
                    sim.reset();
                }
            }
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Attribute<?> attr = e.getAttribute();
            Object val = e.getValue();
            if (attr == Options.ATTR_SIM_LIMIT) {
                this.loadSimLimit((Integer)val);
            } else if (attr == Options.ATTR_SIM_RAND) {
                this.loadSimRandomness((Integer)val);
            } else if (attr == Options.ATTR_GATE_UNDEFINED) {
                this.loadGateUndefined(val);
            }
        }

        private void loadGateUndefined(Object val) {
            ComboOption.setSelected(SimulateOptions.this.gateUndefined, val);
        }

        private void loadSimLimit(Integer val) {
            Integer value = val;
            ComboBoxModel model = SimulateOptions.this.simLimit.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                Integer opt = (Integer)model.getElementAt(i);
                if (opt != value) continue;
                SimulateOptions.this.simLimit.setSelectedItem(opt);
            }
        }

        private void loadSimRandomness(Integer val) {
            SimulateOptions.this.simRandomness.setSelected(val > 0);
        }
    }
}

