/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.bric.colorpicker.ColorPickerDialog;
import com.cburch.logisim.gui.icons.BaseIcon;
import com.cburch.logisim.prefs.PrefMonitor;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;

public class ColorChooserButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private final PrefMonitor<Integer> myMonitor;
    private final Frame frame;

    public ColorChooserButton(Frame frame, PrefMonitor<Integer> pref) {
        this.myMonitor = pref;
        this.frame = frame;
        this.setIcon(new ColorIcon());
        pref.addPropertyChangeListener(this);
        this.addActionListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton but = (JButton)e.getSource();
        Icon icon = but.getIcon();
        if (icon instanceof ColorIcon) {
            ColorIcon i = (ColorIcon)icon;
            i.update(this.frame);
        }
    }

    private class ColorIcon
    extends BaseIcon {
        private ColorIcon() {
        }

        @Override
        protected void paintIcon(Graphics2D g2) {
            g2.setColor(new Color(ColorChooserButton.this.myMonitor.get()));
            g2.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        }

        public void update(Frame frame) {
            Color col = new Color(ColorChooserButton.this.myMonitor.get());
            Color newCol = ColorPickerDialog.showDialog(frame, col, false);
            if (newCol == null) {
                return;
            }
            if (!newCol.equals(col)) {
                col = newCol;
                ColorChooserButton.this.myMonitor.set(col.getRGB());
            }
        }
    }
}

