/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PrefOption;
import com.cburch.logisim.gui.prefs.PrefOptionList;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class IntlOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel localeLabel = new RestrictedLabel();
    private final JComponent locale = Strings.S.createLocaleSelector();
    private final PrefOptionList gateShape = new PrefOptionList(AppPreferences.GATE_SHAPE, Strings.S.getter("intlGateShape"), new PrefOption[]{new PrefOption("shaped", Strings.S.getter("shapeShaped")), new PrefOption("rectangular", Strings.S.getter("shapeRectangular"))});

    public IntlOptions(PreferencesFrame window) {
        super(window);
        Box localePanel = new Box(0);
        localePanel.add(Box.createGlue());
        localePanel.add(this.localeLabel);
        this.localeLabel.setMaximumSize(this.localeLabel.getPreferredSize());
        this.localeLabel.setAlignmentY(0.0f);
        localePanel.add(this.locale);
        this.locale.setAlignmentY(0.0f);
        localePanel.add(Box.createGlue());
        JPanel shapePanel = new JPanel();
        shapePanel.add(this.gateShape.getJLabel());
        shapePanel.add(this.gateShape.getJComboBox());
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createGlue());
        this.add(shapePanel);
        this.add(localePanel);
        this.add(Box.createGlue());
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("intlHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("intlTitle");
    }

    @Override
    public void localeChanged() {
        this.gateShape.localeChanged();
        this.localeLabel.setText(Strings.S.get("intlLocale") + " ");
    }

    private static class RestrictedLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;

        private RestrictedLabel() {
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

