/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.fpga.prefs.FpgaOptions;
import com.cburch.logisim.fpga.prefs.SoftwaresOptions;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.prefs.ExperimentalOptions;
import com.cburch.logisim.gui.prefs.IntlOptions;
import com.cburch.logisim.gui.prefs.LayoutOptions;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.SimOptions;
import com.cburch.logisim.gui.prefs.TemplateOptions;
import com.cburch.logisim.gui.prefs.WindowOptions;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class PreferencesFrame
extends LFrame.Dialog {
    private static final long serialVersionUID = 1L;
    private static WindowMenuManager MENU_MANAGER = null;
    private final MyListener myListener = new MyListener();
    private final OptionsPanel[] panels = new OptionsPanel[]{new TemplateOptions(this), new IntlOptions(this), new WindowOptions(this), new LayoutOptions(this), new SimOptions(this), new ExperimentalOptions(this), new SoftwaresOptions(this), new FpgaOptions(this)};
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private int fpgaTabIdx = -1;

    private PreferencesFrame() {
        super((Project)null);
        int intlIndex = -1;
        for (int index = 0; index < this.panels.length; ++index) {
            OptionsPanel panel = this.panels[index];
            this.tabbedPane.addTab(panel.getTitle(), null, panel, panel.getToolTipText());
            if (panel instanceof IntlOptions) {
                intlIndex = index;
            }
            if (!(panel instanceof FpgaOptions)) continue;
            this.fpgaTabIdx = index;
        }
        Container contents = this.getContentPane();
        contents.add((Component)new JScrollPane(this.tabbedPane), "Center");
        if (intlIndex >= 0) {
            this.tabbedPane.setSelectedIndex(intlIndex);
        }
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
        this.pack();
    }

    public static void initializeManager() {
        MENU_MANAGER = new WindowMenuManager();
    }

    public static void showPreferences() {
        JFrame frame = MENU_MANAGER.getJFrame(true, null);
        frame.setVisible(true);
    }

    public static void showFPGAPreferences() {
        PreferencesFrame frame = (PreferencesFrame)MENU_MANAGER.getJFrame(true, null);
        frame.setFpgaTab();
        frame.setVisible(true);
    }

    public void setFpgaTab() {
        if (this.fpgaTabIdx < 0) {
            return;
        }
        this.tabbedPane.setSelectedIndex(this.fpgaTabIdx);
    }

    private class MyListener
    implements LocaleListener {
        private MyListener() {
        }

        @Override
        public void localeChanged() {
            PreferencesFrame.this.setTitle(Strings.S.get("preferencesFrameTitle"));
            for (int i = 0; i < PreferencesFrame.this.panels.length; ++i) {
                PreferencesFrame.this.tabbedPane.setTitleAt(i, PreferencesFrame.this.panels[i].getTitle());
                PreferencesFrame.this.tabbedPane.setToolTipTextAt(i, PreferencesFrame.this.panels[i].getToolTipText());
                PreferencesFrame.this.panels[i].localeChanged();
            }
        }
    }

    private static class WindowMenuManager
    extends WindowMenuItemManager
    implements LocaleListener {
        private PreferencesFrame window = null;

        WindowMenuManager() {
            super(Strings.S.get("preferencesFrameMenuItem"), true);
            LocaleManager.addLocaleListener(this);
        }

        @Override
        public JFrame getJFrame(boolean create, Component parent) {
            if (create && this.window == null) {
                this.window = new PreferencesFrame();
                this.window.setLocationRelativeTo(parent);
                this.frameOpened(this.window);
            }
            return this.window;
        }

        @Override
        public void localeChanged() {
            this.setText(Strings.S.get("preferencesFrameMenuItem"));
        }
    }
}

