/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.prefs;

import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LoaderException;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.prefs.OptionsPanel;
import com.cburch.logisim.gui.prefs.PreferencesFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorBoolean;
import com.cburch.logisim.prefs.Template;
import com.cburch.logisim.util.JFileChoosers;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class TemplateOptions
extends OptionsPanel {
    private static final long serialVersionUID = 1L;
    private final MyListener myListener = new MyListener();
    private final JRadioButton plain = new JRadioButton();
    private final JRadioButton empty = new JRadioButton();
    private final JRadioButton custom = new JRadioButton();
    private final JTextField templateField = new JTextField(40);
    private final JButton templateButton = new JButton();
    private final JCheckBox removeLibs;

    public TemplateOptions(PreferencesFrame window) {
        super(window);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.plain);
        bgroup.add(this.empty);
        bgroup.add(this.custom);
        this.plain.addActionListener(this.myListener);
        this.empty.addActionListener(this.myListener);
        this.custom.addActionListener(this.myListener);
        this.templateField.setEditable(false);
        this.templateButton.addActionListener(this.myListener);
        this.myListener.computeEnabled();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.removeLibs = ((PrefMonitorBoolean)AppPreferences.REMOVE_UNUSED_LIBRARIES).getCheckBox();
        this.setLayout(gridbag);
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 3;
        gbc.anchor = 21;
        gridbag.setConstraints(this.removeLibs, gbc);
        this.add(this.removeLibs);
        gridbag.setConstraints(this.plain, gbc);
        this.add(this.plain);
        gridbag.setConstraints(this.empty, gbc);
        this.add(this.empty);
        gridbag.setConstraints(this.custom, gbc);
        this.add(this.custom);
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 3;
        gbc.gridx = -1;
        JPanel strut = new JPanel();
        strut.setMinimumSize(new Dimension(50, 1));
        strut.setPreferredSize(new Dimension(50, 1));
        gbc.weightx = 0.0;
        gridbag.setConstraints(strut, gbc);
        this.add(strut);
        gbc.weightx = 1.0;
        gridbag.setConstraints(this.templateField, gbc);
        this.add(this.templateField);
        gbc.weightx = 0.0;
        gridbag.setConstraints(this.templateButton, gbc);
        this.add(this.templateButton);
        AppPreferences.addPropertyChangeListener("templateType", this.myListener);
        AppPreferences.addPropertyChangeListener("templateFile", this.myListener);
        switch (AppPreferences.getTemplateType()) {
            case 1: {
                this.plain.setSelected(true);
                break;
            }
            case 0: {
                this.empty.setSelected(true);
                break;
            }
            case 2: {
                this.custom.setSelected(true);
            }
        }
        this.myListener.setTemplateField(AppPreferences.getTemplateFile());
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("templateHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("templateTitle");
    }

    @Override
    public void localeChanged() {
        this.plain.setText(Strings.S.get("templatePlainOption"));
        this.empty.setText(Strings.S.get("templateEmptyOption"));
        this.custom.setText(Strings.S.get("templateCustomOption"));
        this.templateButton.setText(Strings.S.get("templateSelectButton"));
        this.removeLibs.setText(Strings.S.get("templateRemoveLibsOnSave"));
    }

    private class MyListener
    implements ActionListener,
    PropertyChangeListener {
        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == TemplateOptions.this.templateButton) {
                JFileChooser chooser = JFileChoosers.create();
                chooser.setDialogTitle(Strings.S.get("selectDialogTitle"));
                chooser.setApproveButtonText(Strings.S.get("selectDialogButton"));
                int action = chooser.showOpenDialog(TemplateOptions.this.getPreferencesFrame());
                if (action == 0) {
                    File file = chooser.getSelectedFile();
                    FileInputStream reader = null;
                    InputStream reader2 = null;
                    try {
                        Loader loader = new Loader(TemplateOptions.this.getPreferencesFrame());
                        reader = new FileInputStream(file);
                        Template template = Template.create(reader);
                        reader2 = template.createStream();
                        LogisimFile.load(reader2, loader);
                        AppPreferences.setTemplateFile(file, template);
                        AppPreferences.setTemplateType(2);
                    }
                    catch (LoaderException loader) {
                    }
                    catch (IOException ex) {
                        OptionPane.showMessageDialog(TemplateOptions.this.getPreferencesFrame(), Strings.S.get("templateErrorMessage", ex.toString()), Strings.S.get("templateErrorTitle"), 0);
                    }
                    finally {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (reader != null) {
                                reader2.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                int value = -1;
                if (TemplateOptions.this.plain.isSelected()) {
                    value = 1;
                } else if (TemplateOptions.this.empty.isSelected()) {
                    value = 0;
                } else if (TemplateOptions.this.custom.isSelected()) {
                    value = 2;
                }
                AppPreferences.setTemplateType(value);
            }
            this.computeEnabled();
        }

        private void computeEnabled() {
            TemplateOptions.this.custom.setEnabled(!TemplateOptions.this.templateField.getText().equals(""));
            TemplateOptions.this.templateField.setEnabled(TemplateOptions.this.custom.isSelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getPropertyName();
            if (prop.equals("templateType")) {
                int value = AppPreferences.getTemplateType();
                TemplateOptions.this.plain.setSelected(value == 1);
                TemplateOptions.this.empty.setSelected(value == 0);
                TemplateOptions.this.custom.setSelected(value == 2);
            } else if (prop.equals("templateFile")) {
                this.setTemplateField((File)event.getNewValue());
            }
        }

        private void setTemplateField(File f) {
            try {
                TemplateOptions.this.templateField.setText(f == null ? "" : f.getCanonicalPath());
            }
            catch (IOException e) {
                TemplateOptions.this.templateField.setText(f.getName());
            }
            this.computeEnabled();
        }
    }
}

