/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.start.AboutCredits;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class About {
    static final int PADDING = 20;
    static final int PANEL_WIDTH = 600;
    static final int LOGO_HEIGHT = 200;
    static final int SCROLLER_HEIGHT = 200;
    private static final String LOGO_IMG = "resources/logisim/img/logisim-evolution-logo.png";

    private About() {
    }

    public static AboutPanel getImagePanel() {
        return new AboutPanel();
    }

    public static void showAboutDialog(JFrame owner) {
        AboutPanel imgPanel = new AboutPanel(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(imgPanel);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        OptionPane.showMessageDialog(owner, panel, "Logisim-evolution v3.8.0", -1);
    }

    private static class AboutPanel
    extends JPanel
    implements AncestorListener {
        private static final long serialVersionUID = 1L;
        private AboutCredits credits = null;
        private PanelThread thread = null;

        public AboutPanel() {
            this(false);
        }

        public AboutPanel(boolean includeCredits) {
            this.setLayout(null);
            int prefWidth = 640;
            int prefHeight = 240;
            if (includeCredits) {
                prefHeight += 200;
            }
            this.setPreferredSize(new Dimension(640, prefHeight));
            this.setBackground(Color.WHITE);
            this.addAncestorListener(this);
            JLabel logo = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource(About.LOGO_IMG)));
            logo.setBounds(0, 20, 640, 200);
            this.add(logo);
            if (includeCredits) {
                this.credits = new AboutCredits(600, 200);
                this.credits.setBounds(0, prefHeight / 2, 640, 200);
                this.add(this.credits);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent arg0) {
            if (this.credits != null) {
                if (this.thread == null) {
                    this.thread = new PanelThread(this);
                }
                this.thread.start();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent arg0) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent arg0) {
            if (this.thread != null) {
                this.thread.running = false;
            }
        }
    }

    private static class PanelThread
    extends UniquelyNamedThread {
        private final AboutPanel panel;
        private boolean running = true;

        PanelThread(AboutPanel panel) {
            super("About-PanelThread");
            this.panel = panel;
        }

        @Override
        public void run() {
            while (this.running) {
                this.panel.repaint();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

