/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.test;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.gui.start.SplashScreen;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.io.File;
import java.util.Map;

public class TestBench {
    private final String[] outputSignals = new String[]{"test_bench_done_o", "test_bench_ok_o"};
    private final Instance[] pinsOutput = new Instance[this.outputSignals.length];
    private Project proj;

    public TestBench(String path, SplashScreen mon, Map<File, File> subs) {
        File fileToOpen = new File(path);
        try {
            this.proj = ProjectActions.doOpenNoWindow(mon, fileToOpen);
        }
        catch (LoadFailedException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private boolean checkMatchPinName(String label) {
        for (String outName : this.outputSignals) {
            if (!label.equals(outName)) continue;
            return true;
        }
        return false;
    }

    private boolean searchMatchingPins(Circuit circuit) {
        CircuitState state = new CircuitState(this.proj, this.proj.getCurrentCircuit());
        int j = 0;
        int pinMatched = 0;
        for (String output : this.outputSignals) {
            for (Component comp : circuit.getNonWires()) {
                if (!(comp.getFactory() instanceof Pin)) continue;
                Instance inst = Instance.getInstanceFor(comp);
                InstanceState pinState = state.getInstanceState(comp);
                String label = pinState.getAttributeValue(StdAttr.LABEL);
                if (label == null && this.checkMatchPinName(label)) continue;
                if (inst == null) {
                    return false;
                }
                if (!output.equals(label)) continue;
                this.pinsOutput[j] = inst;
                ++pinMatched;
                break;
            }
            ++j;
        }
        return pinMatched == this.outputSignals.length;
    }

    private boolean startSimulator() {
        Simulator sim;
        Simulator simulator = sim = this.proj == null ? null : this.proj.getSimulator();
        if (sim == null) {
            return false;
        }
        VhdlSimulatorTop vhdlSim = sim.getCircuitState().getProject().getVhdlSimulator();
        vhdlSim.enable();
        sim.setAutoPropagation(true);
        while (vhdlSim.isEnabled()) {
            Thread.yield();
        }
        return true;
    }

    public boolean startTestBench() {
        Circuit circuit = this.proj.getLogisimFile().getCircuit("logisim_test_verif");
        this.proj.setCurrentCircuit(circuit);
        Value[] val = new Value[this.outputSignals.length];
        if (circuit == null) {
            System.out.println("Circuit is null");
            return false;
        }
        for (int i = 0; i < val.length; ++i) {
            val[i] = Value.createKnown(1, 1L);
        }
        if (!this.startSimulator()) {
            System.out.println("Error starting the simulator");
            return false;
        }
        if (!this.searchMatchingPins(circuit)) {
            System.out.println("Error finding the pins");
            return false;
        }
        return circuit.doTestBench(this.proj, this.pinsOutput, val);
    }
}

