/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.test;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.FailException;
import com.cburch.logisim.data.TestException;
import com.cburch.logisim.data.TestVector;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.test.Model;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.UniquelyNamedThread;

public class TestThread
extends UniquelyNamedThread
implements CircuitListener {
    private final Project project;
    private final Circuit circuit;
    private final TestVector vector;
    private Instance[] pin;
    private Model model;
    private boolean canceled = false;
    private boolean paused = false;

    public TestThread(Model model) throws TestException {
        super("TestThread-Model");
        this.model = model;
        this.project = model.getProject();
        this.circuit = model.getCircuit();
        this.vector = model.getVector();
        this.matchPins();
        model.getCircuit().addCircuitListener(this);
    }

    private TestThread(Project proj, Circuit circuit, TestVector vec) throws TestException {
        super("TestThread-Project");
        this.project = proj;
        this.circuit = circuit;
        this.vector = vec;
        this.matchPins();
    }

    public static int doTestVector(Project proj, Circuit circuit, String vectorname) {
        TestThread tester;
        TestVector vec;
        System.out.println(Strings.S.get("testLoadingVector", vectorname));
        try {
            vec = new TestVector(vectorname);
        }
        catch (Exception e) {
            System.err.println(Strings.S.get("testLoadingFailed", e.getMessage()));
            return -1;
        }
        try {
            tester = new TestThread(proj, circuit, vec);
        }
        catch (TestException e) {
            System.err.println(Strings.S.get("testSetupFailed", e.getMessage()));
            return -1;
        }
        System.out.println(Strings.S.get("testRunning", Integer.toString(vec.data.size())));
        int numPass = 0;
        int numFail = 0;
        for (int i = 0; i < vec.data.size(); ++i) {
            try {
                System.out.print(i + 1 + " \r");
                tester.test(i);
                ++numPass;
                continue;
            }
            catch (FailException e) {
                System.out.println();
                System.err.println(Strings.S.get("testFailed", Integer.toString(i + 1)));
                for (FailException e1 : e.getAll()) {
                    System.out.println("  " + e1.getMessage());
                }
                ++numFail;
                continue;
            }
            catch (TestException e) {
                System.out.println();
                System.err.println(Strings.S.get("testFailed", i + 1 + " " + e.getMessage()));
                ++numFail;
            }
        }
        System.out.println();
        System.out.println(Strings.S.get("testResults", Integer.toString(numPass), Integer.toString(numFail)));
        return 0;
    }

    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        int action = event.getAction();
        if (action == 0) {
            return;
        }
        this.model.clearResults();
    }

    void matchPins() throws TestException {
        int n = this.vector.columnName.length;
        this.pin = new Instance[n];
        CircuitState state = new CircuitState(this.project, this.circuit);
        for (int i = 0; i < n; ++i) {
            String columnName = this.vector.columnName[i];
            for (Component comp : this.circuit.getNonWires()) {
                if (!(comp.getFactory() instanceof Pin)) continue;
                Instance inst = Instance.getInstanceFor(comp);
                InstanceState pinState = state.getInstanceState(comp);
                String label = pinState.getAttributeValue(StdAttr.LABEL);
                if (label == null || !label.equals(columnName)) continue;
                if (Pin.FACTORY.getWidth(inst).getWidth() != this.vector.columnWidth[i].getWidth()) {
                    throw new TestException("test vector column '" + columnName + "' has width " + this.vector.columnWidth[i] + ", but pin has width " + Pin.FACTORY.getWidth(inst));
                }
                this.pin[i] = inst;
                break;
            }
            if (this.pin[i] != null) continue;
            throw new TestException("test vector column '" + columnName + "' has no matching pin");
        }
    }

    @Override
    public void run() {
        try {
            for (int i = 0; i < this.vector.data.size() && !this.canceled; ++i) {
                while (this.paused) {
                    if (this.canceled) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    this.test(i);
                    this.canceled = this.canceled || !this.model.setResult(this.vector, i, null);
                }
                catch (TestException e) {
                    this.canceled = this.canceled || !this.model.setResult(this.vector, i, e);
                }
                Thread.yield();
            }
        }
        finally {
            this.model.stop();
        }
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private void test(int idx) throws TestException {
        this.circuit.doTestVector(this.project, this.pin, this.vector.data.get(idx));
    }
}

