/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.instance.InstanceTextField;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.TextEditable;
import com.cburch.logisim.tools.ToolTipMaker;
import com.cburch.logisim.util.EventSourceWeakSupport;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.SyntaxChecker;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class InstanceComponent
implements Component,
AttributeListener,
ToolTipMaker {
    private EventSourceWeakSupport<ComponentListener> listeners = null;
    private InstanceFactory factory;
    private final Instance instance;
    private final Location loc;
    private Bounds bounds;
    private List<Port> portList;
    private EndData[] endArray;
    private List<EndData> endList;
    private boolean hasToolTips;
    private HashSet<Attribute<BitWidth>> widthAttrs;
    private final AttributeSet attrs;
    private boolean attrListenRequested;
    private InstanceTextField textField;
    private InstanceStateImpl instanceState;
    private boolean doMarkInstance;
    private boolean doMarkLabel;

    public InstanceComponent(InstanceFactory factory, Location loc, AttributeSet attrs) {
        this.factory = factory;
        this.instance = Instance.makeFor(this);
        this.loc = loc;
        this.bounds = factory.getOffsetBounds(attrs).translate(loc.getX(), loc.getY());
        this.portList = factory.getPorts();
        this.endArray = null;
        this.hasToolTips = false;
        this.attrs = attrs;
        this.attrListenRequested = false;
        this.textField = null;
        this.doMarkInstance = false;
        this.doMarkLabel = false;
        this.computeEnds();
    }

    void addAttributeListener(Instance instance) {
        if (!this.attrListenRequested) {
            this.attrListenRequested = true;
            if (this.widthAttrs == null) {
                this.getAttributeSet().addAttributeListener(this);
            }
        }
    }

    public boolean isMarked() {
        return this.doMarkInstance || this.doMarkLabel;
    }

    public void clearMarks() {
        this.doMarkInstance = false;
        this.doMarkLabel = false;
    }

    public void markInstance() {
        this.doMarkInstance = true;
    }

    public void markLabel() {
        this.doMarkLabel = true;
    }

    @Override
    public void addComponentListener(ComponentListener l) {
        EventSourceWeakSupport<ComponentListener> ls = this.listeners;
        if (ls == null) {
            ls = new EventSourceWeakSupport();
            ls.add(l);
            this.listeners = ls;
        } else {
            ls.add(l);
        }
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        Attribute<?> attr = e.getAttribute();
        if (e.getAttribute().equals(StdAttr.LABEL)) {
            String oldValue;
            Attribute<?> lAttr = e.getAttribute();
            String value = (String)e.getSource().getValue(e.getAttribute());
            String string = oldValue = e.getOldValue() != null ? (String)e.getOldValue() : "";
            if (!oldValue.equals(value)) {
                if (!SyntaxChecker.isVariableNameAcceptable(value, true)) {
                    e.getSource().setValue(lAttr, oldValue);
                } else if (this.getFactory().getName().equalsIgnoreCase(value)) {
                    OptionPane.showMessageDialog(null, Strings.S.get("MatchedLabelNameError"));
                    e.getSource().setValue(lAttr, oldValue);
                } else if (CorrectLabel.isKeyword(value, false)) {
                    OptionPane.showMessageDialog(null, "\"" + value + "\": " + Strings.S.get("KeywordNameError"));
                    e.getSource().setValue(lAttr, oldValue);
                } else {
                    this.fireLabelChanged(e);
                }
            }
        }
        if (this.widthAttrs != null && this.widthAttrs.contains(attr)) {
            this.computeEnds();
        }
        if (this.attrListenRequested) {
            this.factory.instanceAttributeChanged(this.instance, e.getAttribute());
        }
    }

    private void computeEnds() {
        List<Port> ports = this.portList;
        EndData[] esOld = this.endArray;
        int esOldLength = esOld == null ? 0 : esOld.length;
        EndData[] es = esOld;
        if (es == null || es.length != ports.size()) {
            es = new EndData[ports.size()];
            if (esOldLength > 0) {
                int toCopy = Math.min(esOldLength, es.length);
                System.arraycopy(esOld, 0, es, 0, toCopy);
            }
        }
        HashSet<Attribute<BitWidth>> wAttrs = null;
        boolean toolTipFound = false;
        ArrayList<EndData> endsChangedOld = null;
        ArrayList<EndData> endsChangedNew = null;
        Iterator<Port> portIt = ports.iterator();
        for (int i = 0; portIt.hasNext() || i < esOldLength; ++i) {
            EndData newEnd;
            Port p = portIt.hasNext() ? portIt.next() : null;
            EndData oldEnd = i < esOldLength ? esOld[i] : null;
            EndData endData = newEnd = p == null ? null : p.toEnd(this.loc, this.attrs);
            if (oldEnd == null || !oldEnd.equals(newEnd)) {
                if (newEnd != null) {
                    es[i] = newEnd;
                }
                if (endsChangedOld == null) {
                    endsChangedOld = new ArrayList<EndData>();
                    endsChangedNew = new ArrayList<EndData>();
                }
                endsChangedOld.add(oldEnd);
                endsChangedNew.add(newEnd);
            }
            if (p == null) continue;
            Attribute<BitWidth> attr = p.getWidthAttribute();
            if (attr != null) {
                if (wAttrs == null) {
                    wAttrs = new HashSet<Attribute<BitWidth>>();
                }
                wAttrs.add(attr);
            }
            if (p.getToolTip() == null) continue;
            toolTipFound = true;
        }
        if (!this.attrListenRequested) {
            HashSet<Attribute<BitWidth>> oldWidthAttrs = this.widthAttrs;
            if (wAttrs == null && oldWidthAttrs != null) {
                this.getAttributeSet().removeAttributeListener(this);
            } else if (wAttrs != null && oldWidthAttrs == null) {
                this.getAttributeSet().addAttributeListener(this);
            }
        }
        if (es != esOld) {
            this.endArray = es;
            this.endList = new UnmodifiableList<EndData>(es);
        }
        this.widthAttrs = wAttrs;
        this.hasToolTips = toolTipFound;
        if (endsChangedOld != null) {
            this.fireEndsChanged(endsChangedOld, endsChangedNew);
        }
    }

    @Override
    public boolean contains(Location pt) {
        Location translated = pt.translate(-this.loc.getX(), -this.loc.getY());
        InstanceFactory factory = this.instance.getFactory();
        return factory.contains(translated, this.instance.getAttributeSet());
    }

    @Override
    public boolean contains(Location pt, Graphics g) {
        InstanceTextField field = this.textField;
        return field != null && field.getBounds(g).contains(pt) ? true : this.contains(pt);
    }

    @Override
    public void draw(ComponentDrawContext context) {
        InstancePainter painter = context.getInstancePainter();
        painter.setInstance(this);
        this.factory.paintInstance(painter);
        if (this.doMarkInstance) {
            Graphics g = painter.getGraphics();
            Bounds bds = painter.getBounds();
            Color current = g.getColor();
            g.setColor(Netlist.DRC_INSTANCE_MARK_COLOR);
            GraphicsUtil.switchToWidth(g, 2);
            g.drawRoundRect(bds.getX() - 10, bds.getY() - 10, bds.getWidth() + 20, bds.getHeight() + 20, 40, 40);
            GraphicsUtil.switchToWidth(g, 1);
            g.setColor(current);
        }
    }

    void drawLabel(ComponentDrawContext context) {
        InstanceTextField field = this.textField;
        if (field != null) {
            field.draw(this, context);
            if (this.doMarkLabel) {
                Graphics g = context.getGraphics();
                Bounds bds = field.getBounds(g);
                Color current = g.getColor();
                g.setColor(Netlist.DRC_LABEL_MARK_COLOR);
                GraphicsUtil.switchToWidth(g, 2);
                g.drawRoundRect(bds.getX() - 10, bds.getY() - 10, bds.getWidth() + 20, bds.getHeight() + 20, 40, 40);
                GraphicsUtil.switchToWidth(g, 1);
                g.setColor(current);
            }
        }
    }

    @Override
    public boolean endsAt(Location pt) {
        EndData[] ends;
        for (EndData end : ends = this.endArray) {
            if (!end.getLocation().equals(pt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void expose(ComponentDrawContext context) {
        context.getDestination().repaint(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    private void fireLabelChanged(AttributeEvent attre) {
        EventSourceWeakSupport<ComponentListener> listeners = this.listeners;
        if (listeners != null) {
            ComponentEvent e = null;
            for (ComponentListener listener : listeners) {
                if (e == null) {
                    e = new ComponentEvent(this, null, attre);
                }
                listener.labelChanged(e);
            }
        }
    }

    private void fireEndsChanged(ArrayList<EndData> oldEnds, ArrayList<EndData> newEnds) {
        EventSourceWeakSupport<ComponentListener> listeners = this.listeners;
        if (listeners != null) {
            ComponentEvent e = null;
            for (ComponentListener listener : listeners) {
                if (e == null) {
                    e = new ComponentEvent(this, oldEnds, newEnds);
                }
                listener.endChanged(e);
            }
        }
    }

    void fireInvalidated() {
        EventSourceWeakSupport<ComponentListener> listeners = this.listeners;
        if (listeners != null) {
            ComponentEvent e = null;
            for (ComponentListener listener : listeners) {
                if (e == null) {
                    e = new ComponentEvent(this);
                }
                listener.componentInvalidated(e);
            }
        }
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.attrs;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public Bounds getBounds(Graphics g) {
        Bounds ret = this.bounds;
        if (this.textField != null) {
            ret = ret.add(this.textField.getBounds(g));
        }
        return ret;
    }

    @Override
    public EndData getEnd(int index) {
        return this.endArray[index];
    }

    @Override
    public List<EndData> getEnds() {
        return this.endList;
    }

    @Override
    public ComponentFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(ComponentFactory fact) {
        this.factory = (InstanceFactory)fact;
    }

    @Override
    public Object getFeature(Object key) {
        Object ret = this.factory.getInstanceFeature(this.instance, key);
        if (ret != null) {
            return ret;
        }
        if (key == ToolTipMaker.class) {
            StringGetter defaultTip = this.factory.getDefaultToolTip();
            if (this.hasToolTips || defaultTip != null) {
                return this;
            }
        } else if (key == TextEditable.class) {
            return this.textField;
        }
        return null;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public InstanceStateImpl getInstanceStateImpl() {
        return this.instanceState;
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    List<Port> getPorts() {
        return this.portList;
    }

    @Override
    public String getToolTip(ComponentUserEvent e) {
        int i = 0;
        for (EndData end : this.endArray) {
            if (end.getLocation().manhattanDistanceTo(e.getX(), e.getY()) < 10) {
                return this.portList.get(i).getToolTip();
            }
            ++i;
        }
        StringGetter defaultTip = this.factory.getDefaultToolTip();
        return defaultTip == null ? null : defaultTip.toString();
    }

    @Override
    public void propagate(CircuitState state) {
        this.factory.propagate(state.getInstanceState(this));
    }

    void recomputeBounds() {
        Location p = this.loc;
        this.bounds = this.factory.getOffsetBounds(this.attrs).translate(p.getX(), p.getY());
    }

    @Override
    public void removeComponentListener(ComponentListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void setInstanceStateImpl(InstanceStateImpl instanceState) {
        this.instanceState = instanceState;
    }

    void setPorts(Port[] ports) {
        Port[] portsCopy = (Port[])ports.clone();
        this.portList = new UnmodifiableList<Port>(portsCopy);
        this.computeEnds();
    }

    void setTextField(Attribute<String> labelAttr, Attribute<Font> fontAttr, int x, int y, int halign, int valign) {
        InstanceTextField field = this.textField;
        if (field == null) {
            field = new InstanceTextField(this);
            field.update(labelAttr, fontAttr, x, y, halign, valign);
            this.textField = field;
        } else {
            field.update(labelAttr, fontAttr, x, y, halign, valign);
        }
    }

    public String toString() {
        String label = this.attrs.getValue(StdAttr.LABEL);
        return "InstanceComponent{factory=" + this.factory.getName() + ",loc=(" + this.loc + "),label=" + label + "}@" + super.toString();
    }
}

