/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.proj.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class InstancePainter
implements InstanceState {
    private final ComponentDrawContext context;
    private InstanceComponent comp;
    private InstanceFactory factory;
    private AttributeSet attrs;

    public InstancePainter(ComponentDrawContext context, InstanceComponent instance) {
        this.context = context;
        this.comp = instance;
    }

    public void drawBounds() {
        this.context.drawBounds(this.comp);
    }

    public void drawClock(int i, Direction dir) {
        this.context.drawClock(this.comp, i, dir);
    }

    public void drawClockSymbol(int xpos, int ypos) {
        this.context.drawClockSymbol(this.comp, xpos, ypos);
    }

    public void drawDongle(int x, int y) {
        this.context.drawDongle(x, y);
    }

    public void drawHandle(int x, int y) {
        this.context.drawHandle(x, y);
    }

    public void drawHandle(Location loc) {
        this.context.drawHandle(loc);
    }

    public void drawHandles() {
        this.context.drawHandles(this.comp);
    }

    public void drawLabel() {
        if (this.comp != null) {
            this.comp.drawLabel(this.context);
        }
    }

    public void drawPort(int i) {
        this.context.drawPin(this.comp, i);
    }

    public void drawPort(int i, String label, Direction dir) {
        this.context.drawPin(this.comp, i, label, dir);
    }

    public void drawPorts() {
        this.context.drawPins(this.comp);
    }

    public void drawRectangle(Bounds bds, String label) {
        this.context.drawRectangle(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight(), label);
    }

    public void drawRectangle(int x, int y, int width, int height, String label) {
        this.context.drawRectangle(x, y, width, height, label);
    }

    @Override
    public void fireInvalidated() {
        this.comp.fireInvalidated();
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.comp == null ? this.attrs : this.comp.getAttributeSet();
    }

    @Override
    public <E> E getAttributeValue(Attribute<E> attr) {
        AttributeSet as = this.comp == null ? this.attrs : this.comp.getAttributeSet();
        return as.getValue(attr);
    }

    public Bounds getBounds() {
        return this.comp == null ? this.factory.getOffsetBounds(this.attrs) : this.comp.getBounds();
    }

    public Circuit getCircuit() {
        return this.context.getCircuit();
    }

    @Override
    public InstanceData getData() {
        CircuitState circState = this.context.getCircuitState();
        if (circState == null || this.comp == null) {
            throw new UnsupportedOperationException("setData on InstancePainter");
        }
        return (InstanceData)circState.getData(this.comp);
    }

    public CircuitState getCircuitState() {
        return this.context.getCircuitState();
    }

    public Component getDestination() {
        return this.context.getDestination();
    }

    @Override
    public InstanceFactory getFactory() {
        return this.comp == null ? this.factory : (InstanceFactory)this.comp.getFactory();
    }

    public Object getGateShape() {
        return this.context.getGateShape();
    }

    public Graphics getGraphics() {
        return this.context.getGraphics();
    }

    public WireSet getHighlightedWires() {
        return this.context.getHighlightedWires();
    }

    @Override
    public Instance getInstance() {
        return this.comp == null ? null : this.comp.getInstance();
    }

    public Location getLocation() {
        return this.comp == null ? Location.create(0, 0, false) : this.comp.getLocation();
    }

    public Bounds getOffsetBounds() {
        if (this.comp == null) {
            return this.factory.getOffsetBounds(this.attrs);
        }
        Location loc = this.comp.getLocation();
        return this.comp.getBounds().translate(-loc.getX(), -loc.getY());
    }

    @Override
    public int getPortIndex(Port port) {
        return this.getInstance().getPorts().indexOf(port);
    }

    @Override
    public Value getPortValue(int portIndex) {
        CircuitState s = this.context.getCircuitState();
        return this.comp != null && s != null ? s.getValue(this.comp.getEnd(portIndex).getLocation()) : Value.UNKNOWN;
    }

    @Override
    public Project getProject() {
        return this.context.getCircuitState().getProject();
    }

    public boolean getShowState() {
        return this.context.getShowState();
    }

    @Override
    public int getTickCount() {
        return this.context.getCircuitState().getPropagator().getTickCount();
    }

    @Override
    public boolean isCircuitRoot() {
        return !this.context.getCircuitState().isSubstate();
    }

    @Override
    public boolean isPortConnected(int index) {
        Location loc = this.comp.getEnd(index).getLocation();
        return this.context.getCircuit().isConnected(loc, this.comp);
    }

    public boolean isPrintView() {
        return this.context.isPrintView();
    }

    @Override
    public void setData(InstanceData value) {
        CircuitState circState = this.context.getCircuitState();
        if (circState == null || this.comp == null) {
            throw new UnsupportedOperationException("setData on InstancePainter");
        }
        circState.setData(this.comp, value);
    }

    void setFactory(InstanceFactory factory, AttributeSet attrs) {
        this.comp = null;
        this.factory = factory;
        this.attrs = attrs;
    }

    void setInstance(InstanceComponent value) {
        this.comp = value;
    }

    @Override
    public void setPort(int portIndex, Value value, int delay) {
        throw new UnsupportedOperationException("setValue on InstancePainter");
    }

    public boolean shouldDrawColor() {
        return this.context.shouldDrawColor();
    }

    public void drawRoundBounds(Bounds bds, Color color) {
        this.context.drawRoundBounds(this.comp, bds, color);
    }

    public void drawRoundBounds(Color color) {
        this.context.drawRoundBounds(this.comp, color);
    }
}

