/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.proj.Project;

public class InstanceStateImpl
implements InstanceState {
    private CircuitState circuitState;
    private Component component;

    public InstanceStateImpl(CircuitState circuitState, Component component) {
        this.circuitState = circuitState;
        this.component = component;
        if (component instanceof InstanceComponent) {
            InstanceComponent instComp = (InstanceComponent)component;
            instComp.setInstanceStateImpl(this);
        }
    }

    @Override
    public void fireInvalidated() {
        Component component = this.component;
        if (component instanceof InstanceComponent) {
            InstanceComponent instComp = (InstanceComponent)component;
            instComp.fireInvalidated();
        }
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this.component.getAttributeSet();
    }

    @Override
    public <E> E getAttributeValue(Attribute<E> attr) {
        return this.component.getAttributeSet().getValue(attr);
    }

    public CircuitState getCircuitState() {
        return this.circuitState;
    }

    @Override
    public InstanceData getData() {
        return (InstanceData)this.circuitState.getData(this.component);
    }

    @Override
    public InstanceFactory getFactory() {
        Component component = this.component;
        if (component instanceof InstanceComponent) {
            InstanceComponent instComp = (InstanceComponent)component;
            return (InstanceFactory)instComp.getFactory();
        }
        return null;
    }

    @Override
    public Instance getInstance() {
        Instance instance;
        Component component = this.component;
        if (component instanceof InstanceComponent) {
            InstanceComponent instComp = (InstanceComponent)component;
            instance = instComp.getInstance();
        } else {
            instance = null;
        }
        return instance;
    }

    @Override
    public int getPortIndex(Port port) {
        return this.getInstance().getPorts().indexOf(port);
    }

    @Override
    public Value getPortValue(int portIndex) {
        EndData data = this.component.getEnd(portIndex);
        return this.circuitState.getValue(data.getLocation());
    }

    @Override
    public Project getProject() {
        return this.circuitState.getProject();
    }

    @Override
    public int getTickCount() {
        return this.circuitState.getPropagator().getTickCount();
    }

    @Override
    public boolean isCircuitRoot() {
        return !this.circuitState.isSubstate();
    }

    @Override
    public boolean isPortConnected(int index) {
        Circuit circ = this.circuitState.getCircuit();
        Location loc = this.component.getEnd(index).getLocation();
        return circ.isConnected(loc, this.component);
    }

    public void repurpose(CircuitState circuitState, Component component) {
        this.circuitState = circuitState;
        this.component = component;
    }

    @Override
    public void setData(InstanceData value) {
        this.circuitState.setData(this.component, value);
    }

    @Override
    public void setPort(int portIndex, Value value, int delay) {
        EndData end = this.component.getEnd(portIndex);
        this.circuitState.setValue(end.getLocation(), value, this.component, delay);
    }
}

