/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.Main;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.start.Startup;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.FpgaBoards;
import com.cburch.logisim.prefs.PrefMonitor;
import com.cburch.logisim.prefs.PrefMonitorBoolean;
import com.cburch.logisim.prefs.PrefMonitorBooleanConvert;
import com.cburch.logisim.prefs.PrefMonitorDouble;
import com.cburch.logisim.prefs.PrefMonitorInt;
import com.cburch.logisim.prefs.PrefMonitorString;
import com.cburch.logisim.prefs.PrefMonitorStringOpts;
import com.cburch.logisim.prefs.RecentProjects;
import com.cburch.logisim.prefs.Template;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.PropertyChangeWeakSupport;
import com.formdev.flatlaf.FlatIntelliJLaf;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;

public class AppPreferences {
    private static Preferences prefs = null;
    private static MyListener myListener = null;
    private static final PropertyChangeWeakSupport propertySupport = new PropertyChangeWeakSupport(AppPreferences.class);
    public static final int IconSize = 16;
    public static final int FONT_SIZE = 14;
    public static final int ICON_BORDER = 2;
    public static final int BOX_SIZE = 20;
    public static final int TEMPLATE_UNKNOWN = -1;
    public static final int TEMPLATE_EMPTY = 0;
    public static final int TEMPLATE_PLAIN = 1;
    public static final int TEMPLATE_CUSTOM = 2;
    public static final String TEMPLATE = "template";
    public static final String TEMPLATE_TYPE = "templateType";
    public static final String TEMPLATE_FILE = "templateFile";
    private static int templateType = 1;
    private static File templateFile = null;
    private static Template plainTemplate = null;
    private static Template emptyTemplate = null;
    private static Template customTemplate = null;
    private static File customTemplateFile = null;
    public static final String SHAPE_SHAPED = "shaped";
    public static final String SHAPE_RECTANGULAR = "rectangular";
    public static final PrefMonitor<String> GATE_SHAPE = AppPreferences.create(new PrefMonitorStringOpts("gateShape", new String[]{"shaped", "rectangular"}, "shaped"));
    public static final PrefMonitor<String> LOCALE = AppPreferences.create(new LocalePreference());
    public static final PrefMonitor<String> FPGA_Workspace = AppPreferences.create(new PrefMonitorString("FPGAWorkspace", System.getProperty("user.home") + "/logisim_evolution_workspace"));
    public static final PrefMonitor<String> HdlType = AppPreferences.create(new PrefMonitorStringOpts("afterAdd", new String[]{"VHDL", "Verilog"}, "VHDL"));
    public static final PrefMonitor<String> SelectedBoard = AppPreferences.create(new PrefMonitorString("SelectedBoard", null));
    public static final String EXTERNAL_BOARDS = "ExternalBoards";
    public static final FpgaBoards Boards = new FpgaBoards();
    public static final PrefMonitor<Boolean> SupressGatedClockWarnings = AppPreferences.create(new PrefMonitorBoolean("NoGatedClockWarnings", false));
    public static final PrefMonitor<Boolean> SupressOpenPinWarnings = AppPreferences.create(new PrefMonitorBoolean("NoOpenPinWarnings", false));
    public static final PrefMonitor<Boolean> VhdlKeywordsUpperCase = AppPreferences.create(new PrefMonitorBoolean("VhdlKeywordsUpperCase", true));
    public static final PrefMonitor<Boolean> REMOVE_UNUSED_LIBRARIES = AppPreferences.create(new PrefMonitorBoolean("removeUnusedLibs", false));
    public static final String TOOLBAR_HIDDEN = "hidden";
    public static final PrefMonitor<Boolean> SHOW_TICK_RATE = AppPreferences.create(new PrefMonitorBoolean("showTickRate", false));
    public static final PrefMonitor<String> TOOLBAR_PLACEMENT = AppPreferences.create(new PrefMonitorStringOpts("toolbarPlacement", new String[]{Direction.NORTH.toString(), Direction.SOUTH.toString(), Direction.EAST.toString(), Direction.WEST.toString(), "hidden"}, Direction.NORTH.toString()));
    public static final PrefMonitor<String> CANVAS_PLACEMENT = AppPreferences.create(new PrefMonitorStringOpts("canvasPlacement", new String[]{Direction.EAST.toString(), Direction.WEST.toString()}, Direction.EAST.toString()));
    public static final PrefMonitor<String> LookAndFeel = AppPreferences.create(new PrefMonitorString("LookAndFeel", FlatIntelliJLaf.class.getName()));
    public static final int DEFAULT_CANVAS_BG_COLOR = -1;
    public static final int DEFAULT_GRID_BG_COLOR = -1;
    public static final int DEFAULT_GRID_DOT_COLOR = -8947849;
    public static final int DEFAULT_ZOOMED_DOT_COLOR = -3355444;
    public static final PrefMonitor<Integer> CANVAS_BG_COLOR = AppPreferences.create(new PrefMonitorInt("canvasBgColor", -1));
    public static final PrefMonitor<Integer> GRID_BG_COLOR = AppPreferences.create(new PrefMonitorInt("gridBgColor", -1));
    public static final PrefMonitor<Integer> GRID_DOT_COLOR = AppPreferences.create(new PrefMonitorInt("gridDotColor", -8947849));
    public static final PrefMonitor<Integer> GRID_ZOOMED_DOT_COLOR = AppPreferences.create(new PrefMonitorInt("gridZoomedDotColor", -3355444));
    public static final String ADD_AFTER_UNCHANGED = "unchanged";
    public static final String ADD_AFTER_EDIT = "edit";
    public static final PrefMonitor<Boolean> ATTRIBUTE_HALO = AppPreferences.create(new PrefMonitorBoolean("attributeHalo", true));
    public static final PrefMonitor<Boolean> COMPONENT_TIPS = AppPreferences.create(new PrefMonitorBoolean("componentTips", true));
    public static final PrefMonitor<Boolean> MOVE_KEEP_CONNECT = AppPreferences.create(new PrefMonitorBoolean("keepConnected", true));
    public static final PrefMonitor<Boolean> ADD_SHOW_GHOSTS = AppPreferences.create(new PrefMonitorBoolean("showGhosts", true));
    public static final PrefMonitor<Boolean> NAMED_CIRCUIT_BOXES_FIXED_SIZE = AppPreferences.create(new PrefMonitorBoolean("namedBoxesFixed", true));
    public static final PrefMonitor<Boolean> KMAP_LINED_STYLE = AppPreferences.create(new PrefMonitorBoolean("KmapLinedStyle", false));
    public static final PrefMonitor<String> DefaultAppearance = AppPreferences.create(new PrefMonitorStringOpts("defaultAppearance", new String[]{StdAttr.APPEAR_CLASSIC.toString(), StdAttr.APPEAR_FPGA.toString(), StdAttr.APPEAR_EVOLUTION.toString()}, StdAttr.APPEAR_EVOLUTION.toString()));
    public static final PrefMonitor<Boolean> NEW_INPUT_OUTPUT_SHAPES = AppPreferences.create(new PrefMonitorBooleanConvert("oldIO", true));
    public static final PrefMonitor<Double> SCALE_FACTOR = AppPreferences.create(new PrefMonitorDouble("Scale", Math.max(AppPreferences.getAutoScaleFactor(), 1.0)));
    public static final PrefMonitor<String> ADD_AFTER = AppPreferences.create(new PrefMonitorStringOpts("afterAdd", new String[]{"edit", "unchanged"}, "edit"));
    public static final String PIN_APPEAR_DOT_SMALL = "dot-small";
    public static final String PIN_APPEAR_DOT_MEDIUM = "dot-medium";
    public static final String PIN_APPEAR_DOT_BIG = "dot-big";
    public static final String PIN_APPEAR_DOT_BIGGER = "dot-bigger";
    public static final PrefMonitor<String> PinAppearance = AppPreferences.create(new PrefMonitorStringOpts("pinAppearance", new String[]{"dot-small", "dot-medium", "dot-big", "dot-bigger"}, "dot-small"));
    public static final PrefMonitor<String> POKE_WIRE_RADIX1;
    public static final PrefMonitor<String> POKE_WIRE_RADIX2;
    public static final PrefMonitor<Boolean> Memory_Startup_Unknown;
    public static final PrefMonitor<Integer> TRUE_COLOR;
    public static final PrefMonitor<String> TRUE_CHAR;
    public static final PrefMonitor<Integer> FALSE_COLOR;
    public static final PrefMonitor<String> FALSE_CHAR;
    public static final PrefMonitor<Integer> UNKNOWN_COLOR;
    public static final PrefMonitor<String> UNKNOWN_CHAR;
    public static final PrefMonitor<Integer> ERROR_COLOR;
    public static final PrefMonitor<String> ERROR_CHAR;
    public static final PrefMonitor<Integer> NIL_COLOR;
    public static final PrefMonitor<String> DONTCARE_CHAR;
    public static final PrefMonitor<Integer> BUS_COLOR;
    public static final PrefMonitor<Integer> STROKE_COLOR;
    public static final PrefMonitor<Integer> WIDTH_ERROR_COLOR;
    public static final PrefMonitor<Integer> WIDTH_ERROR_CAPTION_COLOR;
    public static final PrefMonitor<Integer> WIDTH_ERROR_HIGHLIGHT_COLOR;
    public static final PrefMonitor<Integer> WIDTH_ERROR_BACKGROUND_COLOR;
    public static final PrefMonitor<Integer> CLOCK_FREQUENCY_COLOR;
    public static final PrefMonitor<Integer> KMAP1_COLOR;
    public static final PrefMonitor<Integer> KMAP2_COLOR;
    public static final PrefMonitor<Integer> KMAP3_COLOR;
    public static final PrefMonitor<Integer> KMAP4_COLOR;
    public static final PrefMonitor<Integer> KMAP5_COLOR;
    public static final PrefMonitor<Integer> KMAP6_COLOR;
    public static final PrefMonitor<Integer> KMAP7_COLOR;
    public static final PrefMonitor<Integer> KMAP8_COLOR;
    public static final PrefMonitor<Integer> KMAP9_COLOR;
    public static final PrefMonitor<Integer> KMAP10_COLOR;
    public static final PrefMonitor<Integer> KMAP11_COLOR;
    public static final PrefMonitor<Integer> KMAP12_COLOR;
    public static final PrefMonitor<Integer> KMAP13_COLOR;
    public static final PrefMonitor<Integer> KMAP14_COLOR;
    public static final PrefMonitor<Integer> KMAP15_COLOR;
    public static final PrefMonitor<Integer> KMAP16_COLOR;
    public static final PrefMonitor<Integer> FPGA_DEFINE_COLOR;
    public static final PrefMonitor<Integer> FPGA_DEFINE_HIGHLIGHT_COLOR;
    public static final PrefMonitor<Integer> FPGA_DEFINE_RESIZE_COLOR;
    public static final PrefMonitor<Integer> FPGA_DEFINE_MOVE_COLOR;
    public static final PrefMonitor<Integer> FPGA_MAPPED_COLOR;
    public static final PrefMonitor<Integer> FPGA_SELECTED_MAPPED_COLOR;
    public static final PrefMonitor<Integer> FPGA_SELECTABLE_MAPPED_COLOR;
    public static final PrefMonitor<Integer> FPGA_SELECT_COLOR;
    public static final String ACCEL_DEFAULT = "default";
    public static final String ACCEL_NONE = "none";
    public static final String ACCEL_OPENGL = "opengl";
    public static final String ACCEL_D3D = "d3d";
    public static final PrefMonitor<String> GRAPHICS_ACCELERATION;
    public static final PrefMonitor<Boolean> AntiAliassing;
    public static final PrefMonitor<String> QUESTA_PATH;
    public static final PrefMonitor<Boolean> QUESTA_VALIDATION;
    public static final PrefMonitor<String> QuartusToolPath;
    public static final PrefMonitor<String> ISEToolPath;
    public static final PrefMonitor<String> VivadoToolPath;
    public static final String RECENT_PROJECTS = "recentProjects";
    private static final RecentProjects recentProjects;
    public static final PrefMonitor<Double> TICK_FREQUENCY;
    public static final PrefMonitor<Boolean> LAYOUT_SHOW_GRID;
    public static final PrefMonitor<Double> LAYOUT_ZOOM;
    public static final PrefMonitor<Boolean> APPEARANCE_SHOW_GRID;
    public static final PrefMonitor<Double> APPEARANCE_ZOOM;
    public static final PrefMonitor<Integer> WINDOW_STATE;
    public static final PrefMonitor<Integer> WINDOW_WIDTH;
    public static final PrefMonitor<Integer> WINDOW_HEIGHT;
    public static final PrefMonitor<String> WINDOW_LOCATION;
    public static final PrefMonitor<Double> WINDOW_MAIN_SPLIT;
    public static final PrefMonitor<Double> WINDOW_LEFT_SPLIT;
    public static final PrefMonitor<Double> WINDOW_RIGHT_SPLIT;
    public static final PrefMonitor<String> DIALOG_DIRECTORY;

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(listener);
    }

    public static void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public static void clear() {
        try {
            AppPreferences.getPrefs(true).clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private static File convertFile(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        File file = new File(fileName);
        return file.canRead() ? file : null;
    }

    private static <E> PrefMonitor<E> create(PrefMonitor<E> monitor) {
        return monitor;
    }

    static void firePropertyChange(String property, boolean oldVal, boolean newVal) {
        propertySupport.firePropertyChange(property, oldVal, newVal);
    }

    static void firePropertyChange(String property, Object oldVal, Object newVal) {
        propertySupport.firePropertyChange(property, oldVal, newVal);
    }

    private static Template getCustomTemplate() {
        File toRead = templateFile;
        if (customTemplateFile == null || !customTemplateFile.equals(toRead)) {
            if (toRead == null) {
                customTemplate = null;
                customTemplateFile = null;
            } else {
                try (FileInputStream reader = new FileInputStream(toRead);){
                    customTemplate = Template.create(reader);
                    customTemplateFile = templateFile;
                }
                catch (Exception t) {
                    AppPreferences.setTemplateFile(null);
                    customTemplate = null;
                    customTemplateFile = null;
                }
            }
        }
        return customTemplate == null ? AppPreferences.getPlainTemplate() : customTemplate;
    }

    public static Template getEmptyTemplate() {
        if (emptyTemplate == null) {
            emptyTemplate = Template.createEmpty();
        }
        return emptyTemplate;
    }

    private static Template getPlainTemplate() {
        if (plainTemplate == null) {
            ClassLoader ld = Startup.class.getClassLoader();
            InputStream in = ld.getResourceAsStream("resources/logisim/default.templ");
            if (in == null) {
                plainTemplate = AppPreferences.getEmptyTemplate();
            } else {
                try (InputStream inputStream = in;){
                    plainTemplate = Template.create(in);
                }
                catch (Exception e) {
                    plainTemplate = AppPreferences.getEmptyTemplate();
                }
            }
        }
        return plainTemplate;
    }

    public static Preferences getPrefs() {
        return AppPreferences.getPrefs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Preferences getPrefs(boolean shouldClear) {
        if (prefs != null) return prefs;
        Class<AppPreferences> clazz = AppPreferences.class;
        synchronized (AppPreferences.class) {
            if (prefs != null) return prefs;
            Preferences p = Preferences.userNodeForPackage(Main.class);
            if (shouldClear) {
                try {
                    p.clear();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
            myListener = new MyListener();
            p.addPreferenceChangeListener(myListener);
            prefs = p;
            AppPreferences.setTemplateFile(AppPreferences.convertFile(p.get(TEMPLATE_FILE, null)));
            AppPreferences.setTemplateType(p.getInt(TEMPLATE_TYPE, 1));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return prefs;
        }
    }

    public static List<File> getRecentFiles() {
        return recentProjects.getRecentFiles();
    }

    public static Template getTemplate() {
        AppPreferences.getPrefs();
        return switch (templateType) {
            case 0 -> AppPreferences.getEmptyTemplate();
            case 2 -> AppPreferences.getCustomTemplate();
            default -> AppPreferences.getPlainTemplate();
        };
    }

    public static File getTemplateFile() {
        AppPreferences.getPrefs();
        return templateFile;
    }

    public static int getTemplateType() {
        AppPreferences.getPrefs();
        int ret = templateType;
        if (ret == 2 && templateFile == null) {
            ret = -1;
        }
        return ret;
    }

    public static void handleGraphicsAcceleration() {
        try {
            String accel = GRAPHICS_ACCELERATION.get();
            System.setProperty("sun.java2d.opengl", Boolean.toString(accel.equals(ACCEL_OPENGL)));
            System.setProperty("sun.java2d.d3d", Boolean.toString(accel.equals(ACCEL_D3D)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public static void setTemplateFile(File value) {
        AppPreferences.getPrefs();
        AppPreferences.setTemplateFile(value, null);
    }

    public static void setTemplateFile(File value, Template template) {
        AppPreferences.getPrefs();
        if (value != null && !value.canRead()) {
            value = null;
        }
        if (!Objects.equals(value, templateFile)) {
            try {
                customTemplateFile = template == null ? null : value;
                customTemplate = template;
                AppPreferences.getPrefs().put(TEMPLATE_FILE, value == null ? "" : value.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void setTemplateType(int value) {
        AppPreferences.getPrefs();
        if (value != 1 && value != 0 && value != 2) {
            value = -1;
        }
        if (value != -1 && templateType != value) {
            AppPreferences.getPrefs().putInt(TEMPLATE_TYPE, value);
        }
    }

    public static void setScaledFonts(Component[] comp) {
        for (Component component : comp) {
            if (component instanceof Container) {
                AppPreferences.setScaledFonts(((Container)component).getComponents());
            }
            try {
                component.setFont(AppPreferences.getScaledFont(component.getFont()));
                component.revalidate();
                component.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getDownScaled(int value, float extScale) {
        AppPreferences.getPrefs();
        float scale = (float)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0f;
        return (int)((float)value / (scale *= extScale));
    }

    public static int getDownScaled(int value) {
        AppPreferences.getPrefs();
        float scale = (float)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0f;
        return (int)((float)value / scale);
    }

    public static double getDownScaled(double value) {
        AppPreferences.getPrefs();
        return value / SCALE_FACTOR.get();
    }

    public static int getScaled(int value, float extScale) {
        AppPreferences.getPrefs();
        float scale = (float)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0f;
        return (int)((float)value * (scale *= extScale));
    }

    public static int getScaled(int value) {
        AppPreferences.getPrefs();
        float scale = (float)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0f;
        return (int)((float)value * scale);
    }

    public static float getScaled(float value) {
        AppPreferences.getPrefs();
        float scale = (float)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0f;
        return value * scale;
    }

    public static float getScaled(float value, float extscale) {
        AppPreferences.getPrefs();
        float scale = (float)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0f;
        return value * (scale *= extscale);
    }

    public static double getScaled(double value) {
        AppPreferences.getPrefs();
        double scale = (double)((int)(SCALE_FACTOR.get() * 10.0)) / 10.0;
        return value * scale;
    }

    public static Font getScaledFont(Font myfont) {
        if (myfont != null) {
            return myfont.deriveFont(AppPreferences.getScaled(14.0f));
        }
        return null;
    }

    public static Font getScaledFont(Font myfont, float scale) {
        if (myfont != null) {
            return myfont.deriveFont(AppPreferences.getScaled(14.0f, scale));
        }
        return null;
    }

    public static ImageIcon getScaledImageIcon(ImageIcon icon) {
        Image iconImage = icon.getImage();
        return new ImageIcon(iconImage.getScaledInstance(AppPreferences.getScaled(16), AppPreferences.getScaled(16), 4));
    }

    public static ImageIcon getScaledImageIcon(ImageIcon icon, float scale) {
        Image iconImage = icon.getImage();
        return new ImageIcon(iconImage.getScaledInstance(AppPreferences.getScaled(16, scale), AppPreferences.getScaled(16, scale), 4));
    }

    public static void updateRecentFile(File file) {
        recentProjects.updateRecent(file);
    }

    public static int getIconSize() {
        return AppPreferences.getScaled(16);
    }

    public static int getIconBorder() {
        return AppPreferences.getScaled(2);
    }

    public static void setDefaultGridColors() {
        CANVAS_BG_COLOR.set(-1);
        GRID_BG_COLOR.set(-1);
        GRID_DOT_COLOR.set(-8947849);
        GRID_ZOOMED_DOT_COLOR.set(-3355444);
    }

    public static AttributeOption getDefaultAppearance() {
        if (DefaultAppearance.get().equals(StdAttr.APPEAR_EVOLUTION.toString())) {
            return StdAttr.APPEAR_EVOLUTION;
        }
        return StdAttr.APPEAR_CLASSIC;
    }

    public static AttributeOption getDefaultCircuitAppearance() {
        if (DefaultAppearance.get().equals(StdAttr.APPEAR_EVOLUTION.toString())) {
            return StdAttr.APPEAR_EVOLUTION;
        }
        if (DefaultAppearance.get().equals(StdAttr.APPEAR_FPGA.toString())) {
            return StdAttr.APPEAR_FPGA;
        }
        return StdAttr.APPEAR_CLASSIC;
    }

    public static double getAutoScaleFactor() {
        return (!GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getScreenSize().getHeight() : 0.0) / 1000.0;
    }

    public static void resetWindow() {
        CANVAS_PLACEMENT.set(Direction.EAST.toString());
        WINDOW_MAIN_SPLIT.set(0.251);
        WINDOW_LEFT_SPLIT.set(0.51);
        WINDOW_RIGHT_SPLIT.set(0.751);
    }

    static {
        RadixOption[] radixOptions = RadixOption.OPTIONS;
        String[] radixStrings = new String[radixOptions.length];
        for (int i = 0; i < radixOptions.length; ++i) {
            radixStrings[i] = radixOptions[i].getSaveString();
        }
        POKE_WIRE_RADIX1 = AppPreferences.create(new PrefMonitorStringOpts("pokeRadix1", radixStrings, RadixOption.RADIX_2.getSaveString()));
        POKE_WIRE_RADIX2 = AppPreferences.create(new PrefMonitorStringOpts("pokeRadix2", radixStrings, RadixOption.RADIX_10_SIGNED.getSaveString()));
        Memory_Startup_Unknown = AppPreferences.create(new PrefMonitorBoolean("MemStartUnknown", false));
        TRUE_COLOR = AppPreferences.create(new PrefMonitorInt("SimTrueColor", 53760));
        TRUE_CHAR = AppPreferences.create(new PrefMonitorString("SimTrueChar", "1 "));
        FALSE_COLOR = AppPreferences.create(new PrefMonitorInt("SimFalseColor", 25600));
        FALSE_CHAR = AppPreferences.create(new PrefMonitorString("SimFalseChar", "0 "));
        UNKNOWN_COLOR = AppPreferences.create(new PrefMonitorInt("SimUnknownColor", 0x2828FF));
        UNKNOWN_CHAR = AppPreferences.create(new PrefMonitorString("SimUnknownChar", "U "));
        ERROR_COLOR = AppPreferences.create(new PrefMonitorInt("SimErrorColor", 0xC00000));
        ERROR_CHAR = AppPreferences.create(new PrefMonitorString("SimErrorChar", "E "));
        NIL_COLOR = AppPreferences.create(new PrefMonitorInt("SimNilColor", 0x808080));
        DONTCARE_CHAR = AppPreferences.create(new PrefMonitorString("SimDontCareChar", "- "));
        BUS_COLOR = AppPreferences.create(new PrefMonitorInt("SimBusColor", 0));
        STROKE_COLOR = AppPreferences.create(new PrefMonitorInt("SimStrokeColor", 0xFF00FF));
        WIDTH_ERROR_COLOR = AppPreferences.create(new PrefMonitorInt("SimWidthErrorColor", 16743168));
        WIDTH_ERROR_CAPTION_COLOR = AppPreferences.create(new PrefMonitorInt("SimWidthErrorCaptionColor", 0x550000));
        WIDTH_ERROR_HIGHLIGHT_COLOR = AppPreferences.create(new PrefMonitorInt("SimWidthErrorHighlightColor", 0xFFFF00));
        WIDTH_ERROR_BACKGROUND_COLOR = AppPreferences.create(new PrefMonitorInt("SimWidthErrorBackgroundColor", 16770770));
        CLOCK_FREQUENCY_COLOR = AppPreferences.create(new PrefMonitorInt("SimClockFrequencyColor", 16711860));
        KMAP1_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor1", 0x800000));
        KMAP2_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor2", 15079755));
        KMAP3_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor3", 16432830));
        KMAP4_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor4", 11169320));
        KMAP5_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor5", 16089648));
        KMAP6_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor6", 16766900));
        KMAP7_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor7", 0x808000));
        KMAP8_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor8", 0xFFFF19));
        KMAP9_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor9", 13825340));
        KMAP10_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor10", 128));
        KMAP11_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor11", 9510580));
        KMAP12_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor12", 3978415));
        KMAP13_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor13", 33483));
        KMAP14_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor14", 15122175));
        KMAP15_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor15", 11206595));
        KMAP16_COLOR = AppPreferences.create(new PrefMonitorInt("KMAPColor16", 15741670));
        FPGA_DEFINE_COLOR = AppPreferences.create(new PrefMonitorInt("FPGADefineColor", 0xFF0000));
        FPGA_DEFINE_HIGHLIGHT_COLOR = AppPreferences.create(new PrefMonitorInt("FPGADefineHighlightColor", 65280));
        FPGA_DEFINE_RESIZE_COLOR = AppPreferences.create(new PrefMonitorInt("FPGADefineResizeColor", 65535));
        FPGA_DEFINE_MOVE_COLOR = AppPreferences.create(new PrefMonitorInt("FPGADefineMoveColor", 0xFF00FF));
        FPGA_MAPPED_COLOR = AppPreferences.create(new PrefMonitorInt("FPGAMappedColor", 20480));
        FPGA_SELECTED_MAPPED_COLOR = AppPreferences.create(new PrefMonitorInt("FPGASelectedMappedColor", 0xFF0000));
        FPGA_SELECTABLE_MAPPED_COLOR = AppPreferences.create(new PrefMonitorInt("FPGASelectableMappedColor", 40960));
        FPGA_SELECT_COLOR = AppPreferences.create(new PrefMonitorInt("FPGASelectColor", 255));
        GRAPHICS_ACCELERATION = AppPreferences.create(new PrefMonitorStringOpts("graphicsAcceleration", new String[]{ACCEL_DEFAULT, ACCEL_NONE, ACCEL_OPENGL, ACCEL_D3D}, ACCEL_DEFAULT));
        AntiAliassing = AppPreferences.create(new PrefMonitorBoolean("AntiAliassing", true));
        QUESTA_PATH = AppPreferences.create(new PrefMonitorString("questaPath", ""));
        QUESTA_VALIDATION = AppPreferences.create(new PrefMonitorBoolean("questaValidation", false));
        QuartusToolPath = AppPreferences.create(new PrefMonitorString("QuartusToolPath", ""));
        ISEToolPath = AppPreferences.create(new PrefMonitorString("ISEToolPath", ""));
        VivadoToolPath = AppPreferences.create(new PrefMonitorString("VivadoToolPath", ""));
        recentProjects = new RecentProjects();
        TICK_FREQUENCY = AppPreferences.create(new PrefMonitorDouble("tickFrequency", 1.0));
        LAYOUT_SHOW_GRID = AppPreferences.create(new PrefMonitorBoolean("layoutGrid", true));
        LAYOUT_ZOOM = AppPreferences.create(new PrefMonitorDouble("layoutZoom", 1.0));
        APPEARANCE_SHOW_GRID = AppPreferences.create(new PrefMonitorBoolean("appearanceGrid", true));
        APPEARANCE_ZOOM = AppPreferences.create(new PrefMonitorDouble("appearanceZoom", 1.0));
        WINDOW_STATE = AppPreferences.create(new PrefMonitorInt("windowState", 0));
        WINDOW_WIDTH = AppPreferences.create(new PrefMonitorInt("windowWidth", (!GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getScreenSize().width : 0) / 2));
        WINDOW_HEIGHT = AppPreferences.create(new PrefMonitorInt("windowHeight", !GraphicsEnvironment.isHeadless() ? Toolkit.getDefaultToolkit().getScreenSize().height : 0));
        WINDOW_LOCATION = AppPreferences.create(new PrefMonitorString("windowLocation", "0,0"));
        WINDOW_MAIN_SPLIT = AppPreferences.create(new PrefMonitorDouble("windowMainSplit", 0.25));
        WINDOW_LEFT_SPLIT = AppPreferences.create(new PrefMonitorDouble("windowLeftSplit", 0.5));
        WINDOW_RIGHT_SPLIT = AppPreferences.create(new PrefMonitorDouble("windowRightSplit", 0.75));
        DIALOG_DIRECTORY = AppPreferences.create(new PrefMonitorString("dialogDirectory", ""));
    }

    private static class MyListener
    implements PreferenceChangeListener,
    LocaleListener {
        private MyListener() {
        }

        @Override
        public void localeChanged() {
            Locale loc = LocaleManager.getLocale();
            String lang = loc.getLanguage();
            if (LOCALE != null) {
                LOCALE.set(lang);
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent event) {
            Preferences prefs = event.getNode();
            String prop = event.getKey();
            if (prop.equals(AppPreferences.TEMPLATE_TYPE)) {
                int oldValue = templateType;
                int value = prefs.getInt(AppPreferences.TEMPLATE_TYPE, -1);
                if (value != oldValue) {
                    templateType = value;
                    propertySupport.firePropertyChange(AppPreferences.TEMPLATE, oldValue, value);
                    propertySupport.firePropertyChange(AppPreferences.TEMPLATE_TYPE, oldValue, value);
                }
            } else if (prop.equals(AppPreferences.TEMPLATE_FILE)) {
                File oldValue = templateFile;
                File value = AppPreferences.convertFile(prefs.get(AppPreferences.TEMPLATE_FILE, null));
                if (!Objects.equals(value, oldValue)) {
                    templateFile = value;
                    if (templateType == 2) {
                        customTemplate = null;
                        propertySupport.firePropertyChange(AppPreferences.TEMPLATE, oldValue, value);
                    }
                    propertySupport.firePropertyChange(AppPreferences.TEMPLATE_FILE, oldValue, value);
                }
            }
        }
    }

    private static class LocalePreference
    extends PrefMonitorString {
        private static Locale findLocale(String lang) {
            for (int set = 0; set < 2; ++set) {
                Locale[] check;
                Locale[] localeArray;
                if (set == 0) {
                    Locale[] localeArray2 = new Locale[2];
                    localeArray2[0] = Locale.getDefault();
                    localeArray = localeArray2;
                    localeArray2[1] = Locale.ENGLISH;
                } else {
                    localeArray = Locale.getAvailableLocales();
                }
                for (Locale loc : check = localeArray) {
                    if (loc == null || !loc.getLanguage().equals(lang)) continue;
                    return loc;
                }
            }
            return null;
        }

        public LocalePreference() {
            super("locale", "");
            String localeStr = this.get();
            if (!"".equals(localeStr)) {
                LocaleManager.setLocale(Locale.forLanguageTag(localeStr));
            }
            LocaleManager.addLocaleListener(myListener);
            myListener.localeChanged();
        }

        @Override
        public void set(String value) {
            if (LocalePreference.findLocale(value) != null) {
                super.set(value);
            }
        }
    }
}

