/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.fpga.file.BoardReaderClass;
import com.cburch.logisim.fpga.settings.BoardList;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FpgaBoards
implements ActionListener {
    private static final String ExtBoard = "ExtBoardDescr";
    private static final int MaxBoards = 20;
    private final BoardList buildInBoards = new BoardList();
    private JScrollPane boardPane;
    private JList<String> boardNamesList;
    private JButton addButton;
    private JButton removeButton;
    private JComboBox<String> boardSelector;
    private final ExternalBoardModel extBoardModel = new ExternalBoardModel();

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addButton)) {
            this.addBoard(false);
        } else if (e.getSource().equals(this.removeButton)) {
            String board = this.boardNamesList.getSelectedValue();
            if (this.removeBoard(board)) {
                if (AppPreferences.SelectedBoard.get().equals(board)) {
                    if (this.boardSelector != null && this.boardSelector.getItemCount() >= 2) {
                        AppPreferences.SelectedBoard.set(this.boardSelector.getItemAt(1));
                    } else {
                        this.boardSelector = new JComboBox();
                        this.rebuildBoardSelector(false, null);
                        AppPreferences.SelectedBoard.set(this.boardSelector.getItemAt(1));
                    }
                }
                if (this.boardNamesList.getSelectedIndex() >= this.boardNamesList.getModel().getSize() && this.boardNamesList.getModel().getSize() > 0) {
                    this.boardNamesList.setSelectedIndex(this.boardNamesList.getModel().getSize() - 1);
                }
                this.updateButtons();
                this.boardNamesList.repaint();
                this.rebuildBoardSelector(false, null);
            }
        } else if (e.getSource().equals(this.boardSelector)) {
            if (this.boardSelector.getSelectedItem() == null) {
                return;
            }
            if (this.boardSelector.getSelectedItem().equals("Other")) {
                if (!this.addBoard(true)) {
                    this.rebuildBoardSelector(false, null);
                }
            } else {
                AppPreferences.SelectedBoard.set(this.boardSelector.getSelectedItem().toString());
            }
        }
    }

    public FpgaBoards() {
        Preferences prefs = AppPreferences.getPrefs();
        for (int i = 0; i < 20; ++i) {
            String encoding = prefs.get(ExtBoard + i, null);
            if (encoding == null) continue;
            this.addExternalBoard(encoding, i, prefs);
        }
        String selectedBoard = AppPreferences.SelectedBoard.get();
        if (!this.buildInBoards.getBoardNames().contains(selectedBoard)) {
            AppPreferences.SelectedBoard.set(this.buildInBoards.getBoardNames().get(0));
        }
    }

    private boolean addExternalBoard(String filename, int oldindex, Preferences prefs) {
        File f = new File(filename);
        if (!f.exists() || f.isDirectory()) {
            if (prefs != null) {
                prefs.remove(ExtBoard + oldindex);
            }
            return false;
        }
        if (this.extBoardModel.nrOfExternalBoards() == 20) {
            return false;
        }
        if (this.extBoardModel.contains(filename)) {
            if (prefs != null) {
                prefs.remove(ExtBoard + oldindex);
            }
            return false;
        }
        this.extBoardModel.insert(filename);
        this.buildInBoards.addExternalBoard(filename);
        int index = this.extBoardModel.indexOf(filename);
        if (index != oldindex && oldindex != 20) {
            prefs.remove(ExtBoard + oldindex);
            prefs.put(ExtBoard + index, filename);
        } else if (oldindex == 20) {
            this.rebuildPrefsTree();
        }
        return true;
    }

    public boolean addExternalBoard(String filename) {
        Preferences prefs = AppPreferences.getPrefs();
        return this.addExternalBoard(filename, 20, prefs);
    }

    public String getBoardFilePath(String boardName) {
        return this.buildInBoards.getBoardFilePath(boardName);
    }

    public List<String> getBoardNames() {
        return this.buildInBoards.getBoardNames();
    }

    public String getSelectedBoardFileName() {
        return this.buildInBoards.getBoardFilePath(AppPreferences.SelectedBoard.get());
    }

    public JComboBox<String> boardSelector() {
        if (this.boardSelector == null) {
            this.boardSelector = new JComboBox();
            this.rebuildBoardSelector(false, null);
        }
        return this.boardSelector;
    }

    public JPanel addRemovePanel() {
        JPanel panel = new JPanel();
        int nrBoards = this.extBoardModel.nrOfExternalBoards();
        GridBagLayout thisLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(thisLayout);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 10;
        panel.add((Component)new JLabel(Strings.S.get("ExternalBoards")), c);
        c.gridy = 1;
        c.fill = 2;
        panel.add((Component)new JSeparator(), c);
        c.gridheight = 10;
        c.gridwidth = 1;
        c.gridy = 2;
        this.boardNamesList = new JList<String>(this.extBoardModel);
        this.boardNamesList.setSelectionMode(0);
        if (this.boardNamesList.getModel().getSize() != 0) {
            this.boardNamesList.setSelectedIndex(0);
        }
        this.boardPane = new JScrollPane(this.boardNamesList);
        panel.add((Component)this.boardPane, c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 2;
        c.gridx = 1;
        this.addButton = new JButton();
        this.addButton.setText(Strings.S.get("AddBoard"));
        this.addButton.setEnabled(nrBoards < 20);
        this.addButton.addActionListener(this);
        panel.add((Component)this.addButton, c);
        c.gridy = 3;
        this.removeButton = new JButton();
        this.removeButton.setText(Strings.S.get("RemoveBoard"));
        this.removeButton.setEnabled(nrBoards > 0);
        this.removeButton.addActionListener(this);
        panel.add((Component)this.removeButton, c);
        return panel;
    }

    private void updateButtons() {
        int size = this.extBoardModel.nrOfExternalBoards();
        if (this.addButton != null) {
            this.addButton.setEnabled(size < 20);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(size > 0);
        }
    }

    private void rebuildBoardSelector(boolean update, String board) {
        if (this.boardSelector == null) {
            return;
        }
        this.boardSelector.removeActionListener(this);
        this.boardSelector.removeAllItems();
        this.boardSelector.addItem("Other");
        int index = 1;
        boolean found = false;
        if (update) {
            AppPreferences.SelectedBoard.set(board);
        }
        for (String item : this.buildInBoards.getBoardNames()) {
            this.boardSelector.addItem(item);
            if (item.equals(AppPreferences.SelectedBoard.get())) {
                this.boardSelector.setSelectedIndex(index);
                found = true;
            }
            ++index;
        }
        if (!found) {
            AppPreferences.SelectedBoard.set(this.boardSelector.getItemAt(1));
            this.boardSelector.setSelectedIndex(1);
        }
        this.boardSelector.repaint();
        this.boardSelector.addActionListener(this);
    }

    private void removeFromPrefs(String fname) {
        Preferences prefs = AppPreferences.getPrefs();
        for (int i = 0; i < 20; ++i) {
            String name = prefs.get(ExtBoard + i, null);
            if (name == null || !name.equals(fname)) continue;
            prefs.remove(ExtBoard + i);
        }
    }

    private boolean removeBoard(String name) {
        if (name == null) {
            return false;
        }
        String qualifier = this.buildInBoards.getBoardFilePath(name);
        if (!this.extBoardModel.contains(qualifier)) {
            return false;
        }
        this.extBoardModel.remove(qualifier);
        if (!this.buildInBoards.removeExternalBoard(qualifier)) {
            return false;
        }
        this.removeFromPrefs(qualifier);
        return true;
    }

    private void rebuildPrefsTree() {
        int i;
        Preferences prefs = AppPreferences.getPrefs();
        for (i = 0; i < this.extBoardModel.getSize(); ++i) {
            prefs.put(ExtBoard + i, this.extBoardModel.get(i));
        }
        for (i = this.extBoardModel.getSize(); i < 20; ++i) {
            prefs.remove(ExtBoard + i);
        }
    }

    private boolean addBoard(boolean updateSelection) {
        if (this.extBoardModel.getSize() >= 20) {
            OptionPane.showMessageDialog(null, Strings.S.get("MaxBoardsReached"), Strings.S.get("AddExternalBoards"), 0);
            return false;
        }
        String boardFileName = this.getBoardFile();
        if (boardFileName == null) {
            return false;
        }
        BoardReaderClass test = new BoardReaderClass(boardFileName);
        if (test.getBoardInformation() == null) {
            OptionPane.showMessageDialog(null, Strings.S.get("InvalidFileFormat"), Strings.S.get("AddExternalBoards"), 0);
            return false;
        }
        if (this.buildInBoards.getBoardNames().contains(BoardList.getBoardName(boardFileName))) {
            OptionPane.showMessageDialog(null, Strings.S.get("BoardPreset") + "\"" + BoardList.getBoardName(boardFileName) + "\"", Strings.S.get("AddExternalBoards"), 0);
            return false;
        }
        if (!this.addExternalBoard(boardFileName)) {
            return false;
        }
        this.updateButtons();
        if (this.boardNamesList != null) {
            this.boardNamesList.setSelectedIndex(this.extBoardModel.indexOf(boardFileName));
        }
        this.rebuildBoardSelector(updateSelection, BoardList.getBoardName(boardFileName));
        return true;
    }

    private String getBoardFile() {
        JFileChooser fc = new JFileChooser(AppPreferences.FPGA_Workspace.get());
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Board files", "xml", "xml");
        fc.setFileFilter(filter);
        fc.setFileSelectionMode(0);
        File test = new File(AppPreferences.FPGA_Workspace.get());
        if (test.exists()) {
            fc.setSelectedFile(test);
        }
        fc.setDialogTitle(Strings.S.get("BoardSelection"));
        int retval = fc.showOpenDialog(null);
        if (retval == 0) {
            File file = fc.getSelectedFile();
            return file.getPath();
        }
        return null;
    }

    private class ExternalBoardModel
    implements ListModel<String> {
        private final SortedArrayList externalBoards = new SortedArrayList();
        private final ArrayList<ListDataListener> myListeners = new ArrayList();

        private ExternalBoardModel() {
        }

        public boolean contains(String entry) {
            return this.externalBoards.contains(entry);
        }

        public void insert(String entry) {
            this.externalBoards.insertSorted(entry);
            this.fireChange(new ListDataEvent(this, 0, this.externalBoards.size(), 1));
        }

        public int indexOf(String entry) {
            return this.externalBoards.indexOf(entry);
        }

        public void remove(String entry) {
            this.externalBoards.remove(entry);
            this.fireChange(new ListDataEvent(this, 0, this.externalBoards.size(), 2));
        }

        public int nrOfExternalBoards() {
            Iterator iter = this.externalBoards.iterator();
            boolean removed = false;
            while (iter.hasNext()) {
                String file = (String)iter.next();
                File f = new File(file);
                if (f.exists() && !f.isDirectory()) continue;
                FpgaBoards.this.buildInBoards.removeExternalBoard(file);
                FpgaBoards.this.removeFromPrefs(file);
                iter.remove();
                removed = true;
            }
            if (removed) {
                this.fireChange(new ListDataEvent(this, 0, this.externalBoards.size(), 2));
            }
            return this.externalBoards.size();
        }

        public String get(int index) {
            return (String)this.externalBoards.get(index);
        }

        @Override
        public int getSize() {
            return this.nrOfExternalBoards();
        }

        @Override
        public String getElementAt(int index) {
            int size = this.nrOfExternalBoards();
            return index < size ? BoardList.getBoardName((String)this.externalBoards.get(index)) : null;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.myListeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.myListeners.remove(l);
        }

        private void fireChange(ListDataEvent e) {
            block4: for (ListDataListener listener : this.myListeners) {
                switch (e.getType()) {
                    case 0: {
                        listener.contentsChanged(e);
                        continue block4;
                    }
                    case 1: {
                        listener.intervalAdded(e);
                        continue block4;
                    }
                }
                listener.intervalRemoved(e);
            }
        }
    }

    private static class SortedArrayList
    extends ArrayList<String> {
        private SortedArrayList() {
        }

        public void insertSorted(String value) {
            this.add(value);
            String cmp = BoardList.getBoardName(value);
            for (int i = this.size() - 1; i > 0 && cmp.compareTo(BoardList.getBoardName((String)this.get(i - 1))) < 0; --i) {
                Collections.swap(this, i, i - 1);
            }
        }
    }
}

