/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AbstractPrefMonitor;
import com.cburch.logisim.prefs.AppPreferences;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;

public class PrefMonitorBoolean
extends AbstractPrefMonitor<Boolean>
implements ActionListener {
    protected final boolean dflt;
    protected boolean value;
    private JCheckBox box;

    public PrefMonitorBoolean(String name, boolean dflt) {
        super(name);
        this.dflt = dflt;
        this.value = dflt;
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.getBoolean(name, dflt));
        prefs.addPreferenceChangeListener(this);
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier())) {
            boolean oldValue = this.value;
            boolean newValue = prefs.getBoolean(name, this.dflt);
            if (newValue != oldValue) {
                this.value = newValue;
                AppPreferences.firePropertyChange(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void set(Boolean newValue) {
        if (this.value != newValue) {
            AppPreferences.getPrefs().putBoolean(this.getIdentifier(), newValue);
        }
    }

    public JCheckBox getCheckBox() {
        this.box = new JCheckBox();
        this.box.setSelected(this.value);
        this.box.addActionListener(this);
        return this.box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.box) {
            this.set(this.box.isSelected());
        }
    }
}

