/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AbstractPrefMonitor;
import com.cburch.logisim.prefs.AppPreferences;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;

class PrefMonitorDouble
extends AbstractPrefMonitor<Double> {
    private final double dflt;
    private double value;

    public PrefMonitorDouble(String name, double dflt) {
        super(name);
        this.dflt = dflt;
        this.value = dflt;
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.getDouble(name, dflt));
        prefs.addPreferenceChangeListener(this);
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier())) {
            double oldValue = this.value;
            double newValue = prefs.getDouble(name, this.dflt);
            if (newValue != oldValue) {
                this.value = newValue;
                AppPreferences.firePropertyChange(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void set(Double newValue) {
        double newVal = newValue;
        if (this.value != newVal) {
            AppPreferences.getPrefs().putDouble(this.getIdentifier(), newVal);
        }
    }
}

