/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AbstractPrefMonitor;
import com.cburch.logisim.prefs.AppPreferences;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;

class PrefMonitorInt
extends AbstractPrefMonitor<Integer> {
    private final int dflt;
    private int value;

    public PrefMonitorInt(String name, int dflt) {
        super(name);
        this.dflt = dflt;
        this.value = dflt;
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.getInt(name, dflt));
        prefs.addPreferenceChangeListener(this);
    }

    @Override
    public Integer get() {
        return this.value;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier())) {
            int oldValue = this.value;
            int newValue = prefs.getInt(name, this.dflt);
            if (newValue != oldValue) {
                this.value = newValue;
                AppPreferences.firePropertyChange(name, oldValue, newValue);
            }
        }
    }

    @Override
    public void set(Integer newValue) {
        Integer newVal = newValue;
        if (this.value != newVal) {
            AppPreferences.getPrefs().putInt(this.getIdentifier(), newVal);
        }
    }
}

