/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.prefs;

import com.cburch.logisim.prefs.AbstractPrefMonitor;
import com.cburch.logisim.prefs.AppPreferences;
import java.util.Objects;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.Preferences;

class PrefMonitorStringOpts
extends AbstractPrefMonitor<String> {
    private final String[] opts;
    private String value;
    private final String dflt;

    private static boolean isSame(String a, String b) {
        return Objects.equals(a, b);
    }

    public PrefMonitorStringOpts(String name, String[] opts, String dflt) {
        super(name);
        this.opts = opts;
        this.value = opts[0];
        this.dflt = dflt;
        Preferences prefs = AppPreferences.getPrefs();
        this.set(prefs.get(name, dflt));
        prefs.addPreferenceChangeListener(this);
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        String newValue;
        String oldValue;
        String name;
        Preferences prefs = event.getNode();
        String prop = event.getKey();
        if (prop.equals(name = this.getIdentifier()) && !PrefMonitorStringOpts.isSame(oldValue = this.value, newValue = prefs.get(name, this.dflt))) {
            String chosen = null;
            for (String s : this.opts) {
                if (!PrefMonitorStringOpts.isSame(s, newValue)) continue;
                chosen = s;
                break;
            }
            if (chosen == null) {
                chosen = this.dflt;
            }
            this.value = chosen;
            AppPreferences.firePropertyChange(name, oldValue, chosen);
        }
    }

    @Override
    public void set(String newValue) {
        String oldValue = this.value;
        if (!PrefMonitorStringOpts.isSame(oldValue, newValue)) {
            AppPreferences.getPrefs().put(this.getIdentifier(), newValue);
        }
    }
}

