/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import java.util.HashSet;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class AssemblerHighlighter
extends AbstractTokenMaker {
    public static final int REPEAT_LAST = -1;
    public static final int DOUBLE_QUOTE_END = -2;
    public static final int MAYBE_SHIFT_LEFT = -3;
    public static final int MAYBE_SHIFT_RIGHT = -4;
    public static final int SHIFT_END = -5;
    private boolean escape = false;
    private static final String[] directives = new String[]{".ascii", ".align", ".file", ".globl", ".local", ".comm", ".common", ".ident", ".section", ".size", ".text", ".data", ".rodata", ".bss", ".string", ".p2align", ".asciz", ".equ", ".macro", ".endm", ".type", ".option", ".byte", ".2byte", ".half", ".short", ".4byte", ".word", ".long", ".8byte", ".dword", ".quad", ".balign", ".zero", ".org"};
    public static final HashSet<String> BYTES = new HashSet<String>(){
        {
            this.add(".byte");
        }
    };
    public static final HashSet<String> SHORTS = new HashSet<String>(){
        {
            this.add(".half");
            this.add(".2byte");
            this.add(".short");
        }
    };
    public static final HashSet<String> INTS = new HashSet<String>(){
        {
            this.add(".word");
            this.add(".4byte");
            this.add(".long");
        }
    };
    public static final HashSet<String> LONGS = new HashSet<String>(){
        {
            this.add(".dword");
            this.add(".8byte");
            this.add(".quad");
        }
    };
    public static final HashSet<String> STRINGS = new HashSet<String>(){
        {
            this.add(".ascii");
            this.add(".asciz");
            this.add(".string");
        }
    };

    @Override
    public TokenMap getWordsToHighlight() {
        TokenMap map = new TokenMap();
        for (String directive : directives) {
            map.put(directive, 8);
        }
        return map;
    }

    @Override
    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        int value;
        if (tokenType == 20 && (value = this.wordsToHighlight.get(segment, start, end)) != -1) {
            tokenType = value;
        }
        super.addToken(segment, start, end, tokenType, startOffset);
    }

    private int check(Segment text, char kar, int currentToken, int start, int index, int newStart) {
        int currentTokenType;
        int n = currentTokenType = currentToken >= 0 ? currentToken : 14;
        if (currentTokenType == 1) {
            return 1;
        }
        if (currentTokenType == 13 && (kar != '\"' || this.escape)) {
            this.escape = kar == '\\';
            return 13;
        }
        switch (kar) {
            case '\t': 
            case ' ': {
                if (currentTokenType != 0 && currentTokenType != 21) {
                    this.addToken(text, start, index - 1, currentTokenType, newStart);
                }
                return 21;
            }
            case '\"': {
                if (currentTokenType == 13) {
                    this.addToken(text, start, index, currentTokenType, newStart);
                    return -2;
                }
                if (currentTokenType != 0) {
                    this.addToken(text, start, index - 1, currentTokenType, newStart);
                }
                this.escape = false;
                return 13;
            }
            case '#': {
                if (currentTokenType != 0) {
                    this.addToken(text, start, index - 1, currentTokenType, newStart);
                }
                return 1;
            }
            case '<': {
                if (currentToken != -3) {
                    if (currentTokenType != 0) {
                        this.addToken(text, start, index - 1, currentTokenType, newStart);
                    }
                    return -3;
                }
                this.addToken(text, start, index, currentTokenType, newStart);
                return -5;
            }
            case '>': {
                if (currentToken != -4) {
                    if (currentTokenType != 0) {
                        this.addToken(text, start, index - 1, currentTokenType, newStart);
                    }
                    return -4;
                }
                this.addToken(text, start, index, currentTokenType, newStart);
                return -5;
            }
            case '@': {
                if (currentTokenType != 0) {
                    this.addToken(text, start, index - 1, currentTokenType, newStart);
                }
                return currentTokenType == 24 ? -1 : 24;
            }
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (currentTokenType != 0) {
                    this.addToken(text, start, index - 1, currentTokenType, newStart);
                }
                return currentTokenType == 14 ? -1 : 14;
            }
            case 'X': 
            case 'x': {
                if (currentTokenType != 10) break;
                return 12;
            }
        }
        if (currentTokenType == 20) {
            return 20;
        }
        if (RSyntaxUtilities.isDigit(kar)) {
            if (currentTokenType == 24) {
                return 24;
            }
            if (currentTokenType != 0 && currentTokenType != 10 && currentTokenType != 12) {
                this.addToken(text, start, index - 1, currentTokenType, newStart);
            }
            return currentTokenType != 12 ? 10 : currentTokenType;
        }
        if (RSyntaxUtilities.isHexCharacter(kar) && currentTokenType == 12) {
            return currentTokenType;
        }
        if (currentTokenType != 0) {
            this.addToken(text, start, index - 1, currentTokenType, newStart);
        }
        return 20;
    }

    @Override
    public Token getTokenList(Segment arg0, int arg1, int arg2) {
        this.resetTokenList();
        char[] array = arg0.array;
        int offset = arg0.offset;
        int count = arg0.count;
        int end = offset + count;
        int newStartOffset = arg2 - offset;
        int currentTokenStart = offset;
        int currentTokenType = arg1;
        this.escape = false;
        for (int i = offset; i < end; ++i) {
            char c = array[i];
            int newTokenType = this.check(arg0, c, currentTokenType, currentTokenStart, i, newStartOffset + currentTokenStart);
            if (newTokenType != currentTokenType && (newTokenType != 12 || currentTokenType != 10)) {
                currentTokenStart = i;
            }
            if (newTokenType == -2 || newTokenType == -5) {
                currentTokenStart = i + 1;
                currentTokenType = 0;
                continue;
            }
            if (newTokenType == -1) {
                currentTokenStart = i;
                continue;
            }
            currentTokenType = newTokenType;
        }
        switch (currentTokenType) {
            case 13: {
                this.addToken(arg0, currentTokenStart, end - 1, currentTokenType, newStartOffset + currentTokenStart);
                break;
            }
            case 0: {
                this.addNullToken();
                break;
            }
            default: {
                this.addToken(arg0, currentTokenStart, end - 1, currentTokenType, newStartOffset + currentTokenStart);
                this.addNullToken();
            }
        }
        return this.firstToken;
    }
}

