/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocUpSimulationStateListener;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;

public class SocUpSimulationState {
    public static final int SIMULATION_RUNNING = 0;
    public static final int SIMULATION_HALTED_BY_ERROR = 1;
    public static final int SIMULATION_HALTED_BY_BREAKPOINT = 2;
    public static final int SIMULATION_HALTED_BY_STOP = 3;
    private int simulationState = 0;
    private final ArrayList<SocUpSimulationStateListener> listeners = new ArrayList();
    private boolean canContinueAfterBreak = false;

    public String getStateString() {
        return switch (this.simulationState) {
            case 0 -> Strings.S.get("SocUpSimRunning");
            case 1 -> Strings.S.get("SocUpSimHaltError");
            case 2 -> Strings.S.get("SocUpSimHaltBreak");
            case 3 -> Strings.S.get("SocUpSimHalt");
            default -> Strings.S.get("SocUpUnknown");
        };
    }

    public void registerListener(SocUpSimulationStateListener l) {
        this.listeners.add(l);
    }

    public void reset() {
        this.canContinueAfterBreak = false;
        this.simulationState = 3;
        this.fireChange();
    }

    public boolean canExecute() {
        return this.simulationState == 0;
    }

    public void errorInExecution() {
        this.simulationState = 1;
        this.fireChange();
    }

    public boolean breakPointReached() {
        if (this.canContinueAfterBreak) {
            this.canContinueAfterBreak = false;
            return false;
        }
        this.simulationState = 2;
        this.fireChange();
        return true;
    }

    public void buttonPressed() {
        if (this.simulationState == 0) {
            this.simulationState = 3;
        } else {
            if (this.simulationState == 2) {
                this.canContinueAfterBreak = true;
            }
            this.simulationState = 0;
        }
        this.fireChange();
    }

    public static Bounds getButtonLocation(int xoff, int yoff, Bounds b) {
        int width = b.getWidth() / 3;
        int xpos = xoff + b.getX() + 2 * width;
        return Bounds.create(xpos, yoff + b.getY(), width, b.getHeight());
    }

    public static Bounds getStateLocation(int xoff, int yoff, Bounds b) {
        int width = b.getWidth() / 3;
        int xpos = xoff + b.getX() + width;
        return Bounds.create(xpos, yoff + b.getY(), width, b.getHeight());
    }

    public static Bounds getLabelLocation(int xoff, int yoff, Bounds b) {
        int width = b.getWidth() / 3;
        int xpos = xoff + b.getX();
        return Bounds.create(xpos, yoff + b.getY(), width, b.getHeight());
    }

    private void paintState(Graphics g, int x, int y, Bounds b) {
        Bounds state = SocUpSimulationState.getStateLocation(x, y, b);
        g.setColor(Color.BLACK);
        g.drawRect(state.getX(), state.getY(), state.getWidth(), state.getHeight());
        switch (this.simulationState) {
            case 0: {
                g.setColor(Color.GREEN);
                break;
            }
            case 1: {
                g.setColor(Color.RED);
                break;
            }
            case 2: {
                g.setColor(Color.MAGENTA);
            }
        }
        GraphicsUtil.drawCenteredText(g, this.getStateString(), state.getCenterX(), state.getCenterY());
    }

    public void paint(Graphics g, int x, int y, Bounds b) {
        Bounds button = SocUpSimulationState.getButtonLocation(x, y, b);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(button.getX(), button.getY(), button.getWidth(), button.getHeight());
        g.setColor(Color.BLUE);
        Font f = g.getFont();
        g.setFont(StdAttr.DEFAULT_LABEL_FONT);
        String bname = this.simulationState == 0 ? Strings.S.get("SocUpSimstateStop") : Strings.S.get("SocUpSimstateStart");
        GraphicsUtil.drawCenteredText(g, bname, button.getCenterX(), button.getCenterY());
        Bounds labloc = SocUpSimulationState.getLabelLocation(x, y, b);
        g.setColor(Color.black);
        GraphicsUtil.drawCenteredText(g, Strings.S.get("SocUpSimStateLabel"), labloc.getCenterX(), labloc.getCenterY());
        g.setFont(f);
        this.paintState(g, x, y, b);
    }

    private void fireChange() {
        for (SocUpSimulationStateListener l : this.listeners) {
            l.simulationStateChanged();
        }
    }
}

