/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.file;

import com.cburch.logisim.soc.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;

public class ElfHeader {
    public static final int ELF_HEADER_CORRECT = 0;
    public static final int EI_MAG0 = 0;
    public static final byte EI_MAG0_VALUE = 127;
    public static final int EI_MAG1 = 1;
    public static final byte EI_MAG1_VALUE = 69;
    public static final int EI_MAG2 = 2;
    public static final byte EI_MAG2_VALUE = 76;
    public static final int EI_MAG3 = 3;
    public static final byte EI_MAG3_VALUE = 70;
    public static final int EI_CLASS = 4;
    public static final byte EI_CLASS_32 = 1;
    public static final byte EI_CLASS_64 = 2;
    public static final int EI_DATA = 5;
    public static final byte EI_DATA_LITTLE_ENDIAN = 1;
    public static final byte EI_DATA_BIG_ENDIAN = 2;
    public static final int EI_VERSION = 6;
    public static final int EI_OSABI = 7;
    public static final int EI_ABIVERSION = 8;
    public static final int EI_PAD = 9;
    public static final int E_IDENT_SIZE = 16;
    private static final int EI_ERROR_READING_FILE = 1;
    private static final int EI_SIZE_ERROR = 2;
    private static final int EI_MAGIC_ERROR = 4;
    private static final int EI_CLASS_ERROR = 8;
    private static final int EI_DATA_ERROR = 16;
    public static final int ELF_HEADER_SIZE_32 = 52;
    public static final int ELF_HEADER_SIZE_64 = 64;
    public static final int E_TYPE = 17;
    public static final int E_MACHINE = 18;
    public static final int E_VERSION = 19;
    public static final int E_ENTRY = 20;
    public static final int E_PHOFF = 21;
    public static final int E_SHOFF = 22;
    public static final int E_FLAGS = 23;
    public static final int E_EHSIZE = 24;
    public static final int E_PHENTSIZE = 25;
    public static final int E_PHNUM = 26;
    public static final int E_SHENTSIZE = 27;
    public static final int E_SHNUM = 28;
    public static final int E_SHSTRNDX = 29;
    private static final int E_SIZE_ERROR = 32;
    public static final int ET_NONE = 0;
    public static final int ET_REL = 1;
    public static final int ET_EXEC = 2;
    public static final int ET_DYN = 3;
    public static final int ET_CORE = 4;
    public static final int ET_LOOS = 65024;
    public static final int ET_HIOS = 65279;
    public static final int ET_LOPROC = 65280;
    public static final int ET_HIPROC = 65535;
    public static final int EM_OPENRISC = 92;
    public static final int EM_INTEL_NIOS2 = 113;
    public static final int EM_RISCV = 243;
    private static final Map<Integer, String> ARCHITECTURES = Map.of(92, "Open Risc", 113, "Nios II", 243, "Risc V");
    public static final long LONGMASK = Long.parseUnsignedLong("00FFFFFFFFFFFFFF", 16);
    public static final long LONGINTMASK = Long.parseUnsignedLong("00000000FFFFFFFF", 16);
    public static final int INTMASK = Integer.parseUnsignedInt("00FFFFFF", 16);
    private int status = 0;
    private EInfo eInfo;
    private final byte[] e_ident = new byte[16];

    public ElfHeader(FileInputStream file) {
        int nrRead = -1;
        try {
            nrRead = file.read(this.e_ident);
        }
        catch (IOException e) {
            this.status |= 1;
            return;
        }
        if (nrRead != 16) {
            this.status |= 2;
            return;
        }
        if (!this.isElfFile()) {
            this.status |= 4;
            return;
        }
        if (!this.isCorrectClass()) {
            this.status |= 8;
            return;
        }
        if (!this.isCorrectEncoding()) {
            this.status |= 0x10;
            return;
        }
        int hsize = this.is32Bit() ? 52 : 64;
        byte[] buffer = new byte[hsize -= 16];
        try {
            nrRead = file.read(buffer);
        }
        catch (IOException e) {
            this.status |= 1;
            return;
        }
        if (nrRead != hsize) {
            this.status |= 0x20;
            return;
        }
        this.eInfo = new EInfo(buffer, this.is32Bit(), this.isLittleEndian());
    }

    public Object getValue(int field) {
        if (!this.isValid()) {
            return null;
        }
        if (field >= 17 && field <= 29) {
            return this.eInfo.getValue(field);
        }
        if (field < 9) {
            return this.e_ident[field];
        }
        if (field == 9) {
            Byte[] pad = new Byte[7];
            for (int i = 0; i < 7; ++i) {
                pad[i] = this.e_ident[9 + i];
            }
            return pad;
        }
        return null;
    }

    public boolean isValid() {
        return this.status == 0;
    }

    public boolean is32Bit() {
        return this.e_ident[4] == 1;
    }

    public boolean isLittleEndian() {
        return this.e_ident[5] == 1;
    }

    public boolean isElfFile() {
        return this.e_ident[0] == 127 && this.e_ident[1] == 69 && this.e_ident[2] == 76 && this.e_ident[3] == 70;
    }

    public int getElfHeaderSize() {
        return ElfHeader.getIntValue(this.eInfo.getValue(24));
    }

    public String getArchitectureString(int arch) {
        if (ARCHITECTURES.containsKey(arch)) {
            return ARCHITECTURES.get(arch);
        }
        return Strings.S.get("ElfHeaderUnknownArchitecture");
    }

    public String getErrorString() {
        if (this.status == 0) {
            return Strings.S.get("ElfHeaderNoErrors");
        }
        StringBuilder s = new StringBuilder();
        boolean insertNl = false;
        if (this.status == 1) {
            s.append(insertNl ? "\n" : "").append(Strings.S.get("ElfHeaderReadingFileError"));
            insertNl = true;
        }
        if (this.status == 2) {
            s.append(insertNl ? "\n" : "").append(Strings.S.get("ElfHeaderIncorrectEISize"));
            insertNl = true;
        }
        if (this.status == 4) {
            s.append(insertNl ? "\n" : "").append(Strings.S.get("ElfHeaderIncorrectMagic"));
            insertNl = true;
        }
        if (this.status == 8) {
            s.append(insertNl ? "\n" : "").append(Strings.S.get("ElfHeaderEIClassError"));
            insertNl = true;
        }
        if (this.status == 16) {
            s.append(insertNl ? "\n" : "").append(Strings.S.get("ElfHeaderEIDataError"));
            insertNl = true;
        }
        if (this.status == 32) {
            s.append(insertNl ? "\n" : "").append(Strings.S.get("ElfHeaderIncorrectESize"));
            insertNl = true;
        }
        return s.toString();
    }

    public long getSize() {
        return ElfHeader.getLongValue(this.getValue(21));
    }

    public static long getLongValue(byte[] buffer, int startIndex, int NrOfBytes, boolean isLittleEndian) {
        long result = 0L;
        for (int i = 0; i < NrOfBytes; ++i) {
            long value;
            int index = startIndex + i;
            long l = value = index < buffer.length ? (long)buffer[index] & 0xFFL : 0L;
            if (isLittleEndian) {
                result >>= 8;
                result &= LONGMASK;
                result |= value << (NrOfBytes - 1) * 8;
                continue;
            }
            result <<= 8;
            result |= value;
        }
        return result;
    }

    public static int getIntValue(byte[] buffer, int startIndex, int NrOfBytes, boolean isLittleEndian) {
        int result = 0;
        for (int i = 0; i < NrOfBytes; ++i) {
            int value;
            int index = startIndex + i;
            int n = value = index < buffer.length ? buffer[startIndex + i] & 0xFF : 0;
            if (isLittleEndian) {
                result >>= 8;
                result &= INTMASK;
                result |= value << (NrOfBytes - 1) * 8;
                continue;
            }
            result <<= 8;
            result |= value;
        }
        return result;
    }

    public static Object returnCorrectValue(Long value, boolean is32Bit) {
        Integer intVal = Integer.parseUnsignedInt(String.format("%08X", value & LONGINTMASK), 16);
        if (is32Bit) {
            return intVal;
        }
        return value;
    }

    public static int getIntValue(Object v) {
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Long) {
            return Integer.parseUnsignedInt(String.format("%08X", (Long)v & LONGINTMASK), 16);
        }
        return 0;
    }

    public static long getLongValue(Object v) {
        if (v instanceof Integer) {
            return Long.parseUnsignedLong(String.format("%08X", v), 16);
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return 0L;
    }

    private boolean isCorrectClass() {
        return this.e_ident[4] == 1 || this.e_ident[4] == 2;
    }

    private boolean isCorrectEncoding() {
        return this.e_ident[5] == 1 || this.e_ident[5] == 2;
    }

    private static class EInfo {
        private final Integer e_type;
        private final Integer e_machine;
        private final Integer e_version;
        private final Long e_entry;
        private final Long e_phoff;
        private final Long e_shoff;
        private final Integer e_flags;
        private final Integer e_ehsize;
        private final Integer e_phentsize;
        private final Integer e_phnum;
        private final Integer e_shentsize;
        private final Integer e_shnum;
        private final Integer e_shstrndx;
        private final boolean is32Bit;

        public EInfo(byte[] buffer, boolean is32Bit, boolean isLittleEndian) {
            this.is32Bit = is32Bit;
            int index = 0;
            int fieldSize = is32Bit ? 4 : 8;
            this.e_type = ElfHeader.getIntValue(buffer, index, 2, isLittleEndian);
            this.e_machine = ElfHeader.getIntValue(buffer, index += 2, 2, isLittleEndian);
            this.e_version = ElfHeader.getIntValue(buffer, index += 2, 4, isLittleEndian);
            this.e_entry = ElfHeader.getLongValue(buffer, index += 4, fieldSize, isLittleEndian);
            this.e_phoff = ElfHeader.getLongValue(buffer, index += fieldSize, fieldSize, isLittleEndian);
            this.e_shoff = ElfHeader.getLongValue(buffer, index += fieldSize, fieldSize, isLittleEndian);
            this.e_flags = ElfHeader.getIntValue(buffer, index += fieldSize, 4, isLittleEndian);
            this.e_ehsize = ElfHeader.getIntValue(buffer, index += 4, 2, isLittleEndian);
            this.e_phentsize = ElfHeader.getIntValue(buffer, index += 2, 2, isLittleEndian);
            this.e_phnum = ElfHeader.getIntValue(buffer, index += 2, 2, isLittleEndian);
            this.e_shentsize = ElfHeader.getIntValue(buffer, index += 2, 2, isLittleEndian);
            this.e_shnum = ElfHeader.getIntValue(buffer, index += 2, 2, isLittleEndian);
            this.e_shstrndx = ElfHeader.getIntValue(buffer, index += 2, 2, isLittleEndian);
        }

        public Object getValue(int identifier) {
            return switch (identifier) {
                case 17 -> this.e_type;
                case 18 -> this.e_machine;
                case 19 -> this.e_version;
                case 20 -> ElfHeader.returnCorrectValue(this.e_entry, this.is32Bit);
                case 21 -> ElfHeader.returnCorrectValue(this.e_phoff, this.is32Bit);
                case 22 -> ElfHeader.returnCorrectValue(this.e_shoff, this.is32Bit);
                case 23 -> this.e_flags;
                case 24 -> this.e_ehsize;
                case 25 -> this.e_phentsize;
                case 26 -> this.e_phnum;
                case 27 -> this.e_shentsize;
                case 28 -> this.e_shnum;
                case 29 -> this.e_shstrndx;
                default -> null;
            };
        }
    }
}

