/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.gui;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusStateInfo;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BusTransactionInsertionGui
extends JFrame
implements BaseWindowListenerContract,
ActionListener,
LocaleListener {
    private static final long serialVersionUID = 1L;
    private final SocBusStateInfo myBus;
    private final String myBusId;
    private final JLabel address = new JLabel();
    private final JTextField addrValue = new JTextField(8);
    private final JLabel inputdata = new JLabel();
    private final JTextField inputDataValue = new JTextField(8);
    private final JCheckBox readAction = new JCheckBox();
    private final JCheckBox writeAction = new JCheckBox();
    private final JCheckBox atomicAction = new JCheckBox();
    private final JButton insertButton = new JButton();
    private final JLabel resultLabel = new JLabel();
    private final JTextArea result = new JTextArea(2, 1);
    private final JCheckBox wordTrans = new JCheckBox();
    private final JCheckBox halfTrans = new JCheckBox();
    private final JCheckBox byteTrans = new JCheckBox();
    private final CircuitState circuitState;

    public BusTransactionInsertionGui(SocBusStateInfo bus, String busId, CircuitState state) {
        this.myBus = bus;
        this.myBusId = busId;
        LocaleManager.addLocaleListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 1;
        this.address.setHorizontalAlignment(4);
        this.add((Component)this.address, c);
        ++c.gridy;
        this.inputdata.setHorizontalAlignment(4);
        this.add((Component)this.inputdata, c);
        ++c.gridx;
        this.inputDataValue.setText("00000000");
        this.add((Component)this.inputDataValue, c);
        --c.gridy;
        this.addrValue.setText("00000000");
        this.add((Component)this.addrValue, c);
        c.gridx = 0;
        c.gridy = 2;
        JPanel pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.add((Component)this.readAction, "North");
        this.readAction.addActionListener(this);
        pan.add((Component)this.writeAction, "Center");
        this.writeAction.addActionListener(this);
        pan.add((Component)this.atomicAction, "South");
        this.atomicAction.addActionListener(this);
        this.add((Component)pan, c);
        ++c.gridx;
        pan = new JPanel();
        pan.setLayout(new BorderLayout());
        pan.add((Component)this.wordTrans, "North");
        this.wordTrans.setSelected(true);
        this.wordTrans.addActionListener(this);
        pan.add((Component)this.halfTrans, "Center");
        this.halfTrans.addActionListener(this);
        pan.add((Component)this.byteTrans, "South");
        this.byteTrans.addActionListener(this);
        this.add((Component)pan, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.insertButton.setEnabled(false);
        this.insertButton.addActionListener(this);
        this.add((Component)this.insertButton, c);
        ++c.gridy;
        this.resultLabel.setHorizontalAlignment(0);
        this.add((Component)this.resultLabel, c);
        ++c.gridy;
        this.add((Component)this.result, c);
        this.localeChanged();
        this.circuitState = state;
        this.pack();
    }

    private void insertAction() {
        int data;
        int addr;
        try {
            addr = Integer.parseUnsignedInt(this.addrValue.getText(), 16);
        }
        catch (NumberFormatException e) {
            addr = 0;
        }
        this.addrValue.setText(String.format("%08X", addr));
        try {
            data = Integer.parseUnsignedInt(this.inputDataValue.getText(), 16);
        }
        catch (NumberFormatException e) {
            data = 0;
        }
        int action = 3;
        String format = "%08X";
        if (this.halfTrans.isSelected()) {
            action = 2;
            format = "%04X";
            data &= 0xFFFF;
        }
        if (this.byteTrans.isSelected()) {
            action = 1;
            format = "%02X";
            data &= 0xFF;
        }
        this.inputDataValue.setText(String.format(format, data));
        int type = 0;
        if (this.readAction.isSelected()) {
            type |= 1;
        }
        if (this.writeAction.isSelected()) {
            type |= 2;
        }
        if (this.atomicAction.isSelected()) {
            type |= 4;
        }
        SocBusTransaction trans = new SocBusTransaction(type, addr, data, action, Strings.S.get("SocTransInsManual"));
        this.myBus.getSocSimulationManager().initializeTransaction(trans, this.myBusId, this.circuitState);
        String line1 = trans.getShortErrorMessage() + "\n";
        String line2 = trans.isReadTransaction() && !trans.hasError() ? Strings.S.get("SocTransInsReadData") + String.format("0x%08X", trans.getReadData()) : " ";
        this.result.setText(line1 + line2);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.readAction || source == this.writeAction) {
            this.insertButton.setEnabled(this.readAction.isSelected() || this.writeAction.isSelected());
        } else if (source == this.insertButton) {
            this.insertAction();
        } else if (source == this.wordTrans) {
            if (this.wordTrans.isSelected()) {
                this.halfTrans.setSelected(false);
                this.byteTrans.setSelected(false);
            } else if (!this.halfTrans.isSelected() && !this.byteTrans.isSelected()) {
                this.wordTrans.setSelected(true);
            }
        } else if (source == this.halfTrans) {
            if (this.halfTrans.isSelected()) {
                this.wordTrans.setSelected(false);
                this.byteTrans.setSelected(false);
            } else if (!this.wordTrans.isSelected() && !this.byteTrans.isSelected()) {
                this.halfTrans.setSelected(true);
            }
        } else if (source == this.byteTrans) {
            if (this.byteTrans.isSelected()) {
                this.wordTrans.setSelected(false);
                this.halfTrans.setSelected(false);
            } else if (!this.wordTrans.isSelected() && !this.halfTrans.isSelected()) {
                this.byteTrans.setSelected(true);
            }
        }
    }

    @Override
    public void localeChanged() {
        this.address.setText(Strings.S.get("SocTransInsAddress"));
        this.inputdata.setText(Strings.S.get("SocTransInsInputData"));
        this.readAction.setText(Strings.S.get("SocTransInsReadRequest"));
        this.writeAction.setText(Strings.S.get("SocTransInsWriteRequest"));
        this.atomicAction.setText(Strings.S.get("SocTransInsAtomicRequest"));
        this.insertButton.setText(Strings.S.get("SocTransInsInsertTransaction"));
        this.resultLabel.setText(Strings.S.get("SocTransInsTransResultTitle"));
        this.wordTrans.setText(Strings.S.get("SocTransInsWordAccess"));
        this.halfTrans.setText(Strings.S.get("SocTransInsHalfWordAccess"));
        this.byteTrans.setText(Strings.S.get("SocTransInsByteAccess"));
        this.pack();
    }
}

