/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.jtaguart;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSnifferInterface;
import com.cburch.logisim.soc.data.SocInstanceFactory;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.jtaguart.JtagUartAttributes;
import com.cburch.logisim.soc.jtaguart.JtagUartState;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Font;
import java.awt.Graphics2D;

public class JtagUart
extends SocInstanceFactory {
    public static final String _ID = "SocJtagUart";
    public static final int CLOCK_PIN = 0;
    public static final int RESET_PIN = 1;
    public static final int IRQ_PIN = 2;
    public static final int READ_ENABLE_PIN = 3;
    public static final int CLEAR_KEYBOARD_PIN = 4;
    public static final int AVAILABLE_PIN = 5;
    public static final int DATA_IN_PIN = 6;
    public static final int DATA_OUT_PIN = 7;
    public static final int WRITE_PIN = 8;
    public static final int CLEAR_TTY_PIN = 9;

    public JtagUart() {
        super(_ID, Strings.S.getter("SocJtagUartComponent"), 2);
        this.setIcon(new ArithmeticIcon("JtagUart", 4));
        this.setOffsetBounds(Bounds.create(0, 0, 300, 60));
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new JtagUartAttributes();
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        Bounds bds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() + 2, bds.getY() + bds.getHeight() / 2, -1, 0);
        Port[] ps = new Port[10];
        ps[0] = new Port(0, 50, "input", 1);
        ps[0].setToolTip(Strings.S.getter("Rv32imClockInput"));
        ps[1] = new Port(0, 30, "input", 1);
        ps[1].setToolTip(Strings.S.getter("Rv32imResetInput"));
        ps[2] = new Port(300, 50, "output", 1);
        ps[2].setToolTip(Strings.S.getter("SocPioIrqOutput"));
        ps[3] = new Port(10, 0, "output", 1);
        ps[3].setToolTip(Strings.S.getter("JtagUartKeybReadEnable"));
        ps[4] = new Port(20, 0, "output", 1);
        ps[4].setToolTip(Strings.S.getter("JtagUartClearKeyb"));
        ps[5] = new Port(130, 0, "input", 1);
        ps[5].setToolTip(Strings.S.getter("JtagUartKeybAvailable"));
        ps[6] = new Port(140, 0, "input", 7);
        ps[6].setToolTip(Strings.S.getter("JtagUartKeybData"));
        ps[7] = new Port(160, 0, "output", 7);
        ps[7].setToolTip(Strings.S.getter("JtagUartTtyData"));
        ps[8] = new Port(180, 0, "output", 1);
        ps[8].setToolTip(Strings.S.getter("JtagUartTtyWrite"));
        ps[9] = new Port(190, 0, "output", 1);
        ps[9].setToolTip(Strings.S.getter("JtagUartTtyClear"));
        instance.setPorts(ps);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            instance.fireInvalidated();
        } else {
            super.instanceAttributeChanged(instance, attr);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics2D g2 = (Graphics2D)painter.getGraphics();
        Location loc = painter.getLocation();
        painter.drawBounds();
        painter.drawLabel();
        g2.drawLine(loc.getX(), loc.getY() + 20, loc.getX() + 200, loc.getY() + 20);
        g2.drawLine(loc.getX() + 150, loc.getY(), loc.getX() + 150, loc.getY() + 20);
        g2.drawLine(loc.getX() + 200, loc.getY(), loc.getX() + 200, loc.getY() + 20);
        painter.drawPort(1, "Reset", Direction.EAST);
        painter.drawClock(0, Direction.EAST);
        painter.drawPort(2, "IRQ", Direction.WEST);
        for (int i = 3; i < 10; ++i) {
            painter.drawPort(i);
        }
        GraphicsUtil.drawCenteredText(g2, "Keyboard", loc.getX() + 75, loc.getY() + 10);
        GraphicsUtil.drawCenteredText(g2, "TTY", loc.getX() + 175, loc.getY() + 10);
        Font f = g2.getFont();
        g2.setFont(StdAttr.DEFAULT_LABEL_FONT);
        GraphicsUtil.drawCenteredText(g2, "Jtag Uart", loc.getX() + 250, loc.getY() + 10);
        g2.setFont(f);
        if (painter.isPrintView()) {
            return;
        }
        painter.getAttributeValue(SocSimulationManager.SOC_BUS_SELECT).paint(g2, Bounds.create(loc.getX() + 40, loc.getY() + 41, 220, 18));
    }

    @Override
    public void propagate(InstanceState state) {
        JtagUartState myState = state.getAttributeValue(JtagUartAttributes.JTAG_STATE);
        myState.handleOperations(state);
    }

    @Override
    public SocBusSlaveInterface getSlaveInterface(AttributeSet attrs) {
        return attrs.getValue(JtagUartAttributes.JTAG_STATE);
    }

    @Override
    public SocBusSnifferInterface getSnifferInterface(AttributeSet attrs) {
        return null;
    }

    @Override
    public SocProcessorInterface getProcessorInterface(AttributeSet attrs) {
        return null;
    }
}

