/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.memory;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSlaveListener;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;

public class SocMemoryState
implements SocBusSlaveInterface {
    private int startAddress = 0;
    private int sizeInBytes = 1024;
    private final Random rand = new Random();
    private final SocBusInfo attachedBus = new SocBusInfo("");
    private String label = "";
    private final ArrayList<SocBusSlaveListener> listeners = new ArrayList();

    @Override
    public Integer getStartAddress() {
        return this.startAddress;
    }

    @Override
    public Integer getMemorySize() {
        return this.sizeInBytes;
    }

    public boolean setStartAddress(int address) {
        int addr = address >> 2 << 2;
        if (addr == this.startAddress) {
            return false;
        }
        this.startAddress = addr;
        this.firememMapChanged();
        return true;
    }

    public boolean setSize(BitWidth i) {
        int size = (int)Math.pow(2.0, i.getWidth());
        if (this.sizeInBytes == size) {
            return false;
        }
        this.sizeInBytes = size;
        this.firememMapChanged();
        return true;
    }

    public SocBusInfo getSocBusInfo() {
        return this.attachedBus;
    }

    public boolean setSocBusInfo(SocBusInfo i) {
        if (this.attachedBus.getBusId().equals(i.getBusId())) {
            return false;
        }
        this.attachedBus.setBusId(i.getBusId());
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean setLabel(String l) {
        if (this.label.equals(l)) {
            return false;
        }
        this.label = l;
        this.fireNameChanged();
        return true;
    }

    @Override
    public String getName() {
        if (this.attachedBus == null || this.attachedBus.getComponent() == null) {
            return "BUG: Unknown";
        }
        String name = this.label;
        if (StringUtil.isNullOrEmpty(name)) {
            Location loc = this.attachedBus.getComponent().getLocation();
            name = String.format("%s@%d,%d", this.attachedBus.getComponent().getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    @Override
    public InstanceComponent getComponent() {
        if (this.attachedBus == null || this.attachedBus.getComponent() == null) {
            return null;
        }
        return (InstanceComponent)this.attachedBus.getComponent();
    }

    @Override
    public void registerListener(SocBusSlaveListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeListener(SocBusSlaveListener l) {
        this.listeners.remove(l);
    }

    public SocMemoryInfo getNewState() {
        return new SocMemoryInfo();
    }

    @Override
    public boolean canHandleTransaction(SocBusTransaction trans) {
        long addr = SocSupport.convUnsignedInt(trans.getAddress());
        long start = SocSupport.convUnsignedInt(this.startAddress);
        long end = start + (long)this.sizeInBytes;
        return addr >= start && addr < end;
    }

    @Override
    public void handleTransaction(SocBusTransaction trans) {
        if (!this.canHandleTransaction(trans)) {
            return;
        }
        if (trans.isReadTransaction()) {
            trans.setReadData(this.performReadAction(trans.getAddress(), trans.getAccessType()));
        }
        if (trans.isWriteTransaction()) {
            this.performWriteAction(trans.getAddress(), trans.getWriteData(), trans.getAccessType());
        }
        trans.setTransactionResponder(this.attachedBus.getComponent());
    }

    private SocMemoryInfo getRegPropagateState() {
        return (SocMemoryInfo)this.attachedBus.getSocSimulationManager().getdata(this.attachedBus.getComponent());
    }

    private int performReadAction(int address, int type) {
        SocMemoryInfo data = this.getRegPropagateState();
        int value = data == null ? this.rand.nextInt() : data.getWord(address >> 2 << 2);
        int adbit1 = address >> 1 & 1;
        switch (type) {
            case 3: {
                return value;
            }
            case 2: {
                if (adbit1 == 1) {
                    return value >> 16 & 0xFFFF;
                }
                return value & 0xFFFF;
            }
        }
        int adbit1_0 = address & 3;
        return switch (adbit1_0) {
            case 0 -> value & 0xFF;
            case 1 -> value >> 8 & 0xFF;
            case 2 -> value >> 16 & 0xFF;
            default -> value >> 24 & 0xFF;
        };
    }

    private void performWriteAction(int address, int data, int type) {
        int wData = data;
        if (type != 3) {
            int oldData = this.performReadAction(address, 3);
            if (type == 2) {
                int bit1 = address >> 1 & 1;
                int mdata = data & 0xFFFF;
                if (bit1 == 1) {
                    oldData &= 0xFFFF;
                    mdata <<= 16;
                } else {
                    oldData = (oldData >> 16 & 0xFFFF) << 16;
                }
                wData = oldData | mdata;
            } else {
                int byte0 = oldData & 0xFF;
                int byte1 = (oldData >> 8 & 0xFF) << 8;
                int byte2 = (oldData >> 16 & 0xFF) << 16;
                int byte3 = (oldData >> 24 & 0xFF) << 24;
                int mdata = data & 0xFF;
                int bit10 = address & 3;
                wData = switch (bit10) {
                    case 0 -> byte3 | byte2 | byte1 | mdata;
                    case 1 -> byte3 | byte2 | byte0 | mdata << 8;
                    case 2 -> byte3 | byte1 | byte0 | mdata << 16;
                    default -> byte2 | byte1 | byte0 | mdata << 24;
                };
            }
        }
        this.getRegPropagateState().writeWord(address, wData);
    }

    private void fireNameChanged() {
        for (SocBusSlaveListener listener : this.listeners) {
            listener.labelChanged();
        }
    }

    private void firememMapChanged() {
        for (SocBusSlaveListener listener : this.listeners) {
            listener.memoryMapChanged();
        }
    }

    public class SocMemoryInfo
    implements InstanceData,
    Cloneable {
        private final ArrayList<SocMemoryInfoBlock> memInfo = new ArrayList();

        @Override
        public SocMemoryInfo clone() {
            try {
                return (SocMemoryInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public int getWord(int address) {
            for (SocMemoryInfoBlock info : this.memInfo) {
                if (!info.contains(address)) continue;
                return info.getValue(address);
            }
            return SocMemoryState.this.rand.nextInt();
        }

        public void writeWord(int address, int wdata) {
            SocMemoryInfoBlock addAfter;
            SocMemoryInfoBlock addBefore;
            ArrayList<SocMemoryInfoBlock> adders = new ArrayList<SocMemoryInfoBlock>();
            for (SocMemoryInfoBlock info : this.memInfo) {
                if (info.contains(address)) {
                    info.addInfo(address, wdata);
                    return;
                }
                if (!info.canAdd(address)) continue;
                adders.add(info);
            }
            if (adders.isEmpty()) {
                this.memInfo.add(new SocMemoryInfoBlock(address, wdata));
                return;
            }
            if (adders.size() == 1) {
                ((SocMemoryInfoBlock)adders.get(0)).addInfo(address, wdata);
                return;
            }
            if (adders.size() > 2) {
                System.out.println("BUG! Memory management does not function corectly for the SocMemory component!");
                return;
            }
            SocMemoryInfoBlock socMemoryInfoBlock = ((SocMemoryInfoBlock)adders.get(0)).canAddBefore(address) ? (SocMemoryInfoBlock)adders.get(0) : (addBefore = ((SocMemoryInfoBlock)adders.get(1)).canAddBefore(address) ? (SocMemoryInfoBlock)adders.get(1) : null);
            SocMemoryInfoBlock socMemoryInfoBlock2 = ((SocMemoryInfoBlock)adders.get(0)).canAddAfter(address) ? (SocMemoryInfoBlock)adders.get(0) : (addAfter = ((SocMemoryInfoBlock)adders.get(1)).canAddAfter(address) ? (SocMemoryInfoBlock)adders.get(1) : null);
            if (addBefore == null || addAfter == null) {
                System.out.println("BUG! Memory management does not function corectly for the SocMemory component!");
                return;
            }
            addAfter.addInfo(address, wdata);
            for (int i = addBefore.getStartAddress(); i < addBefore.getEndAddress(); i += 4) {
                addAfter.addInfo(i, addBefore.getValue(i));
            }
            this.memInfo.remove(addBefore);
        }

        private class SocMemoryInfoBlock {
            private final LinkedList<Integer> contents = new LinkedList();
            private int startAddress;
            private final Random rand = new Random();

            public SocMemoryInfoBlock(int address, int data) {
                this.startAddress = address >> 2 << 2;
                this.contents.add(data);
            }

            public boolean canAddBefore(int address) {
                int previousAddress = this.getStartAddress() - 4;
                return address >= previousAddress && address < this.getStartAddress();
            }

            public boolean canAddAfter(int address) {
                return address >= this.getEndAddress() && address < this.getEndAddress() + 4;
            }

            public boolean contains(int address) {
                return address >= this.getStartAddress() && address < this.getEndAddress();
            }

            public boolean canAdd(int address) {
                return this.canAddBefore(address) || this.canAddAfter(address);
            }

            public boolean addInfo(int address, int data) {
                if (this.canAddBefore(address)) {
                    this.contents.addFirst(data);
                    this.startAddress -= 4;
                    return true;
                }
                if (this.canAddAfter(address)) {
                    this.contents.add(data);
                    return true;
                }
                if (this.contains(address)) {
                    int index = address - this.startAddress >> 2;
                    this.contents.set(index, data);
                    return true;
                }
                return false;
            }

            public int getValue(int address) {
                int index = address - this.startAddress >> 2;
                if (index >= this.contents.size()) {
                    return this.rand.nextInt();
                }
                return this.contents.get(index);
            }

            public int getStartAddress() {
                return this.startAddress;
            }

            public int getEndAddress() {
                return this.startAddress + this.contents.size() * 4;
            }
        }
    }
}

