/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2CustomInstructions
implements AssemblerExecutionInterface {
    private static final int CUSTOM = 50;
    private int instruction;
    private boolean valid = false;
    private int regA;
    private int regB;
    private int regC;
    private boolean readra;
    private boolean readrb;
    private boolean writerc;
    private int n;
    private boolean custActive = false;

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState state = (Nios2State.ProcessorState)processorState;
        int regAValue = state.getRegisterValue(this.regA);
        int regBValue = state.getRegisterValue(this.regB);
        Instance inst = state.getInstance();
        InstanceState istate = circuitState.getInstanceState(inst.getComponent());
        istate.setPort(2, Value.createKnown(32, (long)regAValue), 5);
        istate.setPort(3, Value.createKnown(32, (long)regBValue), 5);
        istate.setPort(4, Value.createKnown(1, 1L), 5);
        istate.setPort(5, Value.createKnown(8, (long)this.n), 5);
        istate.setPort(6, Value.createKnown(5, (long)this.regA), 5);
        istate.setPort(7, Value.createKnown(1, this.readra ? 1L : 0L), 5);
        istate.setPort(8, Value.createKnown(5, (long)this.regB), 5);
        istate.setPort(9, Value.createKnown(1, this.readrb ? 1L : 0L), 5);
        istate.setPort(10, Value.createKnown(5, (long)this.regC), 5);
        istate.setPort(11, Value.createKnown(1, this.writerc ? 1L : 0L), 5);
        this.custActive = true;
        return true;
    }

    public boolean waitingOnReady(Object processorState, CircuitState circuitState) {
        if (!this.custActive || !this.valid) {
            return false;
        }
        Nios2State.ProcessorState state = (Nios2State.ProcessorState)processorState;
        Instance inst = state.getInstance();
        InstanceState istate = circuitState.getInstanceState(inst.getComponent());
        Value done = istate.getPortValue(13);
        istate.setPort(4, Value.createKnown(1, 0L), 0);
        if (!done.equals(Value.TRUE) && !done.equals(Value.FALSE)) {
            this.custActive = false;
            OptionPane.showMessageDialog(null, Strings.S.get("Nios2DonePinError"), "Nios2s", 0);
            state.getSimState().errorInExecution();
            return true;
        }
        if (done.equals(Value.TRUE)) {
            this.custActive = false;
            if (!this.writerc) {
                int result = 0;
                Value rValue = istate.getPortValue(12);
                if (rValue.isFullyDefined()) {
                    result = Integer.parseUnsignedInt(rValue.toHexString(), 16);
                }
                state.writeRegister(this.regC, result);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append("custom");
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(this.n).append(",");
        s.append(this.writerc ? "c" : "r").append(this.regC).append(",");
        s.append(this.readra ? "c" : "r").append(this.regA).append(",");
        s.append(this.readrb ? "c" : "r").append(this.regB);
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        if (!instr.getOpcode().equalsIgnoreCase("custom")) {
            this.valid = false;
            return false;
        }
        this.valid = true;
        if (instr.getNrOfParameters() != 4) {
            this.valid = false;
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedFourArguments"));
            return true;
        }
        AssemblerToken[] param1 = instr.getParameter(0);
        AssemblerToken[] param2 = instr.getParameter(1);
        AssemblerToken[] param3 = instr.getParameter(2);
        AssemblerToken[] param4 = instr.getParameter(3);
        if (param1.length != 1 || !param1[0].isNumber()) {
            this.valid = false;
            instr.setError(param1[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
            return true;
        }
        this.n = param1[0].getNumberValue();
        if (this.n < 0 || this.n > 255) {
            this.valid = false;
            instr.setError(param1[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
            return true;
        }
        if (param2.length != 1 || param2[0].getType() != 5 && param2[0].getType() != 256) {
            this.valid = false;
            instr.setError(param2[0], Strings.S.getter("AssemblerExpectedRegister"));
        }
        this.writerc = param2[0].getType() == 256;
        this.regC = Nios2State.getRegisterIndex(param2[0].getValue());
        if (this.regC < 0 || this.regC > 31) {
            this.valid = false;
            instr.setError(param2[0], Strings.S.getter("AssemblerUnknownRegister"));
        }
        if (param3.length != 1 || param3[0].getType() != 5 && param3[0].getType() != 256) {
            this.valid = false;
            instr.setError(param3[0], Strings.S.getter("AssemblerExpectedRegister"));
        }
        this.readra = param3[0].getType() == 256;
        this.regA = Nios2State.getRegisterIndex(param3[0].getValue());
        if (this.regA < 0 || this.regA > 31) {
            this.valid = false;
            instr.setError(param3[0], Strings.S.getter("AssemblerUnknownRegister"));
        }
        if (param4.length != 1 || param4[0].getType() != 5 && param4[0].getType() != 256) {
            this.valid = false;
            instr.setError(param4[0], Strings.S.getter("AssemblerExpectedRegister"));
        }
        this.readrb = param4[0].getType() == 256;
        this.regB = Nios2State.getRegisterIndex(param4[0].getValue());
        if (this.regB < 0 || this.regB > 31) {
            this.valid = false;
            instr.setError(param4[0], Strings.S.getter("AssemblerUnknownRegister"));
        }
        if (this.valid) {
            int opx = this.n & 0xFF;
            if (this.writerc) {
                opx |= 0x100;
            }
            if (this.readrb) {
                opx |= 0x200;
            }
            if (this.readra) {
                opx |= 0x400;
            }
            this.instruction = Nios2Support.getCustomInstructionCode(this.regA, this.regB, this.regC, opx, 50);
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = false;
        if (Nios2Support.getOpcode(instr) == 50) {
            this.valid = true;
            this.regA = Nios2Support.getRegAIndex(instr, 1);
            this.regB = Nios2Support.getRegBIndex(instr, 1);
            this.regC = Nios2Support.getRegCIndex(instr, 1);
            int opx = Nios2Support.getOPX(instr, 1);
            this.n = opx & 0xFF;
            this.writerc = (opx >> 8 & 1) != 0;
            this.readrb = (opx >> 9 & 1) != 0;
            this.readra = (opx >> 10 & 1) != 0;
        }
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        ArrayList<String> opcodes = new ArrayList<String>();
        opcodes.add("custom");
        return opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (instruction.equalsIgnoreCase("custom")) {
            return 4;
        }
        return -1;
    }
}

