/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.nios2.Nios2State;
import com.cburch.logisim.soc.nios2.Nios2Support;
import com.cburch.logisim.soc.util.AbstractExecutionUnitWithLabelSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;

public class Nios2ProgramControlInstructions
implements AbstractExecutionUnitWithLabelSupport {
    private static final int INSTR_CALLR = 0;
    private static final int INSTR_RET = 1;
    private static final int INSTR_JMP = 2;
    private static final int INSTR_CALL = 3;
    private static final int INSTR_JMPI = 4;
    private static final int INSTR_BR = 5;
    private static final int INSTR_BGE = 6;
    private static final int INSTR_BGEU = 7;
    private static final int INSTR_BLT = 8;
    private static final int INSTR_BLTU = 9;
    private static final int INSTR_BEQ = 10;
    private static final int INSTR_BNE = 11;
    private static final int INSTR_BGT = 12;
    private static final int INSTR_BGTU = 13;
    private static final int INSTR_BLE = 14;
    private static final int INSTR_BLEU = 15;
    private static final int SIGN_EXTEND = 256;
    private static final int PSEUDO_INSTR = 512;
    private static final String[] AsmOpcodes = new String[]{"CALLR", "RET", "JMP", "CALL", "JMPI", "BR", "BGE", "BGEU", "BLT", "BLTU", "BEQ", "BNE", "BGT", "BGTU", "BLE", "BLEU"};
    private static final Integer[] AsmOpcs = new Integer[]{58, 58, 58, 0, 1, 6, 14, 46, 22, 54, 38, 30, 512, 512, 512, 512};
    private static final Integer[] AsmOpxs = new Integer[]{29, 5, 13, -1, -1, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256};
    private final ArrayList<String> Opcodes = new ArrayList();
    private final ArrayList<Integer> OpcCodes = new ArrayList();
    private final ArrayList<Integer> OpxCodes = new ArrayList();
    private int instruction;
    private boolean valid;
    private boolean jumped;
    private int operation;
    private int immediate;
    private int sourceA;
    private int sourceB;

    public Nios2ProgramControlInstructions() {
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            this.Opcodes.add(AsmOpcodes[i].toLowerCase());
            this.OpcCodes.add(AsmOpcs[i]);
            this.OpxCodes.add(AsmOpxs[i]);
        }
    }

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        Nios2State.ProcessorState cpuState = (Nios2State.ProcessorState)processorState;
        this.jumped = false;
        int valueA = cpuState.getRegisterValue(this.sourceA);
        int valueB = cpuState.getRegisterValue(this.sourceB);
        long valueAu = SocSupport.convUnsignedInt(valueA);
        long valueBu = SocSupport.convUnsignedInt(valueB);
        long pc = SocSupport.convUnsignedInt(cpuState.getProgramCounter());
        long nextpc = pc + 4L;
        int imm = this.immediate << 16 >> 16;
        long target = nextpc + (long)imm;
        switch (this.operation) {
            case 0: {
                this.jumped = true;
                cpuState.writeRegister(31, SocSupport.convUnsignedLong(nextpc));
                cpuState.setProgramCounter(valueA);
                break;
            }
            case 1: {
                this.jumped = true;
                cpuState.setProgramCounter(cpuState.getRegisterValue(31));
                break;
            }
            case 2: {
                this.jumped = true;
                cpuState.setProgramCounter(valueA);
                break;
            }
            case 3: {
                cpuState.writeRegister(31, SocSupport.convUnsignedLong(nextpc));
            }
            case 4: {
                this.jumped = true;
                cpuState.setProgramCounter(this.immediate << 2);
                break;
            }
            case 5: {
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            case 6: {
                if (valueA < valueB) break;
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            case 7: {
                if (valueAu < valueBu) break;
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            case 8: {
                if (valueA >= valueB) break;
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            case 9: {
                if (valueAu >= valueBu) break;
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            case 10: {
                if (valueA != valueB) break;
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            case 11: {
                if (valueA == valueB) break;
                this.jumped = true;
                cpuState.setProgramCounter(SocSupport.convUnsignedLong(target));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        int imm = (this.immediate << 16 >> 16) + 4;
        switch (this.operation) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                s.append(Nios2State.registerABINames[this.sourceA]);
                break;
            }
            case 3: 
            case 4: {
                s.append(this.immediate << 2);
                break;
            }
            case 5: {
                s.append("pc").append(imm >= 0 ? "+" : "").append(imm);
                break;
            }
            default: {
                s.append(Nios2State.registerABINames[this.sourceA]).append(",");
                s.append(Nios2State.registerABINames[this.sourceB]).append(",");
                s.append("pc").append(imm >= 0 ? "+" : "").append(imm);
            }
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        this.valid = false;
        if (!this.Opcodes.contains(instr.getOpcode().toLowerCase())) {
            return false;
        }
        this.operation = this.Opcodes.indexOf(instr.getOpcode().toLowerCase());
        this.valid = true;
        long pc = instr.getProgramCounter();
        switch (this.operation) {
            case 0: 
            case 2: {
                if (instr.getNrOfParameters() != 1) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedOneArgument"));
                    return true;
                }
                this.valid &= Nios2Support.isCorrectRegister(instr, 0);
                this.sourceA = this.sourceB = Nios2Support.getRegisterIndex(instr, 0);
                this.immediate = 0;
                break;
            }
            case 1: {
                if (instr.getNrOfParameters() == 0) break;
                this.valid = false;
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedNoArguments"));
                return true;
            }
            case 3: 
            case 4: {
                if (instr.getNrOfParameters() != 1) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedOneArgument"));
                    return true;
                }
                AssemblerToken[] imm = instr.getParameter(0);
                if (imm.length != 1 || !imm[0].isNumber()) {
                    this.valid = false;
                    instr.setError(imm[0], Strings.S.getter("AssemblerExpextedImmediateOrLabel"));
                    break;
                }
                this.sourceB = 0;
                this.sourceA = 0;
                this.immediate = imm[0].getNumberValue() >> 2;
                if (this.immediate < 0x4000000 && this.immediate >= 0) break;
                this.valid = false;
                instr.setError(imm[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                break;
            }
            case 5: {
                if (instr.getNrOfParameters() != 1) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedOneArgument"));
                    return true;
                }
                AssemblerToken[] imm = instr.getParameter(0);
                if (imm.length != 1 || !imm[0].isNumber()) {
                    this.valid = false;
                    instr.setError(imm[0], Strings.S.getter("AssemblerExpextedImmediateOrLabel"));
                    break;
                }
                this.sourceB = 0;
                this.sourceA = 0;
                long target = SocSupport.convUnsignedInt(imm[0].getNumberValue());
                long imml = pc - target - 4L;
                if (imml >= 32768L || imml < -32768L) {
                    this.valid = false;
                    instr.setError(imm[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                }
                this.immediate = (int)imml;
                break;
            }
            default: {
                long imml;
                long target;
                if (instr.getNrOfParameters() != 3) {
                    this.valid = false;
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
                    return true;
                }
                this.valid &= Nios2Support.isCorrectRegister(instr, 0);
                this.valid &= Nios2Support.isCorrectRegister(instr, 1);
                this.sourceA = Nios2Support.getRegisterIndex(instr, 0);
                this.sourceB = Nios2Support.getRegisterIndex(instr, 1);
                AssemblerToken[] imm = instr.getParameter(2);
                if (imm.length != 1 || !imm[0].isNumber()) {
                    this.valid = false;
                    instr.setError(imm[0], Strings.S.getter("AssemblerExpextedImmediateOrLabel"));
                }
                if ((imml = pc - (target = SocSupport.convUnsignedInt(imm[0].getNumberValue())) - 4L) >= 32768L || imml < -32768L) {
                    this.valid = false;
                    instr.setError(imm[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                }
                this.immediate = (int)imml;
            }
        }
        boolean switchab = false;
        switch (this.operation) {
            case 12: {
                this.operation = 8;
                switchab = true;
                break;
            }
            case 13: {
                this.operation = 9;
                switchab = true;
                break;
            }
            case 14: {
                this.operation = 6;
                switchab = true;
                break;
            }
            case 15: {
                this.operation = 7;
                switchab = true;
            }
        }
        if (switchab) {
            int tmp = this.sourceA;
            this.sourceA = this.sourceB;
            this.sourceB = tmp;
        }
        if (this.valid) {
            switch (this.operation) {
                case 0: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(this.sourceA, 0, 31, 29);
                    break;
                }
                case 1: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(31, 0, 0, 5);
                    break;
                }
                case 2: {
                    this.instruction = Nios2Support.getRTypeInstructionCode(this.sourceA, 0, 0, 13);
                    break;
                }
                case 3: 
                case 4: {
                    this.instruction = Nios2Support.getJTypeInstructionCode(this.immediate, this.OpcCodes.get(this.operation));
                    break;
                }
                default: {
                    this.instruction = Nios2Support.getITypeInstructionCode(this.sourceA, this.sourceB, this.immediate, this.OpcCodes.get(this.operation));
                }
            }
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = false;
        int opcode = Nios2Support.getOpcode(instr);
        if (opcode == 58) {
            int opx = Nios2Support.getOPXCode(instr, 1);
            if (!this.OpxCodes.contains(opx) || Nios2Support.getOPXImm(instr, 1) != 0) {
                return false;
            }
            this.operation = this.OpxCodes.indexOf(opx);
            int ra = Nios2Support.getRegAIndex(instr, 1);
            int rb = Nios2Support.getRegBIndex(instr, 1);
            int rc = Nios2Support.getRegCIndex(instr, 1);
            switch (this.operation) {
                case 0: {
                    if (rc != 31 || rb != 0) {
                        return false;
                    }
                    this.sourceA = ra;
                    break;
                }
                case 1: {
                    if (ra == 31 && rb == 0 && rc == 0) break;
                    return false;
                }
                case 2: {
                    if (rb != 0 || rc != 0) {
                        return false;
                    }
                    this.sourceA = ra;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.valid = true;
        } else {
            if (!this.OpcCodes.contains(opcode)) {
                return false;
            }
            this.valid = true;
            this.operation = this.OpcCodes.indexOf(opcode);
            switch (this.operation) {
                case 3: 
                case 4: {
                    this.immediate = Nios2Support.getImmediate(instr, 2);
                    break;
                }
                case 5: {
                    this.immediate = Nios2Support.getImmediate(instr, 0);
                    if (Nios2Support.getRegAIndex(instr, 0) == 0 && Nios2Support.getRegBIndex(instr, 0) == 0) break;
                    this.valid = false;
                    break;
                }
                default: {
                    this.immediate = Nios2Support.getImmediate(instr, 0);
                    this.sourceA = Nios2Support.getRegAIndex(instr, 0);
                    this.sourceB = Nios2Support.getRegBIndex(instr, 0);
                }
            }
        }
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return this.valid && this.jumped;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return this.Opcodes;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.Opcodes.contains(instruction.toLowerCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean isLabelSupported() {
        return this.operation >= 3;
    }

    @Override
    public long getLabelAddress(long pc) {
        if (!this.isLabelSupported()) {
            return -1L;
        }
        switch (this.operation) {
            case 3: 
            case 4: {
                return SocSupport.convUnsignedInt(this.immediate << 2);
            }
        }
        int imm = this.immediate << 16 >> 16;
        return pc + 4L + (long)imm;
    }

    @Override
    public String getAsmInstruction(String label) {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(this.Opcodes.get(this.operation));
        while (s.length() < 10) {
            s.append(" ");
        }
        switch (this.operation) {
            case 1: {
                break;
            }
            case 0: 
            case 2: {
                s.append(Nios2State.registerABINames[this.sourceA]);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                s.append(label);
                break;
            }
            default: {
                s.append(Nios2State.registerABINames[this.sourceA]).append(",");
                s.append(Nios2State.registerABINames[this.sourceB]).append(",");
                s.append(label);
            }
        }
        return s.toString();
    }
}

