/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.rv32im.RV32imState;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AbstractExecutionUnitWithLabelSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32imControlTransferInstructions
implements AbstractExecutionUnitWithLabelSupport {
    private static final int JAL = 111;
    private static final int JALR = 103;
    private static final int BRANCH = 99;
    private static final int INSTR_BEQ = 0;
    private static final int INSTR_BNE = 1;
    private static final int INSTR_JAL = 2;
    private static final int INSTR_JALR = 3;
    private static final int INSTR_BLT = 4;
    private static final int INSTR_BGE = 5;
    private static final int INSTR_BLTU = 6;
    private static final int INSTR_BGEU = 7;
    private static final int INSTR_J = 8;
    private static final int INSTR_JR = 9;
    private static final int INSTR_RET = 10;
    private static final int INSTR_BNEZ = 11;
    private static final int INSTR_BEQZ = 12;
    private static final String[] AsmOpcodes = new String[]{"BEQ", "BNE", "JAL", "JALR", "BLT", "BGE", "BLTU", "BGEU", "J", "JR", "RET", "BNEZ", "BEQZ"};
    private boolean valid = false;
    private boolean jumped = false;
    private int instruction = 0;
    private int destination;
    private int operation;
    private int immediate;
    private int source1;
    private int source2;
    public boolean isPcRelative;

    @Override
    public ArrayList<String> getInstructions() {
        ArrayList<String> opcodes = new ArrayList<String>(Arrays.asList(AsmOpcodes));
        return opcodes;
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        RV32imState.ProcessorState cpuState = (RV32imState.ProcessorState)state;
        this.jumped = false;
        int target = cpuState.getProgramCounter() + this.immediate;
        int nextPc = cpuState.getProgramCounter() + 4;
        int reg1 = cpuState.getRegisterValue(this.source1);
        int reg2 = cpuState.getRegisterValue(this.source2);
        switch (this.operation) {
            case 2: 
            case 8: {
                cpuState.setProgramCounter(target);
                this.jumped = true;
                cpuState.writeRegister(this.destination, nextPc);
                return true;
            }
            case 3: 
            case 9: 
            case 10: {
                target = cpuState.getRegisterValue(this.source1) + this.immediate;
                target = target >> 1 << 1;
                cpuState.setProgramCounter(target);
                this.jumped = true;
                cpuState.writeRegister(this.destination, nextPc);
                return true;
            }
            case 0: 
            case 12: {
                if (reg1 == reg2) {
                    this.jumped = true;
                    cpuState.setProgramCounter(target);
                }
                return true;
            }
            case 1: 
            case 11: {
                if (reg1 != reg2) {
                    this.jumped = true;
                    cpuState.setProgramCounter(target);
                }
                return true;
            }
            case 4: {
                if (reg1 < reg2) {
                    this.jumped = true;
                    cpuState.setProgramCounter(target);
                }
                return true;
            }
            case 5: {
                if (reg1 >= reg2) {
                    this.jumped = true;
                    cpuState.setProgramCounter(target);
                }
                return true;
            }
            case 6: {
                if (ElfHeader.getLongValue(reg1) < ElfHeader.getLongValue(reg2)) {
                    this.jumped = true;
                    cpuState.setProgramCounter(target);
                }
                return true;
            }
            case 7: {
                if (ElfHeader.getLongValue(reg1) >= ElfHeader.getLongValue(reg2)) {
                    this.jumped = true;
                    cpuState.setProgramCounter(target);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        switch (this.operation) {
            case 10: {
                break;
            }
            case 2: {
                s.append(RV32imState.registerABINames[this.destination]).append(",");
            }
            case 8: {
                s.append("pc");
                if (this.immediate == 0) break;
                s.append(this.immediate >= 0 ? "+" : "").append(this.immediate);
                break;
            }
            case 3: {
                s.append(RV32imState.registerABINames[this.destination]).append(",");
            }
            case 9: {
                s.append(RV32imState.registerABINames[this.source1]);
                if (this.immediate == 0) break;
                s.append(",").append(this.immediate);
                break;
            }
            case 11: 
            case 12: {
                s.append(RV32imState.registerABINames[this.source1]).append(",pc");
                if (this.immediate == 0) break;
                s.append(this.immediate >= 0 ? "+" : "").append(this.immediate);
                break;
            }
            default: {
                s.append(RV32imState.registerABINames[this.source1]).append(",").append(RV32imState.registerABINames[this.source2]).append(",pc");
                if (this.immediate == 0) break;
                s.append(this.immediate >= 0 ? "+" : "").append(this.immediate);
            }
        }
        return s.toString();
    }

    @Override
    public String getAsmInstruction(String label) {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        switch (this.operation) {
            case 10: {
                break;
            }
            case 2: {
                s.append(RV32imState.registerABINames[this.destination]).append(",");
            }
            case 8: {
                s.append(label);
                break;
            }
            case 3: {
                s.append(RV32imState.registerABINames[this.destination]).append(",");
            }
            case 9: {
                s.append(RV32imState.registerABINames[this.source1]);
                if (this.immediate == 0) break;
                s.append(",").append(this.immediate);
                break;
            }
            case 11: 
            case 12: {
                s.append(RV32imState.registerABINames[this.source1]).append(",").append(label);
                break;
            }
            default: {
                s.append(RV32imState.registerABINames[this.source2]).append(",").append(RV32imState.registerABINames[this.source1]).append(",");
                s.append(label);
            }
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.jumped = false;
        this.valid = this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return this.valid & this.jumped;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean decodeBin() {
        int opcode = RV32imSupport.getOpcode(this.instruction);
        this.isPcRelative = true;
        switch (opcode) {
            case 111: {
                this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
                this.operation = this.destination == 0 ? 8 : 2;
                this.immediate = RV32imSupport.getImmediateValue(this.instruction, 5);
                return true;
            }
            case 103: {
                if (RV32imSupport.getFunct3(this.instruction) != 0) {
                    return false;
                }
                this.isPcRelative = false;
                this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
                this.operation = this.destination == 0 ? 9 : 3;
                this.source1 = RV32imSupport.getSourceRegister1Index(this.instruction);
                this.immediate = RV32imSupport.getImmediateValue(this.instruction, 1);
                if (this.operation == 9 && this.source1 == 1 && this.immediate == 0) {
                    this.operation = 10;
                }
                return true;
            }
            case 99: {
                this.operation = RV32imSupport.getFunct3(this.instruction);
                if (this.operation == 2 || this.operation == 3) {
                    return false;
                }
                this.immediate = RV32imSupport.getImmediateValue(this.instruction, 3);
                this.source1 = RV32imSupport.getSourceRegister1Index(this.instruction);
                this.source2 = RV32imSupport.getSourceRegister2Index(this.instruction);
                if (this.operation == 1 && this.source2 == 0) {
                    this.operation = 11;
                }
                if (this.operation == 0 && this.source2 == 0) {
                    this.operation = 12;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        boolean errors = false;
        switch (operation) {
            case 10: {
                if (instr.getNrOfParameters() != 0) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedNoArguments"));
                    errors = true;
                    break;
                }
                this.destination = 0;
                operation = 3;
                this.immediate = 0;
                this.source2 = 1;
                this.source1 = 1;
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 12: {
                if (instr.getNrOfParameters() == 0 || instr.getNrOfParameters() > 2) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("Rv32imAssemblerExpectedOneOrTwoArguments"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param1 = instr.getParameter(0);
                if (param1.length != 1 || param1[0].getType() != 5) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
                    errors = true;
                    break;
                }
                this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
                if (this.destination < 0 || this.destination > 31) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
                    errors = true;
                    break;
                }
                this.source2 = 0;
                this.source1 = 0;
                this.immediate = 0;
                if (instr.getNrOfParameters() == 2) {
                    AssemblerToken[] param2 = instr.getParameter(1);
                    if (param2.length != 1 || !param2[0].isNumber()) {
                        instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                        errors = true;
                        break;
                    }
                    this.immediate = param2[0].getNumberValue();
                }
                if (operation == 9) {
                    this.source1 = this.source2 = this.destination;
                    this.destination = 0;
                    operation = 3;
                }
                if (operation != 12 && operation != 11) break;
                this.source1 = this.destination;
                this.destination = 0;
                this.source2 = 0;
                operation = operation == 12 ? 0 : 1;
                break;
            }
            case 8: {
                if (instr.getNrOfParameters() != 1) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedOneArgument"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param1 = instr.getParameter(0);
                if (param1.length != 1 || !param1[0].isNumber()) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                }
                this.immediate = param1[0].getNumberValue();
                this.source2 = 0;
                this.source1 = 0;
                this.destination = 0;
                operation = 2;
                break;
            }
            default: {
                if (instr.getNrOfParameters() < 2 || instr.getNrOfParameters() > 3) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("Rv32imAssemblerExpectedTwoOrThreeArguments"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param1 = instr.getParameter(0);
                if (param1.length != 1 || param1[0].getType() != 5) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
                    errors = true;
                    break;
                }
                this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
                if (this.destination < 0 || this.destination > 31) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param2 = instr.getParameter(1);
                if (param2.length != 1 || param2[0].getType() != 5) {
                    instr.setError(param2[0], Strings.S.getter("AssemblerExpectedRegister"));
                    errors = true;
                    break;
                }
                this.source1 = this.source2 = RV32imState.getRegisterIndex(param2[0].getValue());
                if (this.source1 < 0 || this.source1 > 31) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
                    errors = true;
                    break;
                }
                this.immediate = 0;
                if (instr.getNrOfParameters() == 3) {
                    AssemblerToken[] param3 = instr.getParameter(2);
                    if (param3.length != 1 || !param3[0].isNumber()) {
                        instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                        errors = true;
                        break;
                    }
                    this.immediate = param3[0].getNumberValue();
                }
                if (operation == 3) break;
                this.source1 = this.destination;
                this.destination = 0;
            }
        }
        if (!errors) {
            switch (operation) {
                case 2: {
                    long imm = this.immediate;
                    this.immediate = (int)(imm -= instr.getProgramCounter());
                    if (this.immediate >= 524288 || this.immediate < -524288) {
                        instr.setError(instr.getParameter(instr.getNrOfParameters() - 1)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                        errors = true;
                        break;
                    }
                    this.instruction = RV32imSupport.getJTypeInstruction(111, this.destination, this.immediate);
                    break;
                }
                case 3: {
                    if (this.immediate >= 1024 || this.immediate < -1024) {
                        instr.setError(instr.getParameter(instr.getNrOfParameters() - 1)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                        errors = true;
                        break;
                    }
                    this.instruction = RV32imSupport.getITypeInstruction(103, this.destination, 0, this.source1, this.immediate);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    long imm = this.immediate;
                    this.immediate = (int)(imm -= instr.getProgramCounter());
                    if (this.immediate >= 2048 || this.immediate < -2048) {
                        instr.setError(instr.getParameter(instr.getNrOfParameters() - 1)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                        errors = true;
                        break;
                    }
                    this.instruction = RV32imSupport.getBTypeInstruction(99, operation, this.source1, this.source2, this.immediate);
                    break;
                }
                default: {
                    errors = true;
                    OptionPane.showMessageDialog(null, "Severe bug in RV32imControlTransferInstructions.java");
                }
            }
        }
        boolean bl = this.valid = !errors;
        if (this.valid) {
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }

    @Override
    public boolean isLabelSupported() {
        return this.isPcRelative;
    }

    @Override
    public long getLabelAddress(long pc) {
        return pc + (long)this.immediate;
    }
}

