/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.contracts.BaseWindowListenerContract;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.ComponentDataGuiProvider;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceStateImpl;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.data.SocUpMenuProvider;
import com.cburch.logisim.soc.data.SocUpSimulationState;
import com.cburch.logisim.soc.data.SocUpSimulationStateListener;
import com.cburch.logisim.soc.data.SocUpStateInterface;
import com.cburch.logisim.soc.data.TraceInfo;
import com.cburch.logisim.soc.file.ElfProgramHeader;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import com.cburch.logisim.soc.gui.BreakpointPanel;
import com.cburch.logisim.soc.gui.CpuDrawSupport;
import com.cburch.logisim.soc.rv32im.RV32imAssembler;
import com.cburch.logisim.soc.rv32im.RV32imAttributes;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JPanel;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;

public class RV32imState
implements SocUpSimulationStateListener,
SocProcessorInterface {
    private int resetVector = 0;
    private int exceptionVector = 20;
    private int nrOfIrqs = 0;
    private String label = "";
    private final SocBusInfo attachedBus = new SocBusInfo("");
    public static final AssemblerInterface ASSEMBLER = new RV32imAssembler();
    public static final String[] registerABINames = new String[]{"zero", "ra", "sp", "gp", "tp", "t0", "t1", "t2", "s0", "s1", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "s2", "s3", "s4", "s5", "s6", "s7", "s8", "s9", "s10", "s11", "t3", "t4", "t5", "t6"};

    public static int getRegisterIndex(String name) {
        String regName = name.toLowerCase();
        for (int i = 0; i < registerABINames.length; ++i) {
            if (!registerABINames[i].equals(regName)) continue;
            return i;
        }
        if (regName.startsWith("x") && regName.length() < 4) {
            int index;
            try {
                index = Integer.parseUnsignedInt(regName.substring(1));
            }
            catch (NumberFormatException e) {
                index = -1;
            }
            return index;
        }
        return -1;
    }

    public void copyInto(RV32imState dest) {
        dest.resetVector = this.resetVector;
        dest.exceptionVector = this.exceptionVector;
        dest.nrOfIrqs = this.nrOfIrqs;
        dest.label = this.label;
        dest.attachedBus.setBusId(this.attachedBus.getBusId());
    }

    public String getName() {
        String name = this.label;
        if (StringUtil.isNullOrEmpty(name)) {
            Location loc = this.attachedBus.getComponent().getLocation();
            name = String.format("%s@%d,%d", this.attachedBus.getComponent().getFactory().getDisplayName(), loc.getX(), loc.getY());
        }
        return name;
    }

    public boolean setResetVector(int value) {
        if (this.resetVector == value) {
            return false;
        }
        this.resetVector = value;
        return true;
    }

    public Integer getResetVector() {
        return this.resetVector;
    }

    public boolean setExceptionVector(int value) {
        if (this.exceptionVector == value) {
            return false;
        }
        this.exceptionVector = value;
        return true;
    }

    public Integer getExceptionVector() {
        return this.exceptionVector;
    }

    public boolean setNrOfIrqs(int value) {
        if (this.nrOfIrqs == value) {
            return false;
        }
        this.nrOfIrqs = value;
        return true;
    }

    public Integer getNrOfIrqs() {
        return this.nrOfIrqs;
    }

    public boolean setLabel(String value) {
        if (this.label.equals(value)) {
            return false;
        }
        this.label = value;
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean setAttachedBus(SocBusInfo value) {
        if (this.attachedBus.getBusId().equals(value.getBusId())) {
            return false;
        }
        this.attachedBus.setBusId(value.getBusId());
        return true;
    }

    public SocBusInfo getAttachedBus() {
        return this.attachedBus;
    }

    public ProcessorState getNewState(Instance inst) {
        return new ProcessorState(inst);
    }

    public void paint(int x, int y, Graphics2D g2, Instance inst, boolean visible, InstanceData pstate) {
        Graphics2D g = (Graphics2D)g2.create();
        g.translate(x + CpuDrawSupport.upStateBounds.getX(), y + CpuDrawSupport.upStateBounds.getY());
        ProcessorState state = (ProcessorState)pstate;
        if (visible && state != null) {
            state.draw(g, false);
        } else {
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, CpuDrawSupport.upStateBounds.getWidth(), CpuDrawSupport.upStateBounds.getHeight());
            g.setColor(Color.BLACK);
            GraphicsUtil.drawCenteredText(g, Strings.S.get("SocHiddenForFasterSimulation"), CpuDrawSupport.upStateBounds.getWidth() / 2, CpuDrawSupport.upStateBounds.getHeight() / 2);
        }
        g.dispose();
        if (state != null) {
            state.simState.paint(g2, x, y, CpuDrawSupport.simStateBounds);
        }
    }

    @Override
    public void simulationStateChanged() {
        if (this.attachedBus != null && this.attachedBus.getComponent() != null) {
            ((InstanceComponent)this.attachedBus.getComponent()).getInstance().fireInvalidated();
        }
    }

    @Override
    public void setEntryPointandReset(CircuitState state, long entryPoint, ElfProgramHeader progInfo, ElfSectionHeader sectInfo) {
        InstanceComponent comp;
        int entry = (int)entryPoint;
        if (this.attachedBus != null && this.attachedBus.getComponent() != null && (comp = (InstanceComponent)this.attachedBus.getComponent()).getInstance() != null) {
            ProcessorState pstate = (ProcessorState)comp.getInstance().getData(state);
            if (pstate != null) {
                pstate.reset(state, entry, progInfo, sectInfo);
            }
            comp.getInstance().fireInvalidated();
        }
    }

    @Override
    public void insertTransaction(SocBusTransaction trans, boolean hidden, CircuitState cState) {
        if (hidden) {
            trans.setAsHiddenTransaction();
        }
        if (cState == null) {
            InstanceComponent comp = (InstanceComponent)this.attachedBus.getComponent();
            if (comp == null) {
                return;
            }
            InstanceStateImpl state = comp.getInstanceStateImpl();
            if (state == null) {
                return;
            }
            cState = state.getProject().getCircuitState();
        }
        this.attachedBus.getSocSimulationManager().initializeTransaction(trans, this.attachedBus.getBusId(), cState);
    }

    @Override
    public int getEntryPoint(CircuitState cState) {
        if (cState != null) {
            InstanceComponent comp = (InstanceComponent)this.attachedBus.getComponent();
            if (comp == null) {
                return 0;
            }
            return ((ProcessorState)cState.getData(comp)).getEntryPoint();
        }
        return 0;
    }

    public class ProcessorState
    extends JPanel
    implements InstanceData,
    Cloneable,
    ComponentDataGuiProvider,
    BaseWindowListenerContract,
    SocUpStateInterface {
        private static final long serialVersionUID = 1L;
        private final int[] registers = new int[32];
        private final Boolean[] registers_valid = new Boolean[32];
        private int pc;
        private int lastRegisterWritten = -1;
        private final LinkedList<TraceInfo> instrTrace = new LinkedList();
        private Value lastClock = Value.createUnknown(BitWidth.ONE);
        private final SocUpSimulationState simState = new SocUpSimulationState();
        private final Instance myInstance;
        private boolean visible;
        private Integer entryPoint;
        private boolean programLoaded;
        private final BreakpointPanel bPanel;

        public ProcessorState(Instance inst) {
            this.myInstance = inst;
            this.setSize(AppPreferences.getScaled(CpuDrawSupport.upStateBounds.getWidth()), AppPreferences.getScaled(CpuDrawSupport.upStateBounds.getHeight()));
            SocUpMenuProvider.SOCUPMENUPROVIDER.registerCpuState(this, inst);
            this.visible = false;
            this.entryPoint = null;
            this.programLoaded = false;
            AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
            atmf.putMapping(ASSEMBLER.getHighlightStringIdentifier(), "com.cburch.logisim.soc.rv32im.RV32imSyntaxHighlighter");
            this.bPanel = new BreakpointPanel(ASSEMBLER.getHighlightStringIdentifier());
            this.reset();
        }

        @Override
        public void paint(Graphics g) {
            this.draw((Graphics2D)g, true);
        }

        public void reset() {
            this.reset(null, null, null, null);
        }

        public void reset(CircuitState state, Integer entry, ElfProgramHeader progInfo, ElfSectionHeader sectInfo) {
            if (entry != null) {
                this.entryPoint = entry;
            }
            if (progInfo != null || sectInfo != null) {
                this.programLoaded = true;
                this.bPanel.loadProgram(state, this.myInstance.getAttributeValue(RV32imAttributes.RV32IM_STATE), progInfo, sectInfo, ASSEMBLER);
            }
            this.pc = this.entryPoint != null ? this.entryPoint : RV32imState.this.resetVector;
            for (int i = 0; i < 31; ++i) {
                this.registers_valid[i] = false;
            }
            this.lastRegisterWritten = -1;
            this.instrTrace.clear();
            if (this.visible) {
                this.repaint();
            }
            this.simState.reset();
        }

        public int getEntryPoint() {
            return this.entryPoint;
        }

        @Override
        public boolean programLoaded() {
            return this.programLoaded;
        }

        @Override
        public JPanel getAsmWindow() {
            return this.bPanel;
        }

        public void setClock(Value clock, CircuitState cState) {
            if (this.lastClock == Value.FALSE && clock == Value.TRUE) {
                this.execute(cState);
            }
            this.lastClock = clock;
        }

        @Override
        public int getProgramCounter() {
            return this.pc;
        }

        @Override
        public SocUpSimulationState getSimState() {
            return this.simState;
        }

        @Override
        public void simButtonPressed() {
            this.simState.buttonPressed();
        }

        public void setProgramCounter(int value) {
            this.pc = value;
        }

        public int getRegisterValue(int index) {
            return index == 0 || index > 31 ? 0 : this.registers[index - 1];
        }

        @Override
        public String getRegisterValueHex(int index) {
            return this.isRegisterValid(index) != false ? String.format("0x%08X", this.getRegisterValue(index)) : "??????????";
        }

        public Boolean isRegisterValid(int index) {
            if (index == 0) {
                return true;
            }
            if (index > 31) {
                return false;
            }
            return this.registers_valid[index - 1];
        }

        public void writeRegister(int index, int value) {
            this.lastRegisterWritten = -1;
            if (index == 0 || index > 31) {
                return;
            }
            this.registers_valid[index - 1] = true;
            this.registers[index - 1] = value;
            this.lastRegisterWritten = index;
        }

        public void interrupt() {
            this.pc = RV32imState.this.exceptionVector;
        }

        public Component getMasterComponent() {
            return RV32imState.this.attachedBus.getComponent();
        }

        public void execute(CircuitState cState) {
            if (!this.simState.canExecute()) {
                return;
            }
            Map<Integer, Integer> breakPoints = this.bPanel.getBreakPoints();
            if (breakPoints.containsKey(this.pc) && this.simState.breakPointReached()) {
                this.bPanel.gotoLine(breakPoints.get(this.pc) - 1);
                OptionPane.showMessageDialog(null, Strings.S.get("RV32imBreakPointReached"), SocSupport.getMasterName(cState, RV32imState.this.getName()), 1);
                return;
            }
            SocBusTransaction trans = new SocBusTransaction(1, this.pc, 0, 3, RV32imState.this.attachedBus.getComponent());
            RV32imState.this.attachedBus.getSocSimulationManager().initializeTransaction(trans, RV32imState.this.attachedBus.getBusId(), cState);
            if (trans.hasError()) {
                OptionPane.showMessageDialog(null, trans.getErrorMessage(), SocSupport.getMasterName(cState, RV32imState.this.getName()) + Strings.S.get("RV32imFetchTransaction"), 0);
                this.simState.errorInExecution();
                return;
            }
            int instruction = trans.getReadData();
            ASSEMBLER.decode(instruction);
            AssemblerExecutionInterface exe = ASSEMBLER.getExeUnit();
            this.lastRegisterWritten = -1;
            while (this.instrTrace.size() >= 21) {
                this.instrTrace.removeLast();
            }
            if (exe == null) {
                OptionPane.showMessageDialog(null, Strings.S.get("RV32imFetchInvalidInstruction"), SocSupport.getMasterName(cState, RV32imState.this.getName()) + Strings.S.get("RV32imFetchTransaction"), 0);
                this.simState.errorInExecution();
                this.instrTrace.addFirst(new TraceInfo(this.pc, instruction, Strings.S.get("RV32imFetchInvInstrAsm"), true));
                this.pc += 4;
                if (this.visible) {
                    this.repaint();
                }
                return;
            }
            TraceInfo trace = new TraceInfo(this.pc, instruction, exe.getAsmInstruction(), false);
            if (!exe.execute(this, cState)) {
                StringBuilder s = new StringBuilder();
                s.append(Strings.S.get("RV32imFetchExecutionError"));
                if (exe.getErrorMessage() != null) {
                    s.append("\n").append(exe.getErrorMessage());
                }
                OptionPane.showMessageDialog(null, s.toString(), SocSupport.getMasterName(cState, RV32imState.this.getName()) + Strings.S.get("RV32imFetchTransaction"), 0);
                this.simState.errorInExecution();
                trace.setError();
                this.instrTrace.addFirst(trace);
                if (this.visible) {
                    this.repaint();
                }
                return;
            }
            this.instrTrace.addFirst(trace);
            if (!exe.performedJump()) {
                this.pc += 4;
            }
            if (this.visible) {
                this.repaint();
            }
        }

        @Override
        public ProcessorState clone() {
            try {
                return (ProcessorState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void insertTransaction(SocBusTransaction trans, boolean hidden, CircuitState cState) {
            if (hidden) {
                trans.setAsHiddenTransaction();
            }
            RV32imState.this.attachedBus.getSocSimulationManager().initializeTransaction(trans, RV32imState.this.attachedBus.getBusId(), cState);
        }

        public void draw(Graphics2D g, boolean scale) {
            CpuDrawSupport.drawRegisters(g, 0, 0, scale, this);
            CpuDrawSupport.drawHexReg(g, 170, 0, scale, this.pc, Strings.S.get("Rv32imProgramCounter"), true);
            CpuDrawSupport.drawTrace(g, 170, 40, scale, this);
        }

        @Override
        public void destroy() {
            SocUpMenuProvider.SOCUPMENUPROVIDER.deregisterCpuState(this, this.myInstance);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.repaint();
            this.visible = true;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.visible = false;
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.visible = false;
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.repaint();
            this.visible = true;
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.visible = true;
        }

        @Override
        public int getLastRegisterWritten() {
            return this.lastRegisterWritten;
        }

        @Override
        public String getRegisterAbiName(int index) {
            return registerABINames[index];
        }

        @Override
        public String getRegisterNormalName(int index) {
            return "x" + index;
        }

        @Override
        public LinkedList<TraceInfo> getTraces() {
            return this.instrTrace;
        }

        @Override
        public WindowListener getWindowListener() {
            return this;
        }

        @Override
        public JPanel getStatePanel() {
            return this;
        }

        @Override
        public AssemblerInterface getAssembler() {
            return ASSEMBLER;
        }

        @Override
        public SocProcessorInterface getProcessorInterface() {
            return this.myInstance.getAttributeValue(RV32imAttributes.RV32IM_STATE);
        }

        @Override
        public String getProcessorType() {
            return "RV32im (RISC V)";
        }

        @Override
        public int getElfType() {
            return 243;
        }
    }
}

