/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.util;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.AssemblerHighlighter;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import com.cburch.logisim.soc.file.SectionHeader;
import com.cburch.logisim.soc.file.SymbolTable;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.soc.util.AssemblerMacro;
import com.cburch.logisim.soc.util.AssemblerToken;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AssemblerInfo {
    private final SectionHeaders sections = new SectionHeaders();
    private final HashMap<AssemblerToken, StringGetter> errors = new HashMap();
    private int currentSection = -1;
    private final AssemblerInterface assembler;

    public AssemblerInfo(AssemblerInterface assembler) {
        this.assembler = assembler;
    }

    public Map<AssemblerToken, StringGetter> getErrors() {
        return this.errors;
    }

    /*
     * WARNING - void declaration
     */
    public void assemble(List<AssemblerToken> tokens, Map<String, Long> labels, Map<String, AssemblerMacro> macros) {
        void var6_14;
        this.errors.clear();
        this.sections.clear();
        HashMap<String, Integer> defines = new HashMap<String, Integer>();
        this.currentSection = -1;
        block6: for (int i = 0; i < tokens.size(); ++i) {
            AssemblerToken assemblerToken = tokens.get(i);
            switch (assemblerToken.getType()) {
                case 3: {
                    i += this.handleAsmInstructions(tokens, i, assemblerToken, defines);
                    continue block6;
                }
                case 1: {
                    this.handleLabels(labels, assemblerToken);
                    continue block6;
                }
                case 2: {
                    i += this.handleInstruction(tokens, i, assemblerToken);
                    continue block6;
                }
                case 23: {
                    i += this.handleMacros(tokens, i, assemblerToken, macros);
                    continue block6;
                }
                default: {
                    this.errors.put(assemblerToken, Strings.S.getter("AssemblerUnknownIdentifier"));
                }
            }
        }
        if (!this.errors.isEmpty()) {
            return;
        }
        for (String string : labels.keySet()) {
            if (labels.get(string) >= 0L) continue;
            OptionPane.showMessageDialog(null, "Severe bug in AssemblerInfo.java");
            return;
        }
        boolean errorsFound = false;
        for (AssemblerSectionInfo section : this.sections.getAll()) {
            errorsFound |= !section.replaceLabels(labels, this.errors);
        }
        if (errorsFound) {
            return;
        }
        errorsFound = false;
        for (AssemblerSectionInfo section : this.sections.getAll()) {
            errorsFound |= !section.replaceDefines(defines, this.errors);
        }
        if (errorsFound) {
            return;
        }
        boolean bl = false;
        while (var6_14 < this.sections.size()) {
            AssemblerSectionInfo section;
            section = this.sections.get((int)var6_14);
            for (void j = var6_14 + true; j < this.sections.size(); ++j) {
                AssemblerSectionInfo check = this.sections.get((int)j);
                if ((section.sectionStart <= check.sectionStart || section.sectionStart >= check.sectionEnd) && (section.sectionEnd <= check.sectionStart || section.sectionEnd >= check.sectionEnd)) continue;
                errorsFound = true;
                if (section.getIdentifier() != null) {
                    this.errors.put(section.getIdentifier(), Strings.S.getter("AssemblerOverlappingSections"));
                }
                if (check.getIdentifier() == null) continue;
                this.errors.put(section.getIdentifier(), Strings.S.getter("AssemblerOverlappingSections"));
            }
            ++var6_14;
        }
        if (errorsFound) {
            return;
        }
        for (AssemblerSectionInfo section : this.sections.getAll()) {
            this.errors.putAll(section.replaceInstructions(this.assembler));
        }
    }

    public boolean download(SocProcessorInterface cpu, CircuitState state) {
        for (AssemblerSectionInfo section : this.sections.getAll()) {
            if (section.download(cpu, state)) continue;
            return false;
        }
        return true;
    }

    public long getEntryPoint() {
        long entry = -1L;
        for (AssemblerSectionInfo section : this.sections.getAll()) {
            if (!section.hasInstructions()) continue;
            long sentry = section.getEntryPoint();
            if (entry >= 0L && sentry >= entry) continue;
            entry = sentry;
        }
        return entry;
    }

    public ElfSectionHeader getSectionHeader() {
        return this.sections;
    }

    private int handleMacros(List<AssemblerToken> tokens, int index, AssemblerToken current, Map<String, AssemblerMacro> macros) {
        if (!macros.containsKey(current.getValue())) {
            return 0;
        }
        AssemblerMacro macro = macros.get(current.getValue());
        macro.clearParameters();
        HashSet<Integer> acceptedParameters = this.assembler.getAcceptedParameterTypes();
        int skip = 0;
        if (index + 1 < tokens.size()) {
            int i;
            AssemblerToken[] set;
            AssemblerToken next;
            ArrayList<AssemblerToken> params = new ArrayList<AssemblerToken>();
            do {
                if (!acceptedParameters.contains((next = tokens.get(index + skip + 1)).getType())) continue;
                ++skip;
                if (next.getType() == 10) {
                    if (params.isEmpty()) {
                        this.errors.put(next, Strings.S.getter("AssemblerExpectedParameter"));
                        return tokens.size();
                    }
                    set = new AssemblerToken[params.size()];
                    for (i = 0; i < params.size(); ++i) {
                        set[i] = (AssemblerToken)params.get(i);
                    }
                    params.clear();
                    macro.addParameter(set);
                    continue;
                }
                params.add(next);
            } while (index + skip + 1 < tokens.size() && acceptedParameters.contains(next.getType()));
            if (!params.isEmpty()) {
                set = new AssemblerToken[params.size()];
                for (i = 0; i < params.size(); ++i) {
                    set[i] = (AssemblerToken)params.get(i);
                }
                params.clear();
                macro.addParameter(set);
            }
        }
        if (!macro.hasCorrectNumberOfParameters()) {
            this.errors.put(current, Strings.S.getter("AssemblerMacroIncorrectNumberOfParameters"));
            return tokens.size();
        }
        LinkedList<AssemblerToken> macroTokens = macro.getMacroTokens();
        block7: for (int i = 0; i < macroTokens.size(); ++i) {
            AssemblerToken asm = macroTokens.get(i);
            switch (asm.getType()) {
                case 2: {
                    i += this.handleInstruction(macroTokens, i, asm);
                    continue block7;
                }
                case 23: {
                    i += this.handleMacros(macroTokens, i, asm, macros);
                    continue block7;
                }
                default: {
                    this.errors.put(asm, Strings.S.getter("AssemblerUnknownIdentifier"));
                }
            }
        }
        return skip;
    }

    private int handleInstruction(List<AssemblerToken> tokens, int index, AssemblerToken current) {
        AssemblerAsmInstruction instruction = new AssemblerAsmInstruction(current, this.assembler.getInstructionSize(current.getValue()));
        HashSet<Integer> acceptedParameters = this.assembler.getAcceptedParameterTypes();
        int skip = 0;
        if (index + 1 < tokens.size()) {
            int i;
            AssemblerToken[] set;
            AssemblerToken next;
            ArrayList<AssemblerToken> params = new ArrayList<AssemblerToken>();
            do {
                if (!acceptedParameters.contains((next = tokens.get(index + skip + 1)).getType())) continue;
                ++skip;
                if (next.getType() == 10) {
                    if (params.isEmpty()) {
                        this.errors.put(next, Strings.S.getter("AssemblerExpectedParameter"));
                        return tokens.size();
                    }
                    set = new AssemblerToken[params.size()];
                    for (i = 0; i < params.size(); ++i) {
                        set[i] = (AssemblerToken)params.get(i);
                    }
                    params.clear();
                    instruction.addParameter(set);
                    continue;
                }
                params.add(next);
            } while (index + skip + 1 < tokens.size() && acceptedParameters.contains(next.getType()));
            if (!params.isEmpty()) {
                set = new AssemblerToken[params.size()];
                for (i = 0; i < params.size(); ++i) {
                    set[i] = (AssemblerToken)params.get(i);
                }
                params.clear();
                instruction.addParameter(set);
            }
        }
        this.checkIfActiveSection();
        this.sections.get(this.currentSection).addInstruction(instruction);
        return skip;
    }

    private void handleLabels(Map<String, Long> labels, AssemblerToken current) {
        if (!labels.containsKey(current.getValue())) {
            this.errors.put(current, Strings.S.getter("AssemblerUnknownLabel"));
            return;
        }
        if (labels.get(current.getValue()) >= 0L) {
            this.errors.put(current, Strings.S.getter("AssemblerDuplicatedLabelNotSupported"));
            return;
        }
        this.checkIfActiveSection();
        labels.put(current.getValue(), this.sections.get(this.currentSection).getSectionEnd());
    }

    private int handleAsmInstructions(List<AssemblerToken> tokens, int index, AssemblerToken current, Map<String, Integer> defines) {
        if (current.getValue().equals(".section")) {
            if (index + 1 >= tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingSectionName"));
                return 0;
            }
            AssemblerToken next = tokens.get(index + 1);
            if (next.getType() != 8 && next.getType() != 13 && next.getType() != 3) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingSectionName"));
                return 0;
            }
            if (!this.addSection(next.getValue(), next)) {
                this.errors.put(next, Strings.S.getter("AssemblerDuplicatedSectionError"));
                return tokens.size();
            }
            return 1;
        }
        if (current.getValue().equals(".text") || current.getValue().equals(".data") || current.getValue().equals(".rodata") || current.getValue().equals(".bss")) {
            if (!this.addSection(current.getValue(), current)) {
                this.errors.put(current, Strings.S.getter("AssemblerDuplicatedSectionError"));
                return tokens.size();
            }
            return 0;
        }
        if (current.getValue().equals(".org")) {
            if (index + 1 >= tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingNumber"));
                return 0;
            }
            AssemblerToken next = tokens.get(index + 1);
            if (!next.isNumber()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingNumber"));
                return 0;
            }
            long addr = SocSupport.convUnsignedInt(next.getNumberValue());
            this.checkIfActiveSection();
            this.sections.get(this.currentSection).setOrgInfo(addr);
            return 1;
        }
        if (current.getValue().equals(".zero")) {
            if (index + 1 >= tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingNumber"));
                return 0;
            }
            AssemblerToken next = tokens.get(index + 1);
            if (!next.isNumber()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingNumber"));
                return 0;
            }
            if (next.getNumberValue() < 0) {
                this.errors.put(next, Strings.S.getter("AssemblerExpectingPositiveNumber"));
                return 1;
            }
            if (next.getNumberValue() > 0) {
                this.checkIfActiveSection();
                this.sections.get(this.currentSection).addZeroBytes(next.getNumberValue());
            }
            return 1;
        }
        if (AssemblerHighlighter.STRINGS.contains(current.getValue())) {
            if (index + 1 >= tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingString"));
                return 0;
            }
            AssemblerToken next = tokens.get(index + 1);
            if (next.getType() != 9) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingString"));
                return 0;
            }
            this.checkIfActiveSection();
            this.sections.get(this.currentSection).addString(next.getValue());
            if (!current.getValue().equals(".ascii")) {
                this.sections.get(this.currentSection).addByte((byte)0);
            }
            return 1;
        }
        if (AssemblerHighlighter.BYTES.contains(current.getValue()) || AssemblerHighlighter.SHORTS.contains(current.getValue()) || AssemblerHighlighter.INTS.contains(current.getValue()) || AssemblerHighlighter.LONGS.contains(current.getValue())) {
            AssemblerToken next;
            if (index + 1 >= tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectingNumber"));
                return 0;
            }
            int maxRange = AssemblerHighlighter.BYTES.contains(current.getValue()) ? 8 : (AssemblerHighlighter.SHORTS.contains(current.getValue()) ? 16 : (AssemblerHighlighter.INTS.contains(current.getValue()) ? 32 : -1));
            int skip = 0;
            do {
                if (!(next = tokens.get(index + ++skip)).isNumber()) {
                    this.errors.put(next, Strings.S.getter("AssemblerExpectingNumber"));
                    return skip;
                }
                long value = next.getLongValue();
                if (maxRange > 0 && value >= 1L << maxRange) {
                    this.errors.put(next, Strings.S.getter("AssemblerValueOutOfRange"));
                    return skip;
                }
                this.checkIfActiveSection();
                int nrOfBytes = maxRange < 0 ? 8 : maxRange >> 3;
                for (int i = 0; i < nrOfBytes; ++i) {
                    this.sections.get(this.currentSection).addByte((byte)(value & 0xFFL));
                    value >>= 8;
                }
                if (index + skip + 1 >= tokens.size() || (next = tokens.get(index + skip + 1)).getType() != 10) continue;
                ++skip;
            } while (index + skip < tokens.size() && next.getType() == 10);
            return skip;
        }
        if (current.getValue().equals(".equ")) {
            if (index + 1 > tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectedLabel"));
                return 0;
            }
            int type = tokens.get(index + 1).getType();
            if (type != 8 && type != 16) {
                this.errors.put(tokens.get(index + 1), Strings.S.getter("AssemblerExpectedLabel"));
                return 1;
            }
            if (index + 2 > tokens.size()) {
                this.errors.put(current, Strings.S.getter("AssemblerExpectedLabelAndNumber"));
                return 1;
            }
            if (!tokens.get(index + 2).isNumber()) {
                this.errors.put(tokens.get(index + 2), Strings.S.getter("AssemblerExpectedImmediateValue"));
                return 2;
            }
            String label = tokens.get(index + 1).getValue();
            int value = tokens.get(index + 2).getNumberValue();
            if (type == 16) {
                this.errors.put(tokens.get(index + 1), Strings.S.getter("AssemblerDuplicatedName"));
                return 2;
            }
            defines.put(label, value);
            return 2;
        }
        this.errors.put(current, Strings.S.getter("AssemblerUnsupportedAssemblerInstruction"));
        return 0;
    }

    private void checkIfActiveSection() {
        if (this.currentSection < 0) {
            this.sections.add(new AssemblerSectionInfo());
            this.currentSection = 0;
        }
    }

    private boolean addSection(String name, AssemblerToken identifier) {
        for (AssemblerSectionInfo section : this.sections.getAll()) {
            if (!section.getSectionName().equals(name)) continue;
            return false;
        }
        if (this.currentSection < 0) {
            this.sections.add(new AssemblerSectionInfo(name, identifier));
            this.currentSection = 0;
        } else {
            long start = this.sections.get(this.currentSection).getSectionEnd();
            AssemblerSectionInfo si = new AssemblerSectionInfo(start, name, identifier);
            this.sections.add(si);
            this.currentSection = this.sections.indexOf(si);
        }
        return true;
    }

    public class SectionHeaders
    extends ElfSectionHeader {
        public AssemblerSectionInfo get(int index) {
            return (AssemblerSectionInfo)super.getHeader(index);
        }

        public void add(AssemblerSectionInfo obj) {
            super.addHeader(obj);
        }

        public ArrayList<AssemblerSectionInfo> getAll() {
            ArrayList<AssemblerSectionInfo> ret = new ArrayList<AssemblerSectionInfo>();
            for (SectionHeader hdr : super.getHeaders()) {
                if (!(hdr instanceof AssemblerSectionInfo)) continue;
                AssemblerSectionInfo sectionInfo = (AssemblerSectionInfo)hdr;
                ret.add(sectionInfo);
            }
            return ret;
        }

        public int size() {
            return super.getHeaders().size();
        }
    }

    private class AssemblerSectionInfo
    extends SectionHeader {
        private long sectionStart;
        private long sectionEnd;
        private Map<Long, Byte> data;
        private Map<Long, AssemblerAsmInstruction> instructions;
        private final AssemblerToken identifier;

        public AssemblerSectionInfo() {
            super("NoName");
            this.identifier = null;
            this.init(0L);
        }

        public AssemblerSectionInfo(String name, AssemblerToken identifier) {
            super(name);
            this.identifier = identifier;
            this.init(0L);
        }

        public AssemblerSectionInfo(long start, String name, AssemblerToken identifier) {
            super(name);
            this.identifier = identifier;
            this.init(start);
        }

        public String getSectionName() {
            return super.getName();
        }

        public long getSectionEnd() {
            return this.sectionEnd;
        }

        public boolean hasInstructions() {
            return !this.instructions.isEmpty();
        }

        public AssemblerToken getIdentifier() {
            return this.identifier;
        }

        public long getEntryPoint() {
            if (this.instructions.isEmpty()) {
                return -1L;
            }
            long result = -1L;
            for (Long x : this.instructions.keySet()) {
                if (result >= 0L && x >= result) continue;
                result = x;
            }
            return result;
        }

        public void setOrgInfo(long address) {
            if (this.sectionStart == this.sectionEnd) {
                this.sectionStart = this.sectionEnd = address;
                return;
            }
            this.sectionEnd = address;
        }

        public void addZeroBytes(int nr) {
            this.sectionEnd += (long)nr;
        }

        public void addString(String str) {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == '\\') {
                    if (++i >= str.length()) continue;
                    char kar = str.charAt(i);
                    byte val = switch (kar) {
                        case 'b' -> 8;
                        case 't' -> 9;
                        case 'n' -> 10;
                        case 'f' -> 12;
                        case 'r' -> 13;
                        default -> (byte)kar;
                    };
                    this.data.put(this.sectionEnd, val);
                    ++this.sectionEnd;
                    continue;
                }
                if (i >= str.length()) continue;
                this.data.put(this.sectionEnd, str.getBytes()[i]);
                ++this.sectionEnd;
            }
        }

        public void addByte(Byte b) {
            if (b != 0) {
                this.data.put(this.sectionEnd, b);
            }
            ++this.sectionEnd;
        }

        public void addInstruction(AssemblerAsmInstruction instr) {
            instr.replacePcAndDoCalc(this.sectionEnd, AssemblerInfo.this.errors);
            this.instructions.put(this.sectionEnd, instr);
            this.sectionEnd += (long)instr.getSizeInBytes();
        }

        public boolean replaceLabels(Map<String, Long> labels, Map<AssemblerToken, StringGetter> errors) {
            boolean hasError = false;
            for (Long addr : this.instructions.keySet()) {
                hasError |= !this.instructions.get(addr).replaceLabels(labels, errors);
            }
            for (String label : labels.keySet()) {
                Long addr = labels.get(label);
                if (addr < this.sectionStart || addr >= this.sectionEnd) continue;
                SymbolTable st = new SymbolTable(label, SocSupport.convUnsignedLong(addr));
                super.addSymbol(st);
            }
            return !hasError;
        }

        public boolean replaceDefines(Map<String, Integer> defines, Map<AssemblerToken, StringGetter> errors) {
            boolean errorsFound = false;
            for (Long addr : this.instructions.keySet()) {
                errorsFound |= !this.instructions.get(addr).replaceDefines(defines, errors);
            }
            return !errorsFound;
        }

        public Map<AssemblerToken, StringGetter> replaceInstructions(AssemblerInterface assembler) {
            HashMap<AssemblerToken, StringGetter> errors = new HashMap<AssemblerToken, StringGetter>();
            for (long addr : this.instructions.keySet()) {
                AssemblerAsmInstruction asm = this.instructions.get(addr);
                asm.setProgramCounter(addr);
                if (!assembler.assemble(asm)) {
                    errors.putAll(asm.getErrors());
                    continue;
                }
                Byte[] bytes = asm.getBytes();
                for (int i = 0; i < asm.getSizeInBytes(); ++i) {
                    this.data.put(addr + (long)i, bytes[i]);
                }
            }
            return errors;
        }

        public boolean download(SocProcessorInterface cpu, CircuitState state) {
            for (long i = this.sectionStart; i < this.sectionEnd; ++i) {
                byte datab = this.data.containsKey(i) ? this.data.get(i) : (byte)0;
                SocBusTransaction trans = new SocBusTransaction(2, SocSupport.convUnsignedLong(i), datab, 1, "Assembler");
                cpu.insertTransaction(trans, true, state);
                if (this.hasInstructions()) {
                    super.addExecutableFlag();
                }
                super.setSize(this.sectionEnd - this.sectionStart);
                super.setStartAddress(this.sectionStart);
                if (!trans.hasError()) continue;
                return false;
            }
            return true;
        }

        private void init(long start) {
            this.sectionStart = start;
            this.sectionEnd = start;
            this.data = new HashMap<Long, Byte>();
            this.instructions = new HashMap<Long, AssemblerAsmInstruction>();
        }
    }
}

