/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.util;

import java.util.HashSet;
import java.util.Set;

public class AssemblerToken {
    public static final int LABEL = 1;
    public static final int INSTRUCTION = 2;
    public static final int ASM_INSTRUCTION = 3;
    public static final int BRACKETED_REGISTER = 4;
    public static final int REGISTER = 5;
    public static final int DEC_NUMBER = 6;
    public static final int HEX_NUMBER = 7;
    public static final int MAYBE_LABEL = 8;
    public static final int STRING = 9;
    public static final int SEPERATOR = 10;
    public static final int BRACKET_OPEN = 11;
    public static final int BRACKET_CLOSE = 12;
    public static final int LABEL_IDENTIFIER = 13;
    public static final int MATH_SUBTRACT = 14;
    public static final int MATH_ADD = 15;
    public static final int PARAMETER_LABEL = 16;
    public static final int MATH_MUL = 17;
    public static final int MATH_DIV = 18;
    public static final int MATH_REM = 19;
    public static final int MATH_SHIFT_LEFT = 20;
    public static final int MATH_SHIFT_RIGHT = 21;
    public static final int PROGRAM_COUNTER = 22;
    public static final int MACRO = 23;
    public static final int MACRO_PARAMETER = 24;
    public static final Set<Integer> MATH_OPERATORS = new HashSet<Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(15);
            this.add(14);
            this.add(17);
            this.add(18);
            this.add(19);
            this.add(20);
            this.add(21);
        }
    };
    private int type;
    private String value;
    private final int offset;
    private Boolean valid;
    private Boolean isLabel;

    public AssemblerToken(int type, String value, int offset) {
        this.type = type;
        this.value = value;
        this.offset = offset;
        this.valid = true;
        if (type == 7) {
            String[] split = value.toUpperCase().split("X");
            if (split.length != 2) {
                this.valid = false;
                return;
            }
            this.value = split[1];
        }
        if (type == 9) {
            int start = 0;
            int end = value.length();
            if (value.startsWith("\"")) {
                start = 1;
            }
            if (value.length() > 1 && value.charAt(value.length() - 1) == '\"' && value.charAt(value.length() - 2) != '\\') {
                --end;
            }
            this.value = start >= end ? "" : value.substring(start, end);
        }
        this.isLabel = type == 1;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isNumber() {
        return this.type == 6 || this.type == 7;
    }

    public int getoffset() {
        return this.offset;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        if (type == 1 || type == 13 || type == 16) {
            this.isLabel = true;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(int val) {
        this.value = Integer.toString(val);
        this.type = 6;
    }

    public void setValue(String str) {
        this.value = str;
    }

    public boolean isLabel() {
        return this.isLabel;
    }

    public int getNumberValue() {
        if (this.type == 6) {
            return Integer.parseInt(this.value);
        }
        if (this.type == 7) {
            if (this.value.toUpperCase().contains("X")) {
                String[] split = this.value.toUpperCase().split("X");
                if (split.length != 2) {
                    this.valid = false;
                    return 0;
                }
                this.value = split[1];
            }
            return Integer.parseUnsignedInt(this.value, 16);
        }
        if (this.type == 24) {
            if (this.value.length() > 0) {
                return Integer.parseUnsignedInt(this.value.substring(1));
            }
            return 0;
        }
        return 0;
    }

    public long getLongValue() {
        if (this.type == 6) {
            return Long.parseLong(this.value);
        }
        if (this.type == 7) {
            if (this.value.toUpperCase().contains("X")) {
                String[] split = this.value.toUpperCase().split("X");
                if (split.length != 2) {
                    this.valid = false;
                    return 0L;
                }
                this.value = split[1];
            }
            return Long.parseUnsignedLong(this.value, 16);
        }
        return 0L;
    }
}

