/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.vga;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.vga.VgaAttributes;
import com.cburch.logisim.soc.vga.VgaState;
import com.cburch.logisim.tools.MenuExtender;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VgaMenu
implements ActionListener,
MenuExtender {
    private final Instance instance;
    private Frame frame;
    private JMenuItem exportC;

    public VgaMenu(Instance inst) {
        this.instance = inst;
    }

    @Override
    public void configureMenu(JPopupMenu menu, Project proj) {
        this.frame = proj.getFrame();
        this.exportC = SocSupport.createItem(this, Strings.S.get("ExportC"));
        menu.addSeparator();
        menu.add(this.exportC);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.exportC) {
            this.exportC();
        }
    }

    public void exportC() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int result = fc.showDialog(this.frame, Strings.S.get("SelectDirectoryToStoreC"));
        if (result == 0) {
            VgaState myState = this.instance.getAttributeValue(VgaAttributes.VGA_STATE);
            if (myState == null) {
                throw new NullPointerException("BUG in VgaMenu.java");
            }
            String compName = myState.getName().replace(" ", "_").replace("@", "_").replace(",", "_").toUpperCase();
            String headerFileName = fc.getSelectedFile().getAbsolutePath() + File.separator + compName + ".h";
            String cFileName = fc.getSelectedFile().getAbsolutePath() + File.separator + compName + ".c";
            FileWriter headerFile = null;
            FileWriter cFile = null;
            try {
                headerFile = new FileWriter(headerFileName, false);
            }
            catch (IOException e) {
                headerFile = null;
            }
            try {
                cFile = new FileWriter(cFileName, false);
            }
            catch (IOException e) {
                cFile = null;
            }
            if (headerFile == null || cFile == null) {
                OptionPane.showMessageDialog(this.frame, Strings.S.get("ErrorCreatingHeaderAndOrCFile"), Strings.S.get("ExportC"), 0);
                return;
            }
            PrintWriter headerWriter = new PrintWriter(headerFile);
            PrintWriter cWriter = new PrintWriter(cFile);
            headerWriter.println("/* Logisim automatically generated file for a VGA-component */\n");
            cWriter.println("/* Logisim automatically generated file for a VGA-component */\n");
            headerWriter.println("#ifndef __" + compName + "_H__");
            headerWriter.println("#define __" + compName + "_H__");
            headerWriter.println();
            headerWriter.println("#define SOFT_MODE_160X120_MASK 1");
            headerWriter.println("#define SOFT_MODE_320X240_MASK 2");
            headerWriter.println("#define SOFT_MODE_640X480_MASK 4");
            headerWriter.println("#define SOFT_MODE_800X600_MASK 8");
            headerWriter.println("#define SOFT_MODE_1024X768_MASK 16");
            headerWriter.println();
            int base = myState.getStartAddress();
            headerWriter.println(Strings.S.get("VgaMenuModeSelectFunctions"));
            SocSupport.addAllFunctions(headerWriter, cWriter, compName, "VgaMode", base, 0);
            headerWriter.println("#endif");
            headerWriter.close();
            cWriter.close();
            OptionPane.showMessageDialog(this.frame, Strings.S.get("SuccesCreatingHeaderAndCFile", headerFileName, cFileName));
        }
    }
}

