/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Graphics;

public class BitFinder
extends InstanceFactory {
    public static final String _ID = "BitFinder";
    static final AttributeOption LOW_ONE = new AttributeOption("low1", Strings.S.getter("bitFinderLowOption", "1"));
    static final AttributeOption HIGH_ONE = new AttributeOption("high1", Strings.S.getter("bitFinderHighOption", "1"));
    static final AttributeOption LOW_ZERO = new AttributeOption("low0", Strings.S.getter("bitFinderLowOption", "0"));
    static final AttributeOption HIGH_ZERO = new AttributeOption("high0", Strings.S.getter("bitFinderHighOption", "0"));
    static final Attribute<AttributeOption> TYPE = Attributes.forOption("type", Strings.S.getter("bitFinderTypeAttr"), new AttributeOption[]{LOW_ONE, HIGH_ONE, LOW_ZERO, HIGH_ZERO});

    public BitFinder() {
        super(_ID, Strings.S.getter("bitFinderComponent"));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, TYPE}, new Object[]{BitWidth.create(8), LOW_ONE});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setIcon(new ArithmeticIcon("?"));
    }

    private int computeOutputBits(int maxBits) {
        int outWidth = 1;
        while (1 << outWidth <= maxBits) {
            ++outWidth;
        }
        return outWidth;
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        instance.addAttributeListener();
    }

    private void configurePorts(Instance instance) {
        BitWidth inWidth = instance.getAttributeValue(StdAttr.WIDTH);
        int outWidth = this.computeOutputBits(inWidth.getWidth() - 1);
        Port[] ps = new Port[]{new Port(-20, 20, "output", BitWidth.ONE), new Port(0, 0, "output", BitWidth.create(outWidth)), new Port(-40, 0, "input", inWidth)};
        AttributeOption type = instance.getAttributeValue(TYPE);
        if (type == HIGH_ZERO) {
            ps[0].setToolTip(Strings.S.getter("bitFinderPresentTip", "0"));
            ps[1].setToolTip(Strings.S.getter("bitFinderIndexHighTip", "0"));
        } else if (type == LOW_ZERO) {
            ps[0].setToolTip(Strings.S.getter("bitFinderPresentTip", "0"));
            ps[1].setToolTip(Strings.S.getter("bitFinderIndexLowTip", "0"));
        } else if (type == HIGH_ONE) {
            ps[0].setToolTip(Strings.S.getter("bitFinderPresentTip", "1"));
            ps[1].setToolTip(Strings.S.getter("bitFinderIndexHighTip", "1"));
        } else {
            ps[0].setToolTip(Strings.S.getter("bitFinderPresentTip", "1"));
            ps[1].setToolTip(Strings.S.getter("bitFinderIndexLowTip", "1"));
        }
        ps[2].setToolTip(Strings.S.getter("bitFinderInputTip"));
        instance.setPorts(ps);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        return Bounds.create(-40, -20, 40, 40);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.WIDTH) {
            this.configurePorts(instance);
        } else if (attr == TYPE) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        String bot;
        String mid;
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        painter.drawPorts();
        String top = Strings.S.get("bitFinderFindLabel");
        AttributeOption type = painter.getAttributeValue(TYPE);
        if (type == HIGH_ZERO) {
            mid = Strings.S.get("bitFinderHighLabel");
            bot = "0";
        } else if (type == LOW_ZERO) {
            mid = Strings.S.get("bitFinderLowLabel");
            bot = "0";
        } else if (type == HIGH_ONE) {
            mid = Strings.S.get("bitFinderHighLabel");
            bot = "1";
        } else {
            mid = Strings.S.get("bitFinderLowLabel");
            bot = "1";
        }
        Bounds bds = painter.getBounds();
        int x = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY();
        GraphicsUtil.drawCenteredText(g, top, x, y0 + 8);
        GraphicsUtil.drawCenteredText(g, mid, x, y0 + 20);
        GraphicsUtil.drawCenteredText(g, bot, x, y0 + 32);
    }

    @Override
    public void propagate(InstanceState state) {
        Value index;
        Value present;
        int i;
        Value want;
        int width = state.getAttributeValue(StdAttr.WIDTH).getWidth();
        int outWidth = this.computeOutputBits(width - 1);
        AttributeOption type = state.getAttributeValue(TYPE);
        Value[] bits = state.getPortValue(2).getAll();
        if (type == HIGH_ZERO) {
            want = Value.FALSE;
            for (i = bits.length - 1; i >= 0 && bits[i] == Value.TRUE; --i) {
            }
        } else if (type == LOW_ZERO) {
            want = Value.FALSE;
            for (i = 0; i < bits.length && bits[i] == Value.TRUE; ++i) {
            }
        } else if (type == HIGH_ONE) {
            want = Value.TRUE;
            for (i = bits.length - 1; i >= 0 && bits[i] == Value.FALSE; --i) {
            }
        } else {
            want = Value.TRUE;
            for (i = 0; i < bits.length && bits[i] == Value.FALSE; ++i) {
            }
        }
        if (i < 0 || i >= bits.length) {
            present = Value.FALSE;
            index = Value.createKnown(BitWidth.create(outWidth), 0L);
        } else if (bits[i] == want) {
            present = Value.TRUE;
            index = Value.createKnown(BitWidth.create(outWidth), (long)i);
        } else {
            present = Value.ERROR;
            index = Value.createError(BitWidth.create(outWidth));
        }
        int delay = outWidth * 1;
        state.setPort(0, present, delay);
        state.setPort(1, index, delay);
    }
}

