/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.ComparatorHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;

public class Comparator
extends InstanceFactory {
    public static final String _ID = "Comparator";
    public static final AttributeOption SIGNED_OPTION = new AttributeOption("twosComplement", "twosComplement", Strings.S.getter("twosComplementOption"));
    public static final AttributeOption UNSIGNED_OPTION = new AttributeOption("unsigned", "unsigned", Strings.S.getter("unsignedOption"));
    public static final Attribute<AttributeOption> MODE_ATTR = Attributes.forOption("mode", Strings.S.getter("comparatorType"), new AttributeOption[]{SIGNED_OPTION, UNSIGNED_OPTION});
    public static final int IN0 = 0;
    public static final int IN1 = 1;
    public static final int GT = 2;
    public static final int EQ = 3;
    public static final int LT = 4;

    public Comparator() {
        super(_ID, Strings.S.getter("comparatorComponent"), new ComparatorHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, MODE_ATTR}, new Object[]{BitWidth.create(8), SIGNED_OPTION});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("\u2276"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.WIDTH), new Port(-40, 10, "input", StdAttr.WIDTH), new Port(0, -10, "output", 1), new Port(0, 0, "output", 1), new Port(0, 10, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("comparatorInputATip"));
        ps[1].setToolTip(Strings.S.getter("comparatorInputBTip"));
        ps[2].setToolTip(Strings.S.getter("comparatorGreaterTip"));
        ps[3].setToolTip(Strings.S.getter("comparatorEqualTip"));
        ps[4].setToolTip(Strings.S.getter("comparatorLessTip"));
        this.setPorts(ps);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        if (attrs.getValue(StdAttr.WIDTH).getWidth() == 1) {
            completeName.append("BitComparator");
        } else {
            completeName.append(CorrectLabel.getCorrectLabel(this.getName()));
        }
        return completeName.toString();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        instance.fireInvalidated();
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.drawBounds();
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2, ">", Direction.WEST);
        painter.drawPort(3, "=", Direction.WEST);
        painter.drawPort(4, "<", Direction.WEST);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        Value gt = Value.FALSE;
        Value eq = Value.TRUE;
        Value lt = Value.FALSE;
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        Value[] ax = a.getAll();
        Value[] bx = b.getAll();
        int maxlen = Math.max(ax.length, bx.length);
        for (int pos = maxlen - 1; pos >= 0; --pos) {
            AttributeOption mode;
            Value bb;
            Value ab = pos < ax.length ? ax[pos] : Value.ERROR;
            Value value = bb = pos < bx.length ? bx[pos] : Value.ERROR;
            if (pos == ax.length - 1 && ab != bb && (mode = state.getAttributeValue(MODE_ATTR)) != UNSIGNED_OPTION) {
                Value t = ab;
                ab = bb;
                bb = t;
            }
            if (ab == Value.ERROR || bb == Value.ERROR) {
                gt = Value.ERROR;
                eq = Value.ERROR;
                lt = Value.ERROR;
                break;
            }
            if (ab == Value.UNKNOWN || bb == Value.UNKNOWN) {
                gt = Value.UNKNOWN;
                eq = Value.UNKNOWN;
                lt = Value.UNKNOWN;
                break;
            }
            if (ab == bb) continue;
            eq = Value.FALSE;
            if (ab == Value.TRUE) {
                gt = Value.TRUE;
                break;
            }
            lt = Value.TRUE;
            break;
        }
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, gt, delay);
        state.setPort(3, eq, delay);
        state.setPort(4, lt, delay);
    }
}

