/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.Comparator;
import com.cburch.logisim.std.arith.Multiplier;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.math.BigInteger;

public class Divider
extends InstanceFactory {
    public static final String _ID = "Divider";
    static final int PER_DELAY = 1;
    public static final int IN0 = 0;
    public static final int IN1 = 1;
    public static final int OUT = 2;
    public static final int UPPER = 3;
    public static final int REM = 4;

    static Value[] computeResult(BitWidth width, Value a, Value b, Value upper, boolean unsigned) {
        int w = width.getWidth();
        if (upper == Value.NIL || upper.isUnknown()) {
            upper = Value.createKnown(width, 0L);
        }
        if (a.isFullyDefined() && b.isFullyDefined() && upper.isFullyDefined()) {
            BigInteger uu = Multiplier.extend(w, upper.toLongValue(), unsigned);
            BigInteger aa = Multiplier.extend(w, a.toLongValue(), unsigned);
            BigInteger bb = Multiplier.extend(w, b.toLongValue(), unsigned);
            BigInteger num = uu.shiftLeft(w).or(aa);
            BigInteger den = bb.equals(BigInteger.ZERO) ? BigInteger.valueOf(1L) : bb;
            BigInteger[] res = num.divideAndRemainder(den);
            long mask = w == 64 ? 0L : -1L << w;
            long result = res[0].and(BigInteger.valueOf(mask ^= 0xFFFFFFFFFFFFFFFFL)).longValue();
            long rem = res[1].and(BigInteger.valueOf(mask)).longValue();
            return new Value[]{Value.createKnown(width, result), Value.createKnown(width, rem)};
        }
        if (a.isErrorValue() || b.isErrorValue() || upper.isErrorValue()) {
            return new Value[]{Value.createError(width), Value.createError(width)};
        }
        return new Value[]{Value.createUnknown(width), Value.createUnknown(width)};
    }

    public Divider() {
        super(_ID, Strings.S.getter("dividerComponent"));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, Comparator.MODE_ATTR}, new Object[]{BitWidth.create(8), Comparator.UNSIGNED_OPTION});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("\u00f7"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.WIDTH), new Port(-40, 10, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-20, -20, "input", StdAttr.WIDTH), new Port(-20, 20, "output", StdAttr.WIDTH)};
        ps[0].setToolTip(Strings.S.getter("dividerDividendLowerTip"));
        ps[1].setToolTip(Strings.S.getter("dividerDivisorTip"));
        ps[2].setToolTip(Strings.S.getter("dividerOutputTip"));
        ps[3].setToolTip(Strings.S.getter("dividerDividendUpperTip"));
        ps[4].setToolTip(Strings.S.getter("dividerRemainderTip"));
        this.setPorts(ps);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == Comparator.MODE_ATTR) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2);
        painter.drawPort(3, Strings.S.get("dividerUpperInput"), Direction.NORTH);
        painter.drawPort(4, Strings.S.get("dividerRemainderOutput"), Direction.SOUTH);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.BLACK);
        g.fillOval(x - 12, y - 7, 4, 4);
        g.drawLine(x - 15, y, x - 5, y);
        g.fillOval(x - 12, y + 3, 4, 4);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        boolean unsigned = state.getAttributeValue(Comparator.MODE_ATTR).equals(Comparator.UNSIGNED_OPTION);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        Value upper = state.getPortValue(3);
        Value[] outs = Divider.computeResult(dataWidth, a, b, upper, unsigned);
        int delay = dataWidth.getWidth() * (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, outs[0], delay);
        state.setPort(4, outs[1], delay);
    }
}

