/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class FpComparator
extends InstanceFactory {
    public static final String _ID = "FPComparator";
    static final int PER_DELAY = 1;
    private static final int IN0 = 0;
    private static final int IN1 = 1;
    private static final int GT = 2;
    private static final int EQ = 3;
    private static final int LT = 4;
    private static final int ERR = 5;

    public FpComparator() {
        super(_ID, Strings.S.getter("fpComparatorComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FP_WIDTH}, new Object[]{BitWidth.create(32)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.FP_WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("\u2276"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.FP_WIDTH), new Port(-40, 10, "input", StdAttr.FP_WIDTH), new Port(0, -10, "output", 1), new Port(0, 0, "output", 1), new Port(0, 10, "output", 1), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("comparatorInputATip"));
        ps[1].setToolTip(Strings.S.getter("comparatorInputBTip"));
        ps[2].setToolTip(Strings.S.getter("comparatorGreaterTip"));
        ps[3].setToolTip(Strings.S.getter("comparatorEqualTip"));
        ps[4].setToolTip(Strings.S.getter("comparatorLessTip"));
        ps[5].setToolTip(Strings.S.getter("fpErrorTip"));
        this.setPorts(ps);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        instance.fireInvalidated();
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2, ">", Direction.WEST);
        painter.drawPort(3, "=", Direction.WEST);
        painter.drawPort(4, "<", Direction.WEST);
        painter.drawPort(5);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.BLACK);
        g.drawLine(x - 35, y - 15, x - 35, y + 5);
        g.drawLine(x - 35, y - 15, x - 25, y - 15);
        g.drawLine(x - 35, y - 5, x - 25, y - 5);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.FP_WIDTH);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        double a_val = dataWidth.getWidth() == 64 ? a.toDoubleValue() : (double)a.toFloatValue();
        double b_val = dataWidth.getWidth() == 64 ? b.toDoubleValue() : (double)b.toFloatValue();
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, Value.createKnown(1, a_val > b_val ? 1L : 0L), delay);
        state.setPort(3, Value.createKnown(1, a_val == b_val ? 1L : 0L), delay);
        state.setPort(4, Value.createKnown(1, a_val < b_val ? 1L : 0L), delay);
        state.setPort(5, Value.createKnown(1, Double.isNaN(a_val) || Double.isNaN(b_val) ? 1L : 0L), delay);
    }
}

