/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class FpDivider
extends InstanceFactory {
    public static final String _ID = "FPDivider";
    static final int PER_DELAY = 1;
    private static final int IN0 = 0;
    private static final int IN1 = 1;
    private static final int OUT = 2;
    private static final int ERR = 3;

    public FpDivider() {
        super(_ID, Strings.S.getter("fpDividerComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FP_WIDTH}, new Object[]{BitWidth.create(32)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.FP_WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("\u00f7"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.FP_WIDTH), new Port(-40, 10, "input", StdAttr.FP_WIDTH), new Port(0, 0, "output", StdAttr.FP_WIDTH), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("fpDividerDividendTip"));
        ps[1].setToolTip(Strings.S.getter("dividerDivisorTip"));
        ps[2].setToolTip(Strings.S.getter("dividerOutputTip"));
        ps[3].setToolTip(Strings.S.getter("fpErrorTip"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2);
        painter.drawPort(3);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.BLACK);
        g.fillOval(x - 12, y - 7, 4, 4);
        g.drawLine(x - 15, y, x - 5, y);
        g.fillOval(x - 12, y + 3, 4, 4);
        g.drawLine(x - 35, y - 15, x - 35, y + 5);
        g.drawLine(x - 35, y - 15, x - 25, y - 15);
        g.drawLine(x - 35, y - 5, x - 25, y - 5);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.FP_WIDTH);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        double a_val = dataWidth.getWidth() == 64 ? a.toDoubleValue() : (double)a.toFloatValue();
        double b_val = dataWidth.getWidth() == 64 ? b.toDoubleValue() : (double)b.toFloatValue();
        double out_val = a_val / b_val;
        Value out = dataWidth.getWidth() == 64 ? Value.createKnown(out_val) : Value.createKnown((float)out_val);
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, out, delay);
        state.setPort(3, Value.createKnown(BitWidth.create(1), Double.isNaN(out_val) ? 1L : 0L), delay);
    }
}

