/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class FpNegator
extends InstanceFactory {
    public static final String _ID = "FPNegator";
    static final int PER_DELAY = 1;
    private static final int IN = 0;
    private static final int OUT = 1;
    private static final int ERR = 2;

    public FpNegator() {
        super(_ID, Strings.S.getter("fpNegatorComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FP_WIDTH}, new Object[]{BitWidth.create(32)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.FP_WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("-x"));
        Port[] ps = new Port[]{new Port(-40, 0, "input", StdAttr.FP_WIDTH), new Port(0, 0, "output", StdAttr.FP_WIDTH), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("negatorInputTip"));
        ps[1].setToolTip(Strings.S.getter("fpNegatorOutputTip"));
        ps[2].setToolTip(Strings.S.getter("fpErrorTip"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1, "-x", Direction.WEST);
        painter.drawPort(2);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.BLACK);
        g.drawLine(x - 35, y - 15, x - 35, y + 5);
        g.drawLine(x - 35, y - 15, x - 25, y - 15);
        g.drawLine(x - 35, y - 5, x - 25, y - 5);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.FP_WIDTH);
        Value a = state.getPortValue(0);
        double a_val = dataWidth.getWidth() == 64 ? a.toDoubleValue() : (double)a.toFloatValue();
        double out_val = a_val * -1.0;
        Value out = dataWidth.getWidth() == 64 ? Value.createKnown(out_val) : Value.createKnown((float)out_val);
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(1, out, delay);
        state.setPort(2, Value.createKnown(BitWidth.create(1), Double.isNaN(out_val) ? 1L : 0L), delay);
    }
}

