/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.Comparator;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import java.awt.Color;
import java.awt.Graphics;
import java.math.BigInteger;

public class IntToFp
extends InstanceFactory {
    public static final String _ID = "IntToFP";
    static final int PER_DELAY = 1;
    private static final int IN = 0;
    private static final int OUT = 1;
    private static final int ERR = 2;

    static BigInteger extend(int w, long v, boolean unsigned) {
        long mask = w == 64 ? 0L : -1L << w;
        long value = v & (mask ^= 0xFFFFFFFFFFFFFFFFL);
        if (!unsigned && value >> w - 1 != 0L) {
            value |= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (unsigned) {
            return new BigInteger(Long.toUnsignedString(value));
        }
        return new BigInteger(Long.toString(value));
    }

    public IntToFp() {
        super(_ID, Strings.S.getter("intToFPComponent"));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.FP_WIDTH, Comparator.MODE_ATTR}, new Object[]{BitWidth.create(8), BitWidth.create(32), Comparator.SIGNED_OPTION});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.FP_WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("I\u2192FP", 2));
        Port[] ps = new Port[]{new Port(-40, 0, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.FP_WIDTH), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("intToFPInputTip"));
        ps[1].setToolTip(Strings.S.getter("intToFPOutputTip"));
        ps[2].setToolTip(Strings.S.getter("fpErrorTip"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1, "I\u2192F", Direction.WEST);
        painter.drawPort(2);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidthIn = state.getAttributeValue(StdAttr.WIDTH);
        BitWidth dataWidthOut = state.getAttributeValue(StdAttr.FP_WIDTH);
        boolean unsigned = state.getAttributeValue(Comparator.MODE_ATTR).equals(Comparator.UNSIGNED_OPTION);
        Value a = state.getPortValue(0);
        BigInteger a_val = IntToFp.extend(dataWidthIn.getWidth(), a.toLongValue(), unsigned);
        double out_val = a.isFullyDefined() ? a_val.doubleValue() : Double.NaN;
        Value out = dataWidthOut.getWidth() == 64 ? Value.createKnown(out_val) : Value.createKnown((float)out_val);
        int delay = (dataWidthIn.getWidth() + 2) * 1;
        state.setPort(1, out, delay);
        state.setPort(2, Value.createKnown(BitWidth.create(1), Double.isNaN(out_val) ? 1L : 0L), delay);
    }
}

