/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.Comparator;
import com.cburch.logisim.std.arith.MultiplierHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.math.BigInteger;

public class Multiplier
extends InstanceFactory {
    public static final String _ID = "Multiplier";
    static final int PER_DELAY = 1;
    public static final int IN0 = 0;
    public static final int IN1 = 1;
    public static final int OUT = 2;
    public static final int C_IN = 3;
    public static final int C_OUT = 4;

    static BigInteger extend(int w, long v, boolean unsigned) {
        long mask = w == 64 ? 0L : -1L << w;
        long value = v & (mask ^= 0xFFFFFFFFFFFFFFFFL);
        if (!unsigned && value >> w - 1 != 0L) {
            value |= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (unsigned) {
            return new BigInteger(Long.toUnsignedString(value));
        }
        return new BigInteger(Long.toString(value));
    }

    static Value[] computeProduct(BitWidth width, Value a, Value b, Value c_in, boolean unsigned) {
        int w = width.getWidth();
        if (c_in == Value.NIL || c_in.isUnknown()) {
            c_in = Value.createKnown(width, 0L);
        }
        if (a.isFullyDefined() && b.isFullyDefined() && c_in.isFullyDefined()) {
            BigInteger aa = Multiplier.extend(w, a.toLongValue(), unsigned);
            BigInteger bb = Multiplier.extend(w, b.toLongValue(), unsigned);
            BigInteger cc = Multiplier.extend(w, c_in.toLongValue(), unsigned);
            BigInteger rr = aa.multiply(bb).add(cc);
            long mask = w == 64 ? 0L : -1L << w;
            long lo = rr.and(BigInteger.valueOf(mask ^= 0xFFFFFFFFFFFFFFFFL)).longValue();
            long hi = rr.shiftRight(w).and(BigInteger.valueOf(mask)).longValue();
            return new Value[]{Value.createKnown(width, lo), Value.createKnown(width, hi)};
        }
        Value[] avals = a.getAll();
        int aOk = Multiplier.findUnknown(avals);
        int aErr = Multiplier.findError(avals);
        int ax = Multiplier.getKnown(avals);
        Value[] bvals = b.getAll();
        int bOk = Multiplier.findUnknown(bvals);
        int bErr = Multiplier.findError(bvals);
        int bx = Multiplier.getKnown(bvals);
        Value[] cvals = c_in.getAll();
        int cOk = Multiplier.findUnknown(cvals);
        int cErr = Multiplier.findError(cvals);
        int cx = Multiplier.getKnown(cvals);
        int known = Math.min(Math.min(aOk, bOk), cOk);
        int error = Math.min(Math.min(aErr, bErr), cErr);
        BigInteger aa = Multiplier.extend(w, ax, unsigned);
        BigInteger bb = Multiplier.extend(w, bx, unsigned);
        BigInteger cc = Multiplier.extend(w, cx, unsigned);
        BigInteger rr = aa.multiply(bb).add(cc);
        long ret = rr.longValue();
        Value[] bits = new Value[w];
        for (int i = 0; i < w; ++i) {
            bits[i] = i < known ? ((ret & (long)(1 << i)) != 0L ? Value.TRUE : Value.FALSE) : (i < error ? Value.UNKNOWN : Value.ERROR);
        }
        return new Value[]{Value.create(bits), error < w ? Value.createError(width) : Value.createUnknown(width)};
    }

    private static int findError(Value[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (!vals[i].isErrorValue()) continue;
            return i;
        }
        return vals.length;
    }

    private static int findUnknown(Value[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].isFullyDefined()) continue;
            return i;
        }
        return vals.length;
    }

    private static int getKnown(Value[] vals) {
        int ret = 0;
        for (int i = 0; i < vals.length; ++i) {
            int val = (int)vals[i].toLongValue();
            if (val < 0) {
                return ret;
            }
            ret |= val << i;
        }
        return ret;
    }

    public Multiplier() {
        super(_ID, Strings.S.getter("multiplierComponent"), new MultiplierHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, Comparator.MODE_ATTR}, new Object[]{BitWidth.create(8), Comparator.UNSIGNED_OPTION});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("\u00d7"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.WIDTH), new Port(-40, 10, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-20, -20, "input", StdAttr.WIDTH), new Port(-20, 20, "output", StdAttr.WIDTH)};
        ps[0].setToolTip(Strings.S.getter("multiplierInputTip"));
        ps[1].setToolTip(Strings.S.getter("multiplierInputTip"));
        ps[2].setToolTip(Strings.S.getter("multiplierOutputTip"));
        ps[3].setToolTip(Strings.S.getter("multiplierCarryInTip"));
        ps[4].setToolTip(Strings.S.getter("multiplierCarryOutTip"));
        this.setPorts(ps);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == Comparator.MODE_ATTR) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        g.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2);
        painter.drawPort(3, "c in", Direction.NORTH);
        painter.drawPort(4, "c out", Direction.SOUTH);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(Color.BLACK);
        g.drawLine(x - 15, y - 5, x - 5, y + 5);
        g.drawLine(x - 15, y + 5, x - 5, y - 5);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        boolean unsigned = state.getAttributeValue(Comparator.MODE_ATTR).equals(Comparator.UNSIGNED_OPTION);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        Value c_in = state.getPortValue(3);
        Value[] outs = Multiplier.computeProduct(dataWidth, a, b, c_in, unsigned);
        int delay = dataWidth.getWidth() * (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, outs[0], delay);
        state.setPort(4, outs[1], delay);
    }
}

