/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.arith.Adder;
import com.cburch.logisim.std.arith.SubtractorHdlGeneratorFactory;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class Subtractor
extends InstanceFactory {
    public static final String _ID = "Subtractor";
    public static final int IN0 = 0;
    public static final int IN1 = 1;
    public static final int OUT = 2;
    public static final int B_IN = 3;
    public static final int B_OUT = 4;

    public Subtractor() {
        super(_ID, Strings.S.getter("subtractorComponent"), new SubtractorHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.WIDTH}, new Object[]{BitWidth.create(8)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("-"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.WIDTH), new Port(-40, 10, "input", StdAttr.WIDTH), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-20, -20, "input", 1), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("subtractorMinuendTip"));
        ps[1].setToolTip(Strings.S.getter("subtractorSubtrahendTip"));
        ps[2].setToolTip(Strings.S.getter("subtractorOutputTip"));
        ps[3].setToolTip(Strings.S.getter("subtractorBorrowInTip"));
        ps[4].setToolTip(Strings.S.getter("subtractorBorrowOutTip"));
        this.setPorts(ps);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder fullName = new StringBuilder();
        if (attrs.getValue(StdAttr.WIDTH).getWidth() == 1) {
            fullName.append("FullSubtractor");
        } else {
            fullName.append(CorrectLabel.getCorrectLabel(this.getName()));
        }
        return fullName.toString();
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics gfx = painter.getGraphics();
        painter.drawBounds();
        gfx.setColor(Color.GRAY);
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2);
        painter.drawPort(3, "b in", Direction.NORTH);
        painter.drawPort(4, "b out", Direction.SOUTH);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(gfx, 2);
        gfx.setColor(Color.BLACK);
        gfx.drawLine(x - 15, y, x - 5, y);
        GraphicsUtil.switchToWidth(gfx, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth data = state.getAttributeValue(StdAttr.WIDTH);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        Value bIn = state.getPortValue(3);
        if (bIn == Value.UNKNOWN || bIn == Value.NIL) {
            bIn = Value.FALSE;
        }
        Value[] outs = Adder.computeSum(data, a, b.not(), bIn.not());
        int delay = (data.getWidth() + 4) * 1;
        state.setPort(2, outs[0], delay);
        state.setPort(4, outs[1].not(), delay);
    }
}

