/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.LineBuffer;

public class SubtractorHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;
    private static final String EXTENDED_BITS_STRING = "extendedBits";
    private static final int EXTENDED_BITS_ID = -2;

    public SubtractorHdlGeneratorFactory() {
        this.myParametersList.addBusOnly(NR_OF_BITS_STRING, -1).add(EXTENDED_BITS_STRING, -2, 2, 1);
        this.myWires.addWire("s_extendeddataA", -2).addWire("s_extendeddataB", -2).addWire("s_sumresult", -2).addWire("s_carry", 1);
        this.myPorts.add("input", "dataA", -1, 0, StdAttr.WIDTH).add("input", "dataB", -1, 1, StdAttr.WIDTH).add("input", "borrowIn", 1, 3).add("output", "result", -1, 2, StdAttr.WIDTH).add("output", "borrowOut", 1, 4);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer();
        int nrOfBits = attrs.getValue(StdAttr.WIDTH).getWidth();
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("s_extendeddataA <= \"0\"&dataA;\ns_extendeddataB <= \"0\"&({{not}}(dataB));\ns_carry         <= {{not}}(borrowIn);\ns_sumresult     <= std_logic_vector(unsigned(s_extendeddataA) +\n                   unsigned(s_extendeddataB) +\n                   (\"\"&s_carry));\n");
            contents.add(nrOfBits == 1 ? "result    <= s_sumresult(0);" : "result    <= s_sumresult( (nrOfBits-1) {{downto}} 0 );");
            contents.add("borrowOut <= {{not}}(s_sumresult(extendedBits-1));");
        } else {
            contents.add("assign {s_carry,result} = dataA + ~(dataB) + ~(borrowIn);\nassign borrowOut        = ~s_carry;\n");
        }
        return contents.empty();
    }
}

