/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.base;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.base.Text;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.EditTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.MenuTool;
import com.cburch.logisim.tools.PokeTool;
import com.cburch.logisim.tools.SelectTool;
import com.cburch.logisim.tools.TextTool;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.WiringTool;
import java.util.Arrays;
import java.util.List;

public class BaseLibrary
extends Library {
    public static final String _ID = "Base";
    private final List<Tool> tools;
    private final AddTool textAdder = new AddTool(Text.FACTORY);
    private final SelectTool selectTool = new SelectTool();

    public BaseLibrary() {
        this.setHidden();
        WiringTool wiring = new WiringTool();
        this.tools = Arrays.asList(new PokeTool(), new EditTool(this.selectTool, wiring), wiring, new TextTool(), new MenuTool());
    }

    @Override
    public boolean contains(ComponentFactory querry) {
        return super.contains(querry) || querry instanceof Text;
    }

    @Override
    public Tool getTool(String name) {
        Tool t = super.getTool(name);
        if (t == null && name.equals("Text")) {
            return this.textAdder;
        }
        return t;
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("baseLibrary");
    }

    public List<Tool> getTools() {
        return this.tools;
    }
}

