/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.bfh;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.bfh.BcdToSevenSegmentDisplayHdlGeneratorFactory;
import java.awt.Color;
import java.awt.Graphics;

public class BcdToSevenSegmentDisplay
extends InstanceFactory {
    public static final String _ID = "BCD_to_7_Segment_decoder";
    static final int PER_DELAY = 1;
    public static final int SEGMENT_A = 0;
    public static final int SEGMENT_B = 1;
    public static final int SEGMENT_C = 2;
    public static final int SEGMENT_D = 3;
    public static final int SEGMENT_E = 4;
    public static final int SEGMENT_F = 5;
    public static final int SEGMENT_G = 6;
    public static final int BCD_IN = 7;

    public BcdToSevenSegmentDisplay() {
        super(_ID, Strings.S.getter("BCD2SevenSegment"), new BcdToSevenSegmentDisplayHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.DUMMY}, new Object[]{""});
        this.setOffsetBounds(Bounds.create(-10, -20, 50, 100));
        Port[] ps = new Port[]{new Port(20, 0, "output", 1), new Port(30, 0, "output", 1), new Port(20, 60, "output", 1), new Port(10, 60, "output", 1), new Port(0, 60, "output", 1), new Port(10, 0, "output", 1), new Port(0, 0, "output", 1), new Port(10, 80, "input", 4)};
        ps[0].setToolTip(Strings.S.getter("Segment_A"));
        ps[1].setToolTip(Strings.S.getter("Segment_B"));
        ps[2].setToolTip(Strings.S.getter("Segment_C"));
        ps[3].setToolTip(Strings.S.getter("Segment_D"));
        ps[4].setToolTip(Strings.S.getter("Segment_E"));
        ps[5].setToolTip(Strings.S.getter("Segment_F"));
        ps[6].setToolTip(Strings.S.getter("Segment_G"));
        ps[7].setToolTip(Strings.S.getter("BCDValue"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics gfx = painter.getGraphics();
        Bounds myBounds = painter.getBounds();
        if (!painter.isPrintView()) {
            gfx.setColor(Color.BLUE);
        }
        painter.drawRectangle(myBounds, "");
        painter.drawPort(7, "BCD", Direction.SOUTH);
        for (int i = 0; i < 7; ++i) {
            painter.drawPort(i);
        }
        gfx.setColor(Color.BLACK);
        painter.drawRectangle(myBounds.getX() + 5, myBounds.getY() + 20, myBounds.getWidth() - 10, myBounds.getHeight() - 40, "");
    }

    private void setKnown(InstanceState state, int portValues) {
        boolean mask = true;
        for (int idx = 0; idx <= 6; ++idx) {
            int value = (portValues & 1) == 0 ? 0 : 1;
            state.setPort(idx, Value.createKnown(BitWidth.create(1), (long)value), 1);
            portValues >>= 1;
        }
    }

    private void setUnknown(InstanceState state) {
        for (int idx = 0; idx <= 6; ++idx) {
            state.setPort(idx, Value.createUnknown(BitWidth.create(1)), 1);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        if (state.getPortValue(7).isFullyDefined() && !state.getPortValue(7).isErrorValue() && !state.getPortValue(7).isUnknown()) {
            switch ((int)state.getPortValue(7).toLongValue()) {
                case 0: {
                    this.setKnown(state, 63);
                    break;
                }
                case 1: {
                    this.setKnown(state, 6);
                    break;
                }
                case 2: {
                    this.setKnown(state, 91);
                    break;
                }
                case 3: {
                    this.setKnown(state, 79);
                    break;
                }
                case 4: {
                    this.setKnown(state, 102);
                    break;
                }
                case 5: {
                    this.setKnown(state, 109);
                    break;
                }
                case 6: {
                    this.setKnown(state, 125);
                    break;
                }
                case 7: {
                    this.setKnown(state, 7);
                    break;
                }
                case 8: {
                    this.setKnown(state, 127);
                    break;
                }
                case 9: {
                    this.setKnown(state, 111);
                    break;
                }
                default: {
                    this.setUnknown(state);
                    break;
                }
            }
        } else {
            this.setUnknown(state);
        }
    }
}

