/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.circuit.ExpressionComputer;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractBufferHdlGenerator;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NotGate;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

class Buffer
extends InstanceFactory {
    public static final String _ID = "Buffer";
    public static final InstanceFactory FACTORY = new Buffer();

    static Value repair(InstanceState state, Value v) {
        Value repaired;
        AttributeSet opts = state.getProject().getOptions().getAttributeSet();
        AttributeOption onUndefined = opts.getValue(Options.ATTR_GATE_UNDEFINED);
        boolean errorIfUndefined = onUndefined.equals(Options.GATE_UNDEFINED_ERROR);
        if (errorIfUndefined) {
            BitWidth w;
            int ww;
            int vw = v.getWidth();
            if (vw == (ww = (w = state.getAttributeValue(StdAttr.WIDTH)).getWidth()) && v.isFullyDefined()) {
                return v;
            }
            Value[] vs = new Value[w.getWidth()];
            for (int i = 0; i < vs.length; ++i) {
                Value ini = i < vw ? v.get(i) : Value.ERROR;
                vs[i] = ini.isFullyDefined() ? ini : Value.ERROR;
            }
            repaired = Value.create(vs);
        } else {
            repaired = v;
        }
        AttributeOption outType = state.getAttributeValue(GateAttributes.ATTR_OUTPUT);
        return AbstractGate.pullOutput(repaired, outType);
    }

    private Buffer() {
        super(_ID, Strings.S.getter("bufferComponent"), new AbstractBufferHdlGenerator(false));
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.WIDTH, GateAttributes.ATTR_OUTPUT, StdAttr.LABEL, StdAttr.LABEL_FONT}, new Object[]{Direction.EAST, BitWidth.ONE, GateAttributes.OUTPUT_01, "", StdAttr.DEFAULT_LABEL_FONT});
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
        this.setPorts(new Port[]{new Port(0, 0, "output", StdAttr.WIDTH), new Port(0, -20, "input", StdAttr.WIDTH)});
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        instance.addAttributeListener();
        NotGate.configureLabel(instance, false, null);
    }

    private void configurePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        Port[] ports = new Port[2];
        ports[0] = new Port(0, 0, "output", StdAttr.WIDTH);
        Location out = Location.create(0, 0, true).translate(facing, -20);
        ports[1] = new Port(out.getX(), out.getY(), "input", StdAttr.WIDTH);
        instance.setPorts(ports);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        completeName.append(CorrectLabel.getCorrectLabel(this.getName()).toUpperCase());
        completeName.append("_COMPONENT");
        BitWidth width = attrs.getValue(StdAttr.WIDTH);
        if (width.getWidth() > 1) {
            completeName.append("_BUS");
        }
        return completeName.toString();
    }

    @Override
    public Object getInstanceFeature(Instance instance, Object key) {
        if (key == ExpressionComputer.class) {
            return expressionMap -> {
                int width = instance.getAttributeValue(StdAttr.WIDTH).getWidth();
                for (int b = 0; b < width; ++b) {
                    Expression e = expressionMap.get(instance.getPortLocation(1), b);
                    if (e == null) continue;
                    expressionMap.put(instance.getPortLocation(0), b, e);
                }
            };
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        if (facing == Direction.SOUTH) {
            return Bounds.create(-9, -20, 18, 20);
        }
        if (facing == Direction.NORTH) {
            return Bounds.create(-9, 0, 18, 20);
        }
        if (facing == Direction.WEST) {
            return Bounds.create(0, -9, 20, 18);
        }
        return Bounds.create(-20, -9, 20, 18);
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        return attrs.containsAttribute(GateAttributes.ATTR_OUTPUT) ? attrs.getValue(GateAttributes.ATTR_OUTPUT) != GateAttributes.OUTPUT_01 : false;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.configurePorts(instance);
            NotGate.configureLabel(instance, false, null);
        }
    }

    private void paintBase(InstancePainter painter) {
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        Graphics g = painter.getGraphics();
        g.translate(x, y);
        double rotate = 0.0;
        if (facing != Direction.EAST && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            rotate = -facing.toRadians();
            g2d.rotate(rotate);
        }
        GraphicsUtil.switchToWidth(g, 2);
        Object shape = painter.getGateShape();
        if (shape == "rectangular") {
            g.drawRect(-19, -9, 18, 18);
            GraphicsUtil.drawCenteredText(g, "1", -10, 0);
        } else {
            int[] xp = new int[4];
            int[] yp = new int[4];
            xp[0] = 0;
            yp[0] = 0;
            xp[1] = -19;
            yp[1] = -7;
            xp[2] = -19;
            yp[2] = 7;
            xp[3] = 0;
            yp[3] = 0;
            g.drawPolyline(xp, yp, 4);
        }
        if (rotate != 0.0) {
            ((Graphics2D)g).rotate(-rotate);
        }
        g.translate(-x, -y);
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paintBase(painter);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(Color.BLACK);
        this.paintBase(painter);
        painter.drawPorts();
        painter.drawLabel();
    }

    @Override
    public void propagate(InstanceState state) {
        Value in = Buffer.repair(state, state.getPortValue(1));
        state.setPort(0, in, 1);
    }

    @Override
    public void paintIcon(InstancePainter painter) {
        Graphics2D g = (Graphics2D)painter.getGraphics();
        if (painter.getGateShape() == "rectangular") {
            AbstractGate.paintIconIEC(g, "1", false, true);
        } else {
            AbstractGate.paintIconBufferAnsi(g, false, false);
        }
    }
}

