/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.ControlledBufferHdlGenerator;
import com.cburch.logisim.std.gates.NotGate;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.tools.WireRepair;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

class ControlledBuffer
extends InstanceFactory {
    private static final AttributeOption RIGHT_HANDED = new AttributeOption("right", Strings.S.getter("controlledRightHanded"));
    private static final AttributeOption LEFT_HANDED = new AttributeOption("left", Strings.S.getter("controlledLeftHanded"));
    private static final Attribute<AttributeOption> ATTR_CONTROL = Attributes.forOption("control", Strings.S.getter("controlledControlOption"), new AttributeOption[]{RIGHT_HANDED, LEFT_HANDED});
    public static final ComponentFactory FACTORY_BUFFER = new ControlledBuffer(false);
    public static final ComponentFactory FACTORY_INVERTER = new ControlledBuffer(true);
    private final boolean isInverter;

    private ControlledBuffer(boolean isInverter) {
        super(isInverter ? "Controlled Inverter" : "Controlled Buffer", isInverter ? Strings.S.getter("controlledInverterComponent") : Strings.S.getter("controlledBufferComponent"), new ControlledBufferHdlGenerator());
        this.isInverter = isInverter;
        if (isInverter) {
            this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.WIDTH, NotGate.ATTR_SIZE, ATTR_CONTROL, StdAttr.LABEL, StdAttr.LABEL_FONT}, new Object[]{Direction.EAST, BitWidth.ONE, NotGate.SIZE_WIDE, RIGHT_HANDED, "", StdAttr.DEFAULT_LABEL_FONT});
        } else {
            this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.WIDTH, ATTR_CONTROL, StdAttr.LABEL, StdAttr.LABEL_FONT}, new Object[]{Direction.EAST, BitWidth.ONE, RIGHT_HANDED, "", StdAttr.DEFAULT_LABEL_FONT});
        }
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
    }

    public boolean isInverter() {
        return this.isInverter;
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.configurePorts(instance);
        NotGate.configureLabel(instance, false, instance.getPortLocation(2));
    }

    private void configurePorts(Instance instance) {
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        Bounds bds = this.getOffsetBounds(instance.getAttributeSet());
        int d = Math.max(bds.getWidth(), bds.getHeight()) - 20;
        Location loc0 = Location.create(0, 0, true);
        Location loc1 = loc0.translate(facing.reverse(), 20 + d);
        Location loc2 = instance.getAttributeValue(ATTR_CONTROL) == LEFT_HANDED ? loc0.translate(facing.reverse(), 10 + d, 10) : loc0.translate(facing.reverse(), 10 + d, -10);
        Port[] ports = new Port[]{new Port(0, 0, "output", StdAttr.WIDTH), new Port(loc1.getX(), loc1.getY(), "input", StdAttr.WIDTH), new Port(loc2.getX(), loc2.getY(), "input", 1)};
        instance.setPorts(ports);
    }

    @Override
    public Object getInstanceFeature(Instance instance, Object key) {
        if (key == WireRepair.class) {
            return data -> {
                Location port2 = instance.getPortLocation(2);
                return data.getPoint().equals(port2);
            };
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing;
        int w = 20;
        if (this.isInverter && !NotGate.SIZE_NARROW.equals(attrs.getValue(NotGate.ATTR_SIZE))) {
            w = 30;
        }
        if ((facing = attrs.getValue(StdAttr.FACING)) == Direction.NORTH) {
            return Bounds.create(-10, 0, 20, w);
        }
        if (facing == Direction.SOUTH) {
            return Bounds.create(-10, -w, 20, w);
        }
        if (facing == Direction.WEST) {
            return Bounds.create(0, -10, w, 20);
        }
        return Bounds.create(-w, -10, w, 20);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == NotGate.ATTR_SIZE) {
            instance.recomputeBounds();
            this.configurePorts(instance);
            NotGate.configureLabel(instance, false, instance.getPortLocation(2));
        } else if (attr == ATTR_CONTROL) {
            this.configurePorts(instance);
            NotGate.configureLabel(instance, false, instance.getPortLocation(2));
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paintShape(painter);
    }

    @Override
    public void paintIcon(InstancePainter painter) {
        Graphics2D g = (Graphics2D)painter.getGraphics();
        if (painter.getGateShape() == "rectangular") {
            AbstractGate.paintIconIEC(g, "EN1", this.isInverter, false);
        } else {
            AbstractGate.paintIconBufferAnsi(g, this.isInverter, true);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Direction face = painter.getAttributeValue(StdAttr.FACING);
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 3);
        Location pt0 = painter.getInstance().getPortLocation(2);
        Location pt1 = painter.getAttributeValue(ATTR_CONTROL) == LEFT_HANDED ? pt0.translate(face, 0, 6) : pt0.translate(face, 0, -6);
        if (painter.getShowState()) {
            g.setColor(painter.getPortValue(2).getColor());
        }
        g.drawLine(pt0.getX(), pt0.getY(), pt1.getX(), pt1.getY());
        g.setColor(Color.BLACK);
        this.paintShape(painter);
        if (!painter.isPrintView()) {
            painter.drawPort(0);
            painter.drawPort(1);
        }
        painter.drawLabel();
    }

    private void paintShape(InstancePainter painter) {
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        double rotate = 0.0;
        Graphics g = painter.getGraphics();
        g.translate(x, y);
        if (facing != Direction.EAST && g instanceof Graphics2D) {
            rotate = -facing.toRadians();
            ((Graphics2D)g).rotate(rotate);
        }
        if (this.isInverter) {
            PainterShaped.paintNot(painter);
        } else {
            GraphicsUtil.switchToWidth(g, 2);
            int d = this.isInverter ? 10 : 0;
            int[] xp = new int[]{-d, -19 - d, -19 - d, -d};
            int[] yp = new int[]{0, -7, 7, 0};
            g.drawPolyline(xp, yp, 4);
        }
        if (rotate != 0.0) {
            ((Graphics2D)g).rotate(-rotate);
        }
        g.translate(-x, -y);
    }

    @Override
    public void propagate(InstanceState state) {
        Value control = state.getPortValue(2);
        BitWidth width = state.getAttributeValue(StdAttr.WIDTH);
        if (control == Value.TRUE) {
            Value in = state.getPortValue(1);
            state.setPort(0, this.isInverter ? in.not() : in.not().not(), 1);
        } else if (control == Value.ERROR || control == Value.UNKNOWN) {
            state.setPort(0, Value.createError(width), 1);
        } else {
            AttributeSet opts;
            Value out = control == Value.UNKNOWN || control == Value.NIL ? ((opts = state.getProject().getOptions().getAttributeSet()).getValue(Options.ATTR_GATE_UNDEFINED).equals(Options.GATE_UNDEFINED_ERROR) ? Value.createError(width) : Value.createUnknown(width)) : Value.createUnknown(width);
            state.setPort(0, out, 1);
        }
    }
}

