/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.NegateAttribute;
import java.util.AbstractList;

class GateAttributeList
extends AbstractList<Attribute<?>> {
    private static final Attribute<?>[] BASE_ATTRIBUTES = new Attribute[]{StdAttr.FACING, StdAttr.WIDTH, GateAttributes.ATTR_SIZE, GateAttributes.ATTR_INPUTS, GateAttributes.ATTR_OUTPUT, StdAttr.LABEL, StdAttr.LABEL_FONT};
    private final GateAttributes attrs;

    public GateAttributeList(GateAttributes attrs) {
        this.attrs = attrs;
    }

    @Override
    public Attribute<?> get(int index) {
        int len = BASE_ATTRIBUTES.length;
        if (index < len) {
            return BASE_ATTRIBUTES[index];
        }
        index -= len;
        if (this.attrs.xorBehave != null && --index < 0) {
            return GateAttributes.ATTR_XOR;
        }
        Direction facing = this.attrs.facing;
        int inputs = this.attrs.inputs;
        if (index == 0) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return new NegateAttribute(index, Direction.NORTH);
            }
            return new NegateAttribute(index, Direction.WEST);
        }
        if (index == inputs - 1) {
            if (facing == Direction.EAST || facing == Direction.WEST) {
                return new NegateAttribute(index, Direction.SOUTH);
            }
            return new NegateAttribute(index, Direction.EAST);
        }
        if (index < inputs) {
            return new NegateAttribute(index, null);
        }
        return null;
    }

    @Override
    public int size() {
        int ret = BASE_ATTRIBUTES.length;
        if (this.attrs.xorBehave != null) {
            ++ret;
        }
        return ret += this.attrs.inputs;
    }
}

