/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.circuit.ExpressionComputer;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractBufferHdlGenerator;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.Buffer;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

class NotGate
extends InstanceFactory {
    public static final String _ID = "NOT Gate";
    public static final AttributeOption SIZE_NARROW = new AttributeOption(20, Strings.S.getter("gateSizeNarrowOpt"));
    public static final AttributeOption SIZE_WIDE = new AttributeOption(30, Strings.S.getter("gateSizeWideOpt"));
    public static final Attribute<AttributeOption> ATTR_SIZE = Attributes.forOption("size", Strings.S.getter("gateSizeAttr"), new AttributeOption[]{SIZE_NARROW, SIZE_WIDE});
    private static final String RECT_LABEL = "1";
    public static final InstanceFactory FACTORY = new NotGate();

    static void configureLabel(Instance instance, boolean isRectangular, Location control) {
        int halign;
        int y;
        int x;
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        Bounds bds = instance.getBounds();
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            x = bds.getX() + bds.getWidth() / 2 + 2;
            y = bds.getY() - 2;
            halign = -1;
        } else {
            int n = y = isRectangular ? bds.getY() - 2 : bds.getY();
            if (control != null && control.getY() == bds.getY()) {
                x = control.getX() + 2;
                halign = -1;
            } else {
                x = bds.getX() + bds.getWidth() / 2;
                halign = 0;
            }
        }
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, x, y, halign, 1);
    }

    private NotGate() {
        super(_ID, Strings.S.getter("notGateComponent"), new AbstractBufferHdlGenerator(true));
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.WIDTH, ATTR_SIZE, GateAttributes.ATTR_OUTPUT, StdAttr.LABEL, StdAttr.LABEL_FONT}, new Object[]{Direction.EAST, BitWidth.ONE, SIZE_WIDE, GateAttributes.OUTPUT_01, "", StdAttr.DEFAULT_LABEL_FONT});
        this.setFacingAttribute(StdAttr.FACING);
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        instance.addAttributeListener();
        String gateShape = AppPreferences.GATE_SHAPE.get();
        NotGate.configureLabel(instance, gateShape.equals("rectangular"), null);
    }

    private void configurePorts(Instance instance) {
        AttributeOption size = instance.getAttributeValue(ATTR_SIZE);
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        int dx = size == SIZE_NARROW ? -20 : -30;
        Port[] ports = new Port[2];
        ports[0] = new Port(0, 0, "output", StdAttr.WIDTH);
        Location out = Location.create(0, 0, true).translate(facing, dx);
        ports[1] = new Port(out.getX(), out.getY(), "input", StdAttr.WIDTH);
        instance.setPorts(ports);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder CompleteName = new StringBuilder();
        CompleteName.append(CorrectLabel.getCorrectLabel(this.getName()).toUpperCase());
        BitWidth width = attrs.getValue(StdAttr.WIDTH);
        if (width.getWidth() > 1) {
            CompleteName.append("_BUS");
        }
        return CompleteName.toString();
    }

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == ExpressionComputer.class) {
            return expressionMap -> {
                int width = instance.getAttributeValue(StdAttr.WIDTH).getWidth();
                for (int b = 0; b < width; ++b) {
                    Expression e = expressionMap.get(instance.getPortLocation(1), b);
                    if (e == null) continue;
                    expressionMap.put(instance.getPortLocation(0), b, Expressions.not(e));
                }
            };
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        AttributeOption value = attrs.getValue(ATTR_SIZE);
        if (value == SIZE_NARROW) {
            Direction facing = attrs.getValue(StdAttr.FACING);
            if (facing == Direction.SOUTH) {
                return Bounds.create(-9, -20, 18, 20);
            }
            if (facing == Direction.NORTH) {
                return Bounds.create(-9, 0, 18, 20);
            }
            if (facing == Direction.WEST) {
                return Bounds.create(0, -9, 20, 18);
            }
            return Bounds.create(-20, -9, 20, 18);
        }
        Direction facing = attrs.getValue(StdAttr.FACING);
        if (facing == Direction.SOUTH) {
            return Bounds.create(-9, -30, 18, 30);
        }
        if (facing == Direction.NORTH) {
            return Bounds.create(-9, 0, 18, 30);
        }
        if (facing == Direction.WEST) {
            return Bounds.create(0, -9, 30, 18);
        }
        return Bounds.create(-30, -9, 30, 18);
    }

    @Override
    public boolean hasThreeStateDrivers(AttributeSet attrs) {
        if (attrs.containsAttribute(GateAttributes.ATTR_OUTPUT)) {
            return attrs.getValue(GateAttributes.ATTR_OUTPUT) != GateAttributes.OUTPUT_01;
        }
        return false;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == ATTR_SIZE || attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.configurePorts(instance);
            String gateShape = AppPreferences.GATE_SHAPE.get();
            NotGate.configureLabel(instance, gateShape.equals("rectangular"), null);
        }
    }

    private void paintBase(InstancePainter painter) {
        Object shape;
        Graphics g = painter.getGraphics();
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        g.translate(x, y);
        double rotate = 0.0;
        if (facing != null && facing != Direction.EAST && g instanceof Graphics2D) {
            rotate = -facing.toRadians();
            ((Graphics2D)g).rotate(rotate);
        }
        if ((shape = painter.getGateShape()) == "rectangular") {
            this.paintRectangularBase(g, painter);
        } else {
            PainterShaped.paintNot(painter);
        }
        if (rotate != 0.0) {
            ((Graphics2D)g).rotate(-rotate);
        }
        g.translate(-x, -y);
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paintBase(painter);
    }

    @Override
    public void paintIcon(InstancePainter painter) {
        Graphics2D g = (Graphics2D)painter.getGraphics();
        if (painter.getGateShape() == "rectangular") {
            AbstractGate.paintIconIEC(g, RECT_LABEL, true, true);
        } else {
            AbstractGate.paintIconBufferAnsi(g, true, false);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.getGraphics().setColor(Color.BLACK);
        this.paintBase(painter);
        painter.drawPorts();
        painter.drawLabel();
    }

    private void paintRectangularBase(Graphics g, InstancePainter painter) {
        GraphicsUtil.switchToWidth(g, 2);
        if (painter.getAttributeValue(ATTR_SIZE) == SIZE_NARROW) {
            g.drawRect(-20, -9, 14, 18);
            GraphicsUtil.drawCenteredText(g, RECT_LABEL, -13, 0);
            g.drawOval(-6, -3, 6, 6);
        } else {
            g.drawRect(-30, -9, 20, 18);
            GraphicsUtil.drawCenteredText(g, RECT_LABEL, -20, 0);
            g.drawOval(-10, -5, 9, 9);
        }
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        Value in = state.getPortValue(1);
        Value out = in.not();
        out = Buffer.repair(state, out);
        state.setPort(0, out, 1);
    }
}

