/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.AbstractGateHdlGenerator;
import com.cburch.logisim.std.gates.GateFunctions;
import com.cburch.logisim.std.gates.PainterDin;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.tools.WireRepairData;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

class OrGate
extends AbstractGate {
    public static final OrGate FACTORY = new OrGate();

    private OrGate() {
        super("OR Gate", Strings.S.getter("orGateComponent"), new OrGateHdlGeneratorFactory());
        this.setRectangularLabel("\u22651");
        this.setPaintInputLines(true);
    }

    @Override
    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        Expression ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = Expressions.or(ret, inputs[i]);
        }
        return ret;
    }

    @Override
    protected Value computeOutput(Value[] inputs, int numInputs, InstanceState state) {
        return GateFunctions.computeOr(inputs, numInputs);
    }

    @Override
    protected Value getIdentity() {
        return Value.FALSE;
    }

    @Override
    protected void paintDinShape(InstancePainter painter, int width, int height, int inputs) {
        PainterDin.paintOr(painter, width, height, false);
    }

    @Override
    public void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize) {
        OrGate.paintIconANSI(g, iconSize, borderSize, negateSize, false);
    }

    protected static void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize, boolean inverted) {
        int ystart = negateSize >> 1;
        int yend = iconSize - ystart;
        boolean xstart = false;
        int xend = iconSize - negateSize;
        GeneralPath shape = new GeneralPath();
        shape.moveTo(xend, iconSize >> 1);
        shape.quadTo(2 * xend / 3, ystart, 0.0f, ystart);
        shape.quadTo(xend / 3, iconSize >> 1, 0.0f, yend);
        shape.quadTo(2 * xend / 3, yend, xend, iconSize >> 1);
        shape.closePath();
        AffineTransform af = g.getTransform();
        g.translate(borderSize, borderSize);
        g.draw(shape);
        OrGate.paintIconPins(g, iconSize, borderSize, negateSize, inverted, false);
        g.setTransform(af);
    }

    @Override
    protected void paintShape(InstancePainter painter, int width, int height) {
        PainterShaped.paintOr(painter, width, height);
    }

    @Override
    protected boolean shouldRepairWire(Instance instance, WireRepairData data) {
        return !data.getPoint().equals(instance.getLocation());
    }

    private static class OrGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private OrGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
            LineBuffer contents = LineBuffer.getHdlBuffer();
            StringBuilder oneLine = new StringBuilder();
            oneLine.append(Hdl.assignPreamble()).append("result").append(Hdl.assignOperator());
            int tabWidth = oneLine.length();
            boolean first = true;
            for (int i = 0; i < nrOfInputs; ++i) {
                if (!first) {
                    oneLine.append(Hdl.orOperator());
                    contents.add(oneLine.toString());
                    oneLine.setLength(0);
                    oneLine.append(" ".repeat(tabWidth));
                } else {
                    first = false;
                }
                oneLine.append("s_realInput").append(i + 1);
            }
            oneLine.append(";");
            contents.add(oneLine.toString());
            return contents;
        }
    }
}

