/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.PlaHdlGeneratorFactory;
import com.cburch.logisim.std.gates.PlaTable;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class Pla
extends InstanceFactory {
    public static final String _ID = "PLA";
    static final int IN_PORT = 0;
    static final int OUT_PORT = 1;
    static final Attribute<BitWidth> ATTR_IN_WIDTH = Attributes.forBitWidth("in_width", Strings.S.getter("plaBitWidthIn"));
    static final Attribute<BitWidth> ATTR_OUT_WIDTH = Attributes.forBitWidth("out_width", Strings.S.getter("plaBitWidthOut"));
    static final Attribute<PlaTable> ATTR_TABLE = new TruthTableAttribute();
    public static final InstanceFactory FACTORY = new Pla();
    private static final Color BACKGROUND_COLOR = new Color(230, 230, 230);
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(StdAttr.FACING, ATTR_IN_WIDTH, ATTR_OUT_WIDTH, ATTR_TABLE, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT);

    public Pla() {
        super(_ID, Strings.S.getter(_ID), new PlaHdlGeneratorFactory(), true);
        this.setIconName("pla.gif");
        this.setFacingAttribute(StdAttr.FACING);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new PLAAttributes();
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        super.configureNewInstance(instance);
        PLAAttributes attributes = (PLAAttributes)instance.getAttributeSet();
        attributes.tt = new PlaTable(instance.getAttributeValue(ATTR_TABLE));
        attributes.tt.setLabel(instance.getAttributeValue(StdAttr.LABEL));
        instance.addAttributeListener();
        this.updatePorts(instance);
        instance.computeLabelTextField(10);
    }

    private void updatePorts(Instance instance) {
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        int dx = 0;
        int dy = 0;
        if (dir == Direction.WEST) {
            dx = -50;
        } else if (dir == Direction.NORTH) {
            dy = -50;
        } else if (dir == Direction.SOUTH) {
            dy = 50;
        } else {
            dx = 50;
        }
        Port[] ps = new Port[]{new Port(0, 0, "input", ATTR_IN_WIDTH), new Port(dx, dy, "output", ATTR_OUT_WIDTH)};
        ps[0].setToolTip(Strings.S.getter("input"));
        ps[1].setToolTip(Strings.S.getter("output"));
        instance.setPorts(ps);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING || attr == ATTR_IN_WIDTH || attr == ATTR_OUT_WIDTH || attr == StdAttr.LABEL || attr == StdAttr.LABEL_LOC) {
            instance.recomputeBounds();
            instance.computeLabelTextField(10);
            this.updatePorts(instance);
        } else if (attr == ATTR_TABLE) {
            instance.fireInvalidated();
        }
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth outWidth = state.getAttributeValue(ATTR_OUT_WIDTH);
        PlaTable tt = state.getAttributeValue(ATTR_TABLE);
        Value input = state.getPortValue(0);
        long val = tt.valueFor(input.toLongValue());
        state.setPort(1, Value.createKnown(outWidth, val), 1);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction dir = attrs.getValue(StdAttr.FACING);
        return Bounds.create(0, -25, 50, 50).rotate(Direction.EAST, dir, 0, 0);
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paintInstance(painter, true);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        this.paintInstance(painter, false);
    }

    void paintInstance(InstancePainter painter, boolean ghost) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        int w = bds.getWidth();
        int h = bds.getHeight();
        if (!ghost && painter.shouldDrawColor()) {
            g.setColor(BACKGROUND_COLOR);
            g.fillRect(x, y, w, h);
        }
        if (!ghost) {
            g.setColor(Color.BLACK);
        }
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(x, y, bds.getWidth(), bds.getHeight());
        g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
        GraphicsUtil.drawCenteredText(g, _ID, x + w / 2, y + h / 3);
        if (!ghost) {
            if (painter.getShowState()) {
                Value input;
                PlaTable tt = painter.getAttributeValue(ATTR_TABLE);
                String comment = tt.commentFor((input = painter.getPortValue(0)).toLongValue());
                int jj = comment.indexOf("#");
                if (jj >= 0) {
                    comment = comment.substring(0, jj).trim();
                }
                GraphicsUtil.drawCenteredText(g, comment, x + w / 2, y + 2 * h / 3);
            }
            painter.drawLabel();
            painter.drawPorts();
        }
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        String name = CorrectLabel.getCorrectLabel(attrs.getValue(StdAttr.LABEL));
        if (name.length() == 0) {
            return _ID;
        }
        return "PLA_" + name;
    }

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == MenuExtender.class) {
            return new PLAMenu(this, instance);
        }
        return super.getInstanceFeature(instance, key);
    }

    private static class PLAAttributes
    extends AbstractAttributeSet {
        private String label = "";
        private Direction facing = Direction.EAST;
        private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
        private Object labelLoc = Direction.NORTH;
        private BitWidth widthIn = BitWidth.create(2);
        private BitWidth widthOut = BitWidth.create(2);
        private PlaTable tt = new PlaTable(2, 2, "PLA");

        private PLAAttributes() {
        }

        @Override
        protected void copyInto(AbstractAttributeSet destObj) {
            PLAAttributes dest = (PLAAttributes)destObj;
            dest.label = this.label;
            dest.facing = this.facing;
            dest.labelFont = this.labelFont;
            dest.labelLoc = this.labelLoc;
            dest.widthIn = this.widthIn;
            dest.widthOut = this.widthOut;
            dest.tt = new PlaTable(this.tt);
            dest.tt.setLabel(dest.label);
        }

        @Override
        public List<Attribute<?>> getAttributes() {
            return ATTRIBUTES;
        }

        @Override
        public <V> V getValue(Attribute<V> attr) {
            if (attr == StdAttr.FACING) {
                return (V)this.facing;
            }
            if (attr == ATTR_IN_WIDTH) {
                return (V)this.widthIn;
            }
            if (attr == ATTR_OUT_WIDTH) {
                return (V)this.widthOut;
            }
            if (attr == ATTR_TABLE) {
                return (V)this.tt;
            }
            if (attr == StdAttr.LABEL) {
                return (V)this.label;
            }
            if (attr == StdAttr.LABEL_LOC) {
                return (V)this.labelLoc;
            }
            if (attr == StdAttr.LABEL_FONT) {
                return (V)this.labelFont;
            }
            return null;
        }

        @Override
        public <V> void setValue(Attribute<V> attr, V value) {
            if (attr == StdAttr.LABEL_LOC) {
                this.labelLoc = value;
            } else if (attr == StdAttr.FACING) {
                this.facing = (Direction)value;
            } else if (attr == ATTR_IN_WIDTH) {
                this.widthIn = (BitWidth)value;
                this.tt.setInSize(this.widthIn.getWidth());
            } else if (attr == ATTR_OUT_WIDTH) {
                this.widthOut = (BitWidth)value;
                this.tt.setOutSize(this.widthOut.getWidth());
            } else if (attr == ATTR_TABLE) {
                this.tt = (PlaTable)value;
                this.tt.setLabel(this.label);
                if (this.tt.inSize() != this.widthIn.getWidth()) {
                    this.setValue(ATTR_IN_WIDTH, BitWidth.create(this.tt.inSize()));
                }
                if (this.tt.outSize() != this.widthOut.getWidth()) {
                    this.setValue(ATTR_OUT_WIDTH, BitWidth.create(this.tt.outSize()));
                }
            } else if (attr == StdAttr.LABEL) {
                this.label = (String)value;
                this.tt.setLabel(this.label);
            } else if (attr == StdAttr.LABEL_FONT) {
                this.labelFont = (Font)value;
            }
            this.fireAttributeValueChanged(attr, value, null);
        }
    }

    static class PLAMenu
    implements ActionListener,
    MenuExtender {
        private final Instance instance;
        private Frame frame;
        private JMenuItem edit;

        PLAMenu(Pla factory, Instance instance) {
            this.instance = instance;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == this.edit) {
                this.doEdit();
            }
        }

        @Override
        public void configureMenu(JPopupMenu menu, Project proj) {
            this.frame = proj.getFrame();
            this.edit = new JMenuItem(Strings.S.get("plaEditMenuItem"));
            this.edit.setEnabled(true);
            this.edit.addActionListener(this);
            menu.addSeparator();
            menu.add(this.edit);
        }

        private void doEdit() {
            PlaTable tt = this.instance.getAttributeValue(ATTR_TABLE);
            PlaTable.EditorDialog dialog = new PlaTable.EditorDialog(this.frame);
            dialog.setValue(tt);
            dialog.setVisible(true);
            dialog.toFront();
        }
    }

    private static class TruthTableAttribute
    extends Attribute<PlaTable> {
        public TruthTableAttribute() {
            super("table", Strings.S.getter("plaProgram"));
        }

        @Override
        public Component getCellEditor(Window source, PlaTable tt) {
            PlaTable.EditorDialog dialog = new PlaTable.EditorDialog((Frame)source);
            dialog.setValue(tt);
            return dialog;
        }

        @Override
        public String toDisplayString(PlaTable value) {
            return Strings.S.get("plaClickToEdit");
        }

        @Override
        public String toStandardString(PlaTable tt) {
            return tt.toStandardString();
        }

        @Override
        public PlaTable parse(String str) {
            return PlaTable.parse(str);
        }
    }
}

